/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.List;
import java.util.regex.Matcher;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;

public class PatternsChecker
extends AbstractChecker {
    private List<PatternItem> patterns;

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
        this.patterns = params.getPatterns();
        for (PatternItem item : this.patterns) {
            if (!item.enabled) continue;
            item.compile();
        }
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null) {
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null || !this.getParams().getCheckPatterns()) continue;
            this.checkPatterns(srcSeg, trgSeg, tu);
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private String getPatternPartForDisplay(String part) {
        part = part.replace("\n", "\\n");
        part = part.replace("\r", "\\r");
        return part;
    }

    private void checkPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String msg;
        boolean expectSame;
        boolean found;
        int end;
        int start;
        String srcCText = srcSeg.text.getCodedText();
        for (PatternItem item : this.patterns) {
            if (!item.enabled || !item.fromSource) continue;
            Matcher srcM = item.getSourcePattern().matcher(srcCText);
            StringBuilder trgCTextCopy = new StringBuilder(trgSeg.text.getCodedText());
            int from = 0;
            while (srcM.find(from)) {
                String srcPart = srcCText.substring(srcM.start(), srcM.end());
                start = 0;
                end = 0;
                found = false;
                expectSame = item.target.equals("<same>");
                if (expectSame) {
                    start = trgCTextCopy.indexOf(srcPart);
                    boolean bl = found = start != -1;
                    if (found) {
                        end = start + srcPart.length();
                    }
                } else {
                    Matcher trgM = item.getTargetPattern().matcher(trgCTextCopy);
                    found = trgM.find();
                    if (found) {
                        start = trgM.start();
                        end = trgM.end();
                    }
                }
                if (found) {
                    trgCTextCopy.delete(start, end);
                } else {
                    msg = expectSame ? String.format("The source part \"%s\" is not in the target", this.getPatternPartForDisplay(srcPart)) : String.format("The source part \"%s\" has no correspondence in the target", this.getPatternPartForDisplay(srcPart));
                    if (!Util.isEmpty(item.description)) {
                        msg = msg + " (from rule: " + item.description + ").";
                    }
                    this.addAnnotationAndReportIssue(IssueType.UNEXPECTED_PATTERN, tu, tu.getSource(), srcSeg.getId(), msg, TextFragment.fromFragmentToString(srcSeg.text, srcM.start()), TextFragment.fromFragmentToString(srcSeg.text, srcM.end()), 0, -1, Issue.displaySeverityToSeverity(item.severity), srcSeg.toString(), trgSeg.toString(), null);
                }
                from = srcM.end();
            }
        }
        String trgCText = trgSeg.text.getCodedText();
        for (PatternItem item : this.patterns) {
            if (!item.enabled || item.fromSource) continue;
            Matcher trgM = item.getTargetPattern().matcher(trgCText);
            StringBuilder srcCTextCopy = new StringBuilder(srcSeg.text.getCodedText());
            while (trgM.find()) {
                String trgPart = trgCText.substring(trgM.start(), trgM.end());
                start = 0;
                end = 0;
                found = false;
                expectSame = item.source.equals("<same>");
                if (expectSame) {
                    start = srcCTextCopy.indexOf(trgPart);
                    boolean bl = found = start != -1;
                    if (found) {
                        end = start + trgPart.length();
                    }
                } else {
                    Matcher srcM = item.getSourcePattern().matcher(srcCTextCopy);
                    found = srcM.find();
                    if (found) {
                        start = srcM.start();
                        end = srcM.end();
                    }
                }
                if (found) {
                    srcCTextCopy.delete(start, end);
                    continue;
                }
                msg = expectSame ? String.format("The target part \"%s\" is not in the source.", trgPart) : String.format("The target part \"%s\" has no correspondence in the source.", trgPart);
                if (!Util.isEmpty(item.description)) {
                    msg = msg + " (from rule: " + item.description + ").";
                }
                this.addAnnotationAndReportIssue(IssueType.UNEXPECTED_PATTERN, tu, tu.getTarget(this.getTrgLoc()), srcSeg.getId(), msg, 0, -1, TextFragment.fromFragmentToString(trgSeg.text, trgM.start()), TextFragment.fromFragmentToString(trgSeg.text, trgM.end()), Issue.displaySeverityToSeverity(item.severity), srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }
}

