/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.sentencealigner;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.gcaligner.GaleAndChurch;
import net.sf.okapi.steps.sentencealigner.Parameters;
import net.sf.okapi.steps.sentencealigner.SentenceAligner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class SentenceAlignerStep
extends BasePipelineStep
implements IObserver {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private IFilter filter = null;
    private XMLWriter writer;
    private TMXWriter tmx;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private LocaleId sourceLocale;
    private RawDocument targetInput = null;
    private SentenceAligner sentenceAligner;
    private ISegmenter sourceSegmenter;
    private ISegmenter targetSegmenter;

    public SentenceAlignerStep() {
        LinkedList<AlignmentScorer<Segment>> scorerList = new LinkedList<AlignmentScorer<Segment>>();
        scorerList.add(new GaleAndChurch());
        this.sentenceAligner = new SentenceAligner(scorerList);
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @Override
    public String getName() {
        return "Sentence Alignment";
    }

    @Override
    public String getDescription() {
        return "Aligns sentences within text units (paragraphs). Produces sentence alignments as bilingual text units or a TMX file.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        InputStream is;
        boolean loadDefault = true;
        SRXDocument srxDocument = new SRXDocument();
        if (this.params.isSegmentSource()) {
            if (this.params.isUseCustomSourceRules()) {
                try {
                    srxDocument.loadRules(this.params.getCustomSourceRulesPath());
                    loadDefault = false;
                }
                catch (Exception e) {
                    this.LOGGER.warn("Custom source segmentation rules file '{}' cannot be read.\nUsing the default rules instead.", (Object)this.params.getCustomSourceRulesPath());
                }
            }
            if (loadDefault) {
                is = SentenceAlignerStep.class.getResourceAsStream("/net/sf/okapi/steps/gcaligner/default.srx");
                srxDocument.loadRules(is);
            }
            this.sourceSegmenter = srxDocument.compileLanguageRules(this.sourceLocale, null);
        }
        if (this.params.isSegmentTarget()) {
            loadDefault = true;
            if (this.params.isUseCustomTargetRules()) {
                try {
                    srxDocument.loadRules(this.params.getCustomTargetRulesPath());
                    loadDefault = false;
                }
                catch (Exception e) {
                    this.LOGGER.warn("Custom target segmentation rules file '{}' cannot be read.\nUsing the default rules instead.", (Object)this.params.getCustomTargetRulesPath());
                }
            }
            if (loadDefault) {
                is = SentenceAlignerStep.class.getResourceAsStream("/net/sf/okapi/steps/gcaligner/default.srx");
                srxDocument.loadRules(is);
            }
            this.targetSegmenter = srxDocument.compileLanguageRules(this.targetLocale, null);
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.tmx != null) {
            this.tmx.writeEndDocument();
            this.tmx.close();
            this.tmx = null;
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput != null) {
            this.initializeFilter();
        }
        if (this.tmx == null && this.params.isGenerateTMX()) {
            String mimeType = event.getStartDocument().getMimeType();
            this.tmx = new TMXWriter(this.params.getTmxOutputPath());
            this.tmx.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), null, "sentence", null, mimeType);
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.filter != null) {
            this.filter.close();
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        ITextUnit alignedTextUnit;
        ITextUnit sourceTu = sourceEvent.getTextUnit();
        ITextUnit targetTu = null;
        if (!sourceTu.isTranslatable() || sourceTu.isEmpty()) {
            return sourceEvent;
        }
        if (this.targetInput != null) {
            Iterator<Segment> targetEvent = this.synchronize(EventType.TEXT_UNIT, sourceTu);
            targetTu = ((Event)((Object)targetEvent)).getTextUnit();
        }
        if (this.params.isCollapseWhitespace()) {
            for (TextPart p : sourceTu.getSource().getSegments()) {
                p.text.collapseWhitespace();
            }
            if (this.targetInput == null) {
                for (TextPart p : sourceTu.getTarget(this.targetLocale).getSegments()) {
                    p.text.collapseWhitespace();
                }
            } else {
                for (TextPart p : targetTu.getSource().getSegments()) {
                    p.text.collapseWhitespace();
                }
            }
        }
        if (this.params.isSegmentSource()) {
            sourceTu.createSourceSegmentation(this.sourceSegmenter);
        }
        if (this.params.isSegmentTarget()) {
            if (targetTu == null) {
                sourceTu.createTargetSegmentation(this.targetSegmenter, this.targetLocale);
            } else {
                targetTu.createSourceSegmentation(this.targetSegmenter);
            }
        }
        if (this.params.isForceSimpleOneToOneAlignment()) {
            alignedTextUnit = sourceTu;
            if (this.targetInput == null) {
                if (alignedTextUnit.getSourceSegments().count() != alignedTextUnit.getTargetSegments(this.targetLocale).count()) {
                    alignedTextUnit.getSource().joinAll();
                    alignedTextUnit.getTarget(this.targetLocale).joinAll();
                }
                alignedTextUnit.getAlignedSegments().align(this.targetLocale);
            } else {
                if (alignedTextUnit.getSourceSegments().count() != targetTu.getSourceSegments().count()) {
                    alignedTextUnit.getSource().joinAll();
                    targetTu.getSource().joinAll();
                }
                LinkedList<AlignedPair> alignedPairs = new LinkedList<AlignedPair>();
                Iterator<Segment> targetSegments = targetTu.getSourceSegments().iterator();
                for (Segment sourceSegment : alignedTextUnit.getSourceSegments()) {
                    alignedPairs.add(new AlignedPair(sourceSegment, targetSegments.next(), this.targetLocale));
                }
                alignedTextUnit.getAlignedSegments().align(alignedPairs, this.targetLocale);
            }
        } else {
            alignedTextUnit = this.targetInput == null ? this.sentenceAligner.align(sourceTu, this.sourceLocale, this.targetLocale, this.params.isOutputOneTOneMatchesOnly()) : this.sentenceAligner.align(sourceTu, targetTu, this.sourceLocale, this.targetLocale, this.params.isOutputOneTOneMatchesOnly());
        }
        TextUnitUtil.trimSegments(alignedTextUnit.getSource());
        TextUnitUtil.trimSegments(alignedTextUnit.getTarget(this.targetLocale));
        IAlignedSegments segments = alignedTextUnit.getAlignedSegments();
        for (Segment s : segments) {
            Segment t = segments.getCorrespondingTarget(s, this.targetLocale);
            s.text.alignCodeIds(t.text);
            TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(s.text, t.text, true, false, null, alignedTextUnit);
        }
        if (this.params.isGenerateTMX()) {
            this.tmx.writeTUFull(alignedTextUnit);
        }
        return new Event(EventType.TEXT_UNIT, alignedTextUnit);
    }

    @Override
    protected Event handlePipelineParameters(Event sourceEvent) {
        PipelineParameters pp = new PipelineParameters();
        this.setSecondInput(pp.getSecondInputRawDocument());
        return Event.NOOP_EVENT;
    }

    private void initializeFilter() {
        this.filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);
        this.filter.open(this.targetInput);
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private Event synchronize(EventType untilType, ITextUnit sourceTu) {
        boolean found = false;
        Event event = null;
        while (!found && this.filter.hasNext()) {
            ITextUnit stu;
            event = this.filter.next();
            if (event.isTextUnit() && (!(stu = event.getTextUnit()).isTranslatable() || stu.isEmpty())) continue;
            found = event.getEventType() == untilType;
        }
        if (!found) {
            if (this.params.isGenerateTMX() && this.tmx != null) {
                this.tmx.writeEndDocument();
                this.tmx.close();
                this.tmx = null;
            }
            String targetDoc = this.targetInput == null ? "null" : this.targetInput.getInputURI().toString();
            throw new OkapiException("Different number of source or target TextUnits. The source and target documents are not paragraph aligned at:\nSource: " + sourceTu.getName() + " <> " + sourceTu.getSource().toString() + "\nTarget Document: " + targetDoc);
        }
        return event;
    }

    @Override
    public void update(IObservable o, Object event) {
    }
}

