/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.terminologyleveraging;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GlossEntry;
import net.sf.okapi.common.annotation.GlossaryAnnotation;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.steps.terminologyleveraging.IGlossaryElementIdGenerator;
import net.sf.okapi.steps.terminologyleveraging.ITerminologyQuery;
import net.sf.okapi.steps.terminologyleveraging.TerminologyQueryResult;

public abstract class BaseTerminologyConnector
implements ITerminologyQuery,
IGlossaryElementIdGenerator {
    public static String GLOSS_ENTRY_SEPARATOR_CHAR = "-";
    public static String GLOSS_ENTRY_TRANSLATION_ID_SEPARATOR_CHAR = "T";
    protected LocaleId srcLoc;
    protected LocaleId trgLoc;
    protected boolean annotateSource = false;
    protected boolean annotateTarget = false;

    protected abstract List<List<TerminologyQueryResult>> query(List<String> var1);

    @Override
    public LocaleId getSourceLanguage() {
        return this.srcLoc;
    }

    @Override
    public LocaleId getTargetLanguage() {
        return this.trgLoc;
    }

    @Override
    public boolean getAnnotateSource() {
        return this.annotateSource;
    }

    @Override
    public boolean getAnnotateTarget() {
        return this.annotateTarget;
    }

    @Override
    public void setAnnotateSource(boolean annotateSource) {
        this.annotateSource = annotateSource;
    }

    @Override
    public void setAnnotateTarget(boolean annotateTarget) {
        this.annotateTarget = annotateTarget;
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("\nSource Locale: %s\nTarget Locale: %s\nAnnotate Source Segment: %s\nAnnotate Target Segment: %s", this.srcLoc, this.trgLoc, this.annotateSource, this.annotateTarget);
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void leverage(ITextUnit unit) {
        if (unit == null || !unit.getSource().hasText() || !unit.isTranslatable()) {
            return;
        }
        ArrayList<String> sourceSegments = new ArrayList<String>();
        for (Segment segment : unit.getSourceSegments()) {
            sourceSegments.add(segment.text.getText());
        }
        List<List<TerminologyQueryResult>> termResults = this.query(sourceSegments);
        this.addGlossaryAnnotations(unit, termResults);
    }

    protected void populateSegmentsWithGlossary(int segmentIndex, Segment sourceSegment, Segment targetSegment, List<TerminologyQueryResult> queryResults) {
        GlossaryAnnotation glossary = new GlossaryAnnotation();
        glossary.setAnnotateSourceSegment(this.getAnnotateSource());
        glossary.setAnnotateTargetSegment(this.getAnnotateTarget());
        int termIndexInSegment = -1;
        for (TerminologyQueryResult result : queryResults) {
            ++termIndexInSegment;
            TerminologyQueryResult.Term term = result.getTerm();
            String termText = term.getTermText();
            if (!sourceSegment.text.getText().contains(termText)) continue;
            GlossEntry existingGlossEntry = this.findExistingGlossEntry(glossary, segmentIndex, termIndexInSegment, term);
            if (existingGlossEntry != null) {
                for (TerminologyQueryResult.Translation translation : result.getTranslations()) {
                    existingGlossEntry.addTranslation(this.toGlossEntryTranslation(segmentIndex, termIndexInSegment, term, translation));
                }
                continue;
            }
            glossary.add(this.toGlossEntry(segmentIndex, termIndexInSegment, result));
        }
        if (!glossary.isEmpty()) {
            sourceSegment.setAnnotation(glossary);
        }
    }

    private void addGlossaryAnnotations(ITextUnit unit, List<List<TerminologyQueryResult>> termResults) {
        ISegments sourceSegments = unit.getSourceSegments();
        ISegments targetSegments = unit.getTargetSegments(this.trgLoc);
        int segmentIndex = -1;
        for (List<TerminologyQueryResult> results : termResults) {
            Segment sourceSegment = sourceSegments.get(++segmentIndex);
            Segment targetSegment = targetSegments.get(segmentIndex);
            if (!sourceSegment.text.hasText(false)) continue;
            this.populateSegmentsWithGlossary(segmentIndex, sourceSegment, targetSegment, results);
        }
    }

    private GlossEntry toGlossEntry(int segmentIndex, int termIndexInSegment, TerminologyQueryResult result) {
        GlossEntry glossEntry = new GlossEntry();
        GlossEntry.Term term = new GlossEntry.Term();
        term.setText(result.getTerm().getTermText());
        term.setSource(result.getTerm().getSource());
        glossEntry.setId(this.generateGlossEntryId(segmentIndex, termIndexInSegment, result.getTerm()));
        glossEntry.setTerm(term);
        for (TerminologyQueryResult.Translation translation : result.getTranslations()) {
            glossEntry.addTranslation(this.toGlossEntryTranslation(segmentIndex, termIndexInSegment, result.getTerm(), translation));
        }
        return glossEntry;
    }

    private GlossEntry.Translation toGlossEntryTranslation(int segmentIndex, int termIndexInSegment, TerminologyQueryResult.Term term, TerminologyQueryResult.Translation result) {
        GlossEntry.Translation translation = new GlossEntry.Translation();
        translation.setId(this.generateGlossEntryTranslationId(segmentIndex, termIndexInSegment, term, result));
        translation.setText(result.getText());
        return translation;
    }

    private GlossEntry findExistingGlossEntry(GlossaryAnnotation glossary, int segmentIndex, int termIndexInSegment, TerminologyQueryResult.Term term) {
        for (GlossEntry glossEntry : glossary) {
            if (!glossEntry.getId().equals(this.generateGlossEntryId(segmentIndex, termIndexInSegment, term))) continue;
            return glossEntry;
        }
        return null;
    }
}

