/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.Project;
import net.sf.okapi.applications.rainbow.Res;
import net.sf.okapi.applications.rainbow.UtilitiesAccess;
import net.sf.okapi.applications.rainbow.UtilitiesAccessItem;
import net.sf.okapi.applications.rainbow.lib.ILog;
import net.sf.okapi.applications.rainbow.utilities.CancelEvent;
import net.sf.okapi.applications.rainbow.utilities.CancelListener;
import net.sf.okapi.applications.rainbow.utilities.IFilterDrivenUtility;
import net.sf.okapi.applications.rainbow.utilities.ISimpleUtility;
import net.sf.okapi.applications.rainbow.utilities.IUtility;
import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.ui.Dialogs;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilityDriver
implements CancelListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ILog log;
    private Project prj;
    private FilterConfigurationMapper mapper;
    private IFilter filter;
    private IUtility utility;
    private IParametersEditor editor;
    private UtilitiesAccessItem pluginItem;
    private UtilitiesAccess plugins;
    private String outputFolder;
    private boolean stopProcess;
    private IHelp help;
    private boolean canPrompt;
    private BaseContext context;

    public UtilityDriver(ILog log, FilterConfigurationMapper mapper, UtilitiesAccess plugins, IHelp help, boolean canPrompt) {
        this.log = log;
        this.mapper = mapper;
        this.plugins = plugins;
        this.help = help;
        this.canPrompt = canPrompt;
        this.context = new BaseContext();
    }

    public IUtility getUtility() {
        return this.utility;
    }

    public void setData(Project project, String utilityName) {
        try {
            String tmp;
            this.prj = project;
            if (!this.plugins.containsID(utilityName)) {
                throw new OkapiException(Res.getString("UtilityDriver.utilityNotFound") + utilityName);
            }
            this.pluginItem = this.plugins.getItem(utilityName);
            this.utility = (IUtility)Class.forName(this.pluginItem.pluginClass).newInstance();
            this.utility.addCancelListener(this);
            this.editor = this.pluginItem.editorClass.length() > 0 ? (IParametersEditor)Class.forName(this.pluginItem.editorClass).newInstance() : null;
            if (this.utility.hasParameters() && (tmp = this.prj.getUtilityParameters(this.utility.getName())) != null && tmp.length() > 0) {
                this.utility.getParameters().fromString(tmp);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiException(e);
        }
    }

    public boolean checkParameters(Shell shell) {
        try {
            if (this.pluginItem == null) {
                return false;
            }
            if (this.utility.hasParameters()) {
                if (this.editor != null) {
                    this.context.setObject("shell", shell);
                    this.context.setObject("help", this.help);
                    this.context.setString("projDir", this.prj.getProjectFolder());
                    if (!this.editor.edit(this.utility.getParameters(), false, this.context)) {
                        return false;
                    }
                    this.prj.setUtilityParameters(this.utility.getName(), this.utility.getParameters().toString());
                }
            } else {
                MessageBox dlg = new MessageBox(shell, 452);
                dlg.setMessage(String.format(Res.getString("UtilityDriver.confirmExecution"), this.pluginItem.name));
                dlg.setText(this.getNameInCaption(shell.getText()));
                if (dlg.open() != 64) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            Dialogs.showError(shell, e.getMessage(), null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Shell shell) {
        try {
            this.log.beginTask(this.pluginItem.name);
            this.stopProcess = false;
            this.utility.setFilterAccess(this.mapper);
            this.utility.setContextUI(shell, this.help, "rainbow=" + Res.getString("VERSION"), this.prj.getProjectFolder(), this.canPrompt);
            if (this.utility.needsRoots()) {
                this.utility.setRoots(this.prj.getInputRoot(0), this.prj.buildOutputRoot(0));
            }
            this.utility.setOptions(this.prj.getSourceLanguage(), this.prj.getTargetLanguage());
            this.utility.preprocess();
            if (this.prj.getList(0).size() == 0) {
                this.logger.warn(Res.getString("UtilityDriver.noInput"));
            }
            int f = -1;
            for (Input item : this.prj.getList(0)) {
                ++f;
                this.logger.warn(Res.getString("UtilityDriver.input"), (Object)item.relativePath);
                this.utility.resetLists();
                String inputPath = this.prj.getInputRoot(0) + File.separator + item.relativePath;
                this.utility.addInputData(inputPath, this.prj.buildSourceEncoding(item), item.filterConfigId);
                String outputPath = this.prj.buildTargetPath(0, item.relativePath);
                this.utility.addOutputData(outputPath, this.prj.buildTargetEncoding(item));
                for (int j = 1; j < this.prj.inputLists.size() && j < this.utility.inputCountRequested(); ++j) {
                    if (this.prj.inputLists.get(j).size() <= f) continue;
                    Input addItem = this.prj.getList(j).get(f);
                    this.utility.addInputData(this.prj.getInputRoot(j) + File.separator + addItem.relativePath, this.prj.buildSourceEncoding(addItem), addItem.filterConfigId);
                    this.utility.addOutputData(this.prj.buildTargetPath(j, addItem.relativePath), this.prj.buildTargetEncoding(addItem));
                }
                if (this.utility.isFilterDriven()) {
                    ((IFilterDrivenUtility)this.utility).processFilterInput();
                } else {
                    ((ISimpleUtility)this.utility).processInput();
                }
                if (!this.stopProcess) continue;
                break;
            }
            this.utility.postprocess();
        }
        catch (Throwable e) {
            if (this.filter != null) {
                this.filter.close();
            }
            if (this.utility != null) {
                this.utility.postprocess();
            }
            this.logger.error(Res.getString("UtilityDriver.utilityError"), e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.logger.info(sw.toString());
        }
        finally {
            if (this.stopProcess) {
                this.logger.warn(Res.getString("UtilityDriver.userCancel"));
            }
            if (this.utility != null) {
                this.outputFolder = this.utility.getFolderAfterProcess();
            }
            this.log.endTask(null);
        }
    }

    String getFolderAfterProcess() {
        return this.outputFolder;
    }

    @Override
    public void cancelOccurred(CancelEvent event) {
        this.stopProcess = true;
        if (this.filter != null) {
            this.filter.cancel();
        }
    }

    private String getNameInCaption(String text) {
        int n = text.indexOf("- ");
        if (n > -1) {
            return text.substring(n + 1);
        }
        return text;
    }
}

