/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.fullwidthconversion.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.fullwidthconversion.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private IHelp help;
    private Button rdToFullWidth;
    private Button rdToHalfWidth;
    private Button chkAsciiOnly;
    private Button chkKatakanaOnly;
    private Button chkIncludeSLA;
    private Button chkIncludeLLS;
    private Button chkIncludeKatakana;
    private Button chkNormalizeOutput;
    private Composite mainComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Full-Width Conversion");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.createComposite(this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("Full-Width Conversion Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ParametersEditor.this.saveData();
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.setData();
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData(new GridData(1808));
        this.mainComposite.setLayout(new GridLayout());
        int indent = 16;
        this.rdToHalfWidth = new Button(this.mainComposite, 16);
        this.rdToHalfWidth.setText("Convert full-width characters to half-width or ASCII equivalents");
        this.chkIncludeSLA = new Button(this.mainComposite, 32);
        this.chkIncludeSLA.setText("Include Squared Latin Abbreviations of the CJK Compatibility block");
        GridData gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.chkIncludeSLA.setLayoutData(gdTmp);
        this.chkIncludeLLS = new Button(this.mainComposite, 32);
        this.chkIncludeLLS.setText("Include special characters of the Letter-Like Symbols block");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.chkIncludeLLS.setLayoutData(gdTmp);
        this.chkIncludeKatakana = new Button(this.mainComposite, 32);
        this.chkIncludeKatakana.setText("Include Japanese Katakana and associated punctuation");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.chkIncludeKatakana.setLayoutData(gdTmp);
        this.rdToFullWidth = new Button(this.mainComposite, 16);
        this.rdToFullWidth.setText("Convert half-width and ASCII characters to full-width equivalents");
        this.chkAsciiOnly = new Button(this.mainComposite, 32);
        this.chkAsciiOnly.setText("Convert only the ASCII characters");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.chkAsciiOnly.setLayoutData(gdTmp);
        this.chkAsciiOnly.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.chkAsciiOnly.getSelection()) {
                    ParametersEditor.this.chkKatakanaOnly.setSelection(false);
                }
            }
        });
        this.chkKatakanaOnly = new Button(this.mainComposite, 32);
        this.chkKatakanaOnly.setText("Convert only Japanese Katakana and associated punctuation");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.chkKatakanaOnly.setLayoutData(gdTmp);
        this.chkKatakanaOnly.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.chkKatakanaOnly.getSelection()) {
                    ParametersEditor.this.chkAsciiOnly.setSelection(false);
                }
            }
        });
        this.rdToFullWidth.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateChkBox();
            }
        });
        this.chkNormalizeOutput = new Button(this.mainComposite, 32);
        this.chkNormalizeOutput.setText("Normalize output");
    }

    private void updateChkBox() {
        this.chkIncludeSLA.setEnabled(this.rdToHalfWidth.getSelection());
        this.chkIncludeLLS.setEnabled(this.rdToHalfWidth.getSelection());
        this.chkIncludeKatakana.setEnabled(this.rdToHalfWidth.getSelection());
        this.chkAsciiOnly.setEnabled(!this.rdToHalfWidth.getSelection());
        this.chkKatakanaOnly.setEnabled(!this.rdToHalfWidth.getSelection());
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.rdToHalfWidth.setSelection(this.params.getToHalfWidth());
        this.chkIncludeSLA.setSelection(this.params.getIncludeSLA());
        this.chkIncludeLLS.setSelection(this.params.getIncludeLLS());
        this.chkIncludeKatakana.setSelection(this.params.getIncludeKatakana());
        this.rdToFullWidth.setSelection(!this.params.getToHalfWidth());
        this.chkAsciiOnly.setSelection(this.params.getAsciiOnly());
        this.chkKatakanaOnly.setSelection(this.params.getKatakanaOnly());
        this.chkNormalizeOutput.setSelection(this.params.getNormalizeOutput());
        this.updateChkBox();
    }

    private boolean saveData() {
        this.params.setToHalfWidth(this.rdToHalfWidth.getSelection());
        this.params.setIncludeSLA(this.chkIncludeSLA.getSelection());
        this.params.setIncludeLLS(this.chkIncludeLLS.getSelection());
        this.params.setIncludeKatakana(this.chkIncludeKatakana.getSelection());
        this.params.setAsciiOnly(this.chkAsciiOnly.getSelection());
        this.params.setKatakanaOnly(this.chkKatakanaOnly.getSelection());
        this.params.setNormalizeOutput(this.chkNormalizeOutput.getSelection());
        this.result = true;
        return this.result;
    }
}

