/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;

public class XsltTransformStep
extends BasePipelineStep {
    private InputStream xstlInputstream;
    private boolean done = false;

    public XsltTransformStep(InputStream xstlInputstream) {
        this.xstlInputstream = xstlInputstream;
    }

    public String getName() {
        return "XSLT Processing Step";
    }

    public String getDescription() {
        return "Applies an XSLT template to the document.";
    }

    protected Event handleRawDocument(Event event) {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        Reader XmlInput = ((RawDocument)event.getResource()).getReader();
        StreamSource xmlSource = new StreamSource(XmlInput);
        StreamSource xsltSource = new StreamSource(this.xstlInputstream);
        StreamResult result = new StreamResult(tempStream);
        TransformerFactory transFact = TransformerFactory.newInstance();
        try {
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (TransformerException e) {
            throw new OkapiException((Throwable)e);
        }
        ByteArrayInputStream transformedInput = new ByteArrayInputStream(tempStream.toByteArray());
        event.setResource((IResource)new RawDocument((InputStream)transformedInput, "UTF-8", new LocaleId("en")));
        this.done = true;
        return event;
    }

    public boolean isDone() {
        return this.done;
    }
}

