/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.extraction;

import java.io.File;
import net.sf.okapi.applications.rainbow.lib.SegmentationPanel;
import net.sf.okapi.applications.rainbow.packages.xliff.OptionsEditor;
import net.sf.okapi.applications.rainbow.utilities.extraction.Parameters;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.translation.ConnectorSelectionPanel;
import net.sf.okapi.lib.ui.translation.DefaultConnectors;
import net.sf.okapi.lib.ui.translation.IConnectorList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private List lbTypes;
    private Button btOptions;
    private Text edDescription;
    private Text edName;
    private Text edOutputFolder;
    private Button chkCreateZip;
    private Text edSample;
    private Button chkPreTranslate;
    private Button chkUseFileName;
    private Button chkUseGroupName;
    private Label stThreshold;
    private Spinner spinThreshold;
    private SegmentationPanel pnlSegmentation;
    private boolean inInit = true;
    private IHelp help;
    private String projectDir;
    private IParameters xliffOptions;
    private IContext context;
    private ConnectorSelectionPanel connectorPanel;
    private Button chkUseTransRes2;
    private ConnectorSelectionPanel connectorPanel2;
    private IConnectorList connectors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.projectDir = context.getString("projDir");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.connectors = DefaultConnectors.getConnectors();
            this.context = context;
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    @Override
    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Translation Package Creation");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        tfTmp.setLayoutData((Object)new GridData(1808));
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout(2, false));
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Package Format");
        tiTmp.setControl((Control)cmpTmp);
        Label stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Type of package to create:");
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        stTmp.setLayoutData((Object)gdTmp);
        this.lbTypes = new List(cmpTmp, 2048);
        this.lbTypes.add("Generic XLIFF");
        this.lbTypes.add("OmegaT");
        this.lbTypes.add("Original + RTF layer");
        this.lbTypes.setData((Object)"xliff\tomegat\trtf");
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 70;
        gdTmp.horizontalSpan = 2;
        this.lbTypes.setLayoutData((Object)gdTmp);
        this.lbTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updatePackageType();
            }
        });
        this.btOptions = new Button(cmpTmp, 8);
        this.btOptions.setText("&Options...");
        gdTmp = new GridData(2);
        this.btOptions.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btOptions, 80);
        this.btOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.editOptions();
            }
        });
        this.edDescription = new Text(cmpTmp, 2626);
        this.edDescription.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 60;
        this.edDescription.setLayoutData((Object)gdTmp);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout(2, false));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Package Location");
        tiTmp.setControl((Control)cmpTmp);
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Root of the output directory:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        stTmp.setLayoutData((Object)gdTmp);
        this.edOutputFolder = new Text(cmpTmp, 2048);
        this.edOutputFolder.setLayoutData((Object)new GridData(768));
        this.edOutputFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Editor.this.updateSample();
            }
        });
        Button btGetOutputFolder = new Button(cmpTmp, 8);
        btGetOutputFolder.setText("...");
        btGetOutputFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(Editor.this.shell);
                dlg.setFilterPath(Editor.this.edOutputFolder.getText());
                String tmp = dlg.open();
                if (tmp != null) {
                    Editor.this.edOutputFolder.setText(tmp);
                    Editor.this.edOutputFolder.selectAll();
                    Editor.this.edOutputFolder.setFocus();
                }
            }
        });
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Package name:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        stTmp.setLayoutData((Object)gdTmp);
        this.edName = new Text(cmpTmp, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edName.setLayoutData((Object)gdTmp);
        this.edName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Editor.this.updateSample();
            }
        });
        stTmp = new Label(cmpTmp, 0);
        stTmp.setText("Full path of the output directory:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        stTmp.setLayoutData((Object)gdTmp);
        this.edSample = new Text(cmpTmp, 2048);
        this.edSample.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edSample.setLayoutData((Object)gdTmp);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Options");
        tiTmp.setControl((Control)cmpTmp);
        this.chkCreateZip = new Button(cmpTmp, 32);
        this.chkCreateZip.setText("Compress the package into a ZIP file");
        Group grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("Segmentation");
        grpTmp.setLayout((Layout)new GridLayout());
        grpTmp.setLayoutData((Object)new GridData(768));
        this.pnlSegmentation = new SegmentationPanel((Composite)grpTmp, 0, "Pre-segment the extracted text with the following rules:", null, this.projectDir);
        this.pnlSegmentation.setLayoutData(new GridData(768));
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout(2, false));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Pre-Translation");
        tiTmp.setControl((Control)cmpTmp);
        this.chkPreTranslate = new Button(cmpTmp, 32);
        this.chkPreTranslate.setText("Pre-translate the extracted text");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkPreTranslate.setLayoutData((Object)gdTmp);
        this.chkPreTranslate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updatePretranslate();
            }
        });
        this.connectorPanel = new ConnectorSelectionPanel(cmpTmp, 0, this.connectors, this.context, "Primary translation resource to use:");
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        this.connectorPanel.setLayoutData(gdTmp);
        this.chkUseFileName = new Button(cmpTmp, 32);
        this.chkUseFileName.setText("Penalize matches with a FileName attribute different from the document being processed");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseFileName.setLayoutData((Object)gdTmp);
        this.chkUseGroupName = new Button(cmpTmp, 96);
        this.chkUseGroupName.setText("Penalize matches with a GroupName attribute different from the group being processed");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseGroupName.setLayoutData((Object)gdTmp);
        this.stThreshold = new Label(cmpTmp, 0);
        this.stThreshold.setText("Leverage only matches greater or equal to: ");
        this.spinThreshold = new Spinner(cmpTmp, 2048);
        this.spinThreshold.setMaximum(100);
        this.spinThreshold.setMinimum(0);
        this.spinThreshold.setLayoutData((Object)new GridData(32));
        this.chkUseTransRes2 = new Button(cmpTmp, 32);
        this.chkUseTransRes2.setText("Use a secondary translation resource:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseTransRes2.setLayoutData((Object)gdTmp);
        this.chkUseTransRes2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateUseTransRes2();
            }
        });
        this.connectorPanel2 = new ConnectorSelectionPanel(cmpTmp, 0, this.connectors, this.context, null);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        this.connectorPanel2.setLayoutData(gdTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("Rainbow - Translation Package Creation");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData(true)) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true, "Execute");
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        this.setData();
        this.inInit = false;
        Dialogs.centerWindow(this.shell, parent);
    }

    private void updatePackageType() {
        int n = this.lbTypes.getSelectionIndex();
        if (n == -1) {
            this.btOptions.setEnabled(false);
            this.edDescription.setText("");
            return;
        }
        switch (n) {
            case 0: {
                this.btOptions.setEnabled(true);
                this.edDescription.setText("Simple package where all files to translate are extracted to XLIFF. You can translate this package with any XLIFF editor.");
                break;
            }
            case 1: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("OmegaT project with all its files and directory structure in place. You can translate this package with OmegaT.");
                break;
            }
            case 2: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("Package where all the files to translate are converted into an RTF file with Trados-compatible styles. You can translate this package with Trados Translator's Workbench or any compatible tool.");
            }
        }
    }

    private void updateUseTransRes2() {
        this.connectorPanel2.setEnabled(this.chkUseTransRes2.getSelection());
    }

    private void updatePretranslate() {
        boolean enabled = this.chkPreTranslate.getSelection();
        this.connectorPanel.setEnabled(enabled);
        this.chkUseFileName.setEnabled(enabled);
        this.chkUseGroupName.setEnabled(enabled);
        this.stThreshold.setEnabled(enabled);
        this.spinThreshold.setEnabled(enabled);
        this.chkUseTransRes2.setEnabled(enabled);
        if (enabled) {
            this.updateUseTransRes2();
        } else {
            this.connectorPanel2.setEnabled(false);
        }
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        int n = -1;
        String[] aItems = ((String)this.lbTypes.getData()).split("\t", -2);
        for (int i = 0; i < aItems.length; ++i) {
            if (!aItems[i].equals(this.params.pkgType)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            n = 0;
        }
        this.lbTypes.setSelection(n);
        this.edOutputFolder.setText(this.params.outputFolder);
        this.edName.setText(this.params.pkgName);
        this.chkCreateZip.setSelection(this.params.createZip);
        this.pnlSegmentation.setData(this.params.preSegment, this.params.sourceSRX, this.params.targetSRX);
        this.chkPreTranslate.setSelection(this.params.preTranslate);
        this.connectorPanel.setData(this.params.transResClass, this.params.transResParams);
        this.chkUseFileName.setSelection(this.params.useFileName);
        this.chkUseGroupName.setSelection(this.params.useGroupName);
        this.spinThreshold.setSelection(this.params.threshold);
        this.chkUseTransRes2.setSelection(this.params.useTransRes2);
        this.connectorPanel2.setData(this.params.transResClass2, this.params.transResParams2);
        this.xliffOptions = this.params.xliffOptions;
        this.updatePackageType();
        this.updatePretranslate();
        this.updateSample();
    }

    private boolean saveData(boolean checkValues) {
        if (this.inInit) {
            return true;
        }
        String tmp = this.edName.getText();
        if (checkValues && tmp.length() == 0) {
            Dialogs.showError(this.shell, "You must provide a package name.", null);
            this.edName.setFocus();
            return false;
        }
        this.params.pkgName = tmp;
        tmp = this.edOutputFolder.getText();
        if (checkValues && tmp.length() == 0) {
            Dialogs.showError(this.shell, "You must provide an output directory.", null);
            this.edOutputFolder.setFocus();
            return false;
        }
        this.params.outputFolder = tmp;
        String[] aItems = ((String)this.lbTypes.getData()).split("\t", -2);
        this.params.pkgType = aItems[this.lbTypes.getSelectionIndex()];
        this.params.createZip = this.chkCreateZip.getSelection();
        this.params.preSegment = this.pnlSegmentation.getSegment();
        this.params.sourceSRX = this.pnlSegmentation.getSourceSRX();
        this.params.targetSRX = this.pnlSegmentation.getTargetSRX();
        this.params.preTranslate = this.chkPreTranslate.getSelection();
        this.params.transResClass = this.connectorPanel.getConnectorClass();
        this.params.transResParams = this.connectorPanel.getConnectorParameters();
        this.params.useFileName = this.chkUseFileName.getSelection();
        this.params.useGroupName = this.chkUseGroupName.getSelection();
        this.params.threshold = this.spinThreshold.getSelection();
        this.params.useTransRes2 = this.chkUseTransRes2.getSelection();
        this.params.transResClass2 = this.connectorPanel2.getConnectorClass();
        this.params.transResParams2 = this.connectorPanel2.getConnectorParameters();
        this.params.xliffOptions = this.xliffOptions;
        return true;
    }

    private void updateSample() {
        this.saveData(false);
        String out = this.edOutputFolder.getText() + File.separator + this.edName.getText();
        this.edSample.setText(out.replace("${ProjDir}", this.projectDir));
    }

    private void editOptions() {
        int n = this.lbTypes.getSelectionIndex();
        if (n == -1) {
            return;
        }
        switch (n) {
            case 0: {
                OptionsEditor dlg = new OptionsEditor();
                this.context.setObject("shell", this.shell);
                dlg.edit(this.xliffOptions, false, this.context);
            }
        }
    }
}

