/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.its;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.InlineCodeFinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.its.NSContextManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parameters
implements IParameters {
    private static final String PROTECTENTITYREF = "protectEntityRef";
    private static final String LINEBREAKASCODE = "lineBreakAsCode";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String OMITXMLDECLARATION = "omitXMLDeclaration";
    private static final String ESCAPEQUOTES = "escapeQuotes";
    private static final String EXTRACTIFONLYCODES = "extractIfOnlyCodes";
    private static final String MAPANNOTATIONS = "mapAnnotations";
    private static final String OKP_NS_PREFIX = "okp";
    private static final String OKP_NS_URI = "okapi-framework:xmlfilter-options";
    private static final String DEFAULTS = "<?xml version='1.0' ?>\n<its:rules version='1.0'\n xmlns:its='http://www.w3.org/2005/11/its'\n xmlns:xlink='http://www.w3.org/1999/xlink'\n xmlns:itsx='http://www.w3.org/2008/12/its-extensions'\n xmlns:okp='okapi-framework:xmlfilter-options'\n>\n<!-- See ITS specification at: http://www.w3.org/TR/its/ -->\n</its:rules>\n";
    private String path;
    private URI docURI;
    private Document doc;
    private DocumentBuilder docBuilder;
    private XPath xpath;
    public boolean useCodeFinder;
    public InlineCodeFinder codeFinder;
    public boolean escapeGT;
    public boolean escapeNbsp;
    public boolean protectEntityRef;
    public boolean escapeLineBreak;
    public boolean lineBreakAsCode;
    public boolean omitXMLDeclaration;
    public boolean escapeQuotes;
    public boolean extractIfOnlyCodes;
    public boolean mapAnnotations;
    public boolean quoteModeDefined;
    public int quoteMode;

    public Parameters() {
        this.reset();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        fact.setValidating(false);
        try {
            this.docBuilder = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiIOException(e);
        }
        this.docBuilder.setEntityResolver(new DefaultEntityResolver());
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        XPathFactory xpFact = XPathFactory.newInstance();
        this.xpath = xpFact.newXPath();
        NSContextManager nsContext = new NSContextManager();
        nsContext.addNamespace(OKP_NS_PREFIX, OKP_NS_URI);
        this.xpath.setNamespaceContext(nsContext);
    }

    @Override
    public String toString() {
        if (this.doc == null) {
            return DEFAULTS;
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(new DOMSource(this.doc), result);
        }
        catch (TransformerConfigurationException e) {
            throw new OkapiIOException(e);
        }
        catch (TransformerException e) {
            throw new OkapiIOException(e);
        }
        return sw.toString();
    }

    @Override
    public void fromString(String data) {
        this.docURI = null;
        this.path = null;
        try {
            this.doc = this.docBuilder.parse(new InputSource(new StringReader(data)));
            this.getFilterOptions();
        }
        catch (SAXException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        catch (XPathExpressionException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String filePath) {
        this.path = filePath;
    }

    @Override
    public void load(URI inputURI, boolean ignoreErrors) {
        Reader sr = null;
        try {
            String tmp = inputURI.toString();
            if (tmp.startsWith("jar:")) {
                URL url = inputURI.toURL();
                this.doc = this.docBuilder.parse(url.openStream());
            } else {
                this.doc = this.docBuilder.parse(inputURI.toString());
            }
            this.path = inputURI.getPath();
            this.docURI = inputURI;
            this.getFilterOptions();
        }
        catch (MalformedURLException e) {
            throw new OkapiIOException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiIOException(e);
        }
        catch (SAXException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        catch (XPathExpressionException e) {
            throw new OkapiIOException(e);
        }
        finally {
            if (sr != null) {
                try {
                    sr.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.doc = null;
        this.docURI = null;
        this.codeFinder = new InlineCodeFinder();
        this.useCodeFinder = false;
        this.codeFinder.reset();
        this.escapeGT = true;
        this.escapeNbsp = true;
        this.protectEntityRef = true;
        this.escapeLineBreak = false;
        this.lineBreakAsCode = false;
        this.omitXMLDeclaration = false;
        this.quoteModeDefined = true;
        this.quoteMode = 3;
        this.escapeQuotes = true;
        this.extractIfOnlyCodes = true;
        this.mapAnnotations = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String filePath) {
        StreamResult result = null;
        Transformer trans = null;
        try {
            if (this.doc == null) {
                this.fromString(DEFAULTS);
            }
            File f = new File(filePath);
            result = new StreamResult(f);
            try {
                trans = TransformerFactory.newInstance().newTransformer();
                trans.transform(new DOMSource(this.doc), result);
            }
            catch (TransformerConfigurationException e) {
                throw new OkapiIOException(e);
            }
            catch (TransformerException e) {
                throw new OkapiIOException(e);
            }
            this.path = filePath;
            this.docURI = f.toURI();
        }
        finally {
            trans = null;
            result = null;
            System.gc();
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public URI getURI() {
        return this.docURI;
    }

    @Override
    public boolean getBoolean(String name) {
        if (name.equals("escapeGT")) {
            return this.escapeGT;
        }
        if (name.equals("escapeNbsp")) {
            return this.escapeNbsp;
        }
        if (name.equals(PROTECTENTITYREF)) {
            return this.protectEntityRef;
        }
        if (name.equals("escapeLineBreak")) {
            return this.escapeLineBreak;
        }
        if (name.equals(LINEBREAKASCODE)) {
            return this.lineBreakAsCode;
        }
        if (name.equals(OMITXMLDECLARATION)) {
            return this.omitXMLDeclaration;
        }
        if (name.equals("quoteModeDefined")) {
            return this.quoteModeDefined;
        }
        if (name.equals(ESCAPEQUOTES)) {
            return this.escapeQuotes;
        }
        if (name.equals(EXTRACTIFONLYCODES)) {
            return this.extractIfOnlyCodes;
        }
        if (name.equals(MAPANNOTATIONS)) {
            return this.mapAnnotations;
        }
        return false;
    }

    @Override
    public void setBoolean(String name, boolean value) {
        if (name.equals("escapeGT")) {
            this.escapeGT = value;
        } else if (name.equals("escapeNbsp")) {
            this.escapeNbsp = value;
        } else if (name.equals(PROTECTENTITYREF)) {
            this.protectEntityRef = value;
        } else if (name.equals("escapeLineBreak")) {
            this.escapeLineBreak = value;
        } else if (name.equals(LINEBREAKASCODE)) {
            this.lineBreakAsCode = value;
        } else if (name.equals(OMITXMLDECLARATION)) {
            this.omitXMLDeclaration = value;
        } else if (name.equals("quoteModeDefined")) {
            this.quoteModeDefined = value;
        } else if (name.equals(ESCAPEQUOTES)) {
            this.escapeQuotes = value;
        } else if (name.equals(EXTRACTIFONLYCODES)) {
            this.extractIfOnlyCodes = value;
        } else if (name.equals(MAPANNOTATIONS)) {
            this.mapAnnotations = value;
        }
    }

    @Override
    public String getString(String name) {
        return null;
    }

    @Override
    public void setString(String name, String value) {
    }

    @Override
    public int getInteger(String name) {
        if (name.equals("quoteMode")) {
            return this.quoteMode;
        }
        return 0;
    }

    @Override
    public void setInteger(String name, int value) {
        if (name.equals("quoteMode")) {
            this.quoteMode = value;
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        return null;
    }

    private void getFilterOptions() throws XPathExpressionException {
        String tmp;
        Element elem;
        NodeList nl = (NodeList)this.xpath.evaluate("//okp:options", this.doc, XPathConstants.NODESET);
        if (nl.getLength() > 0) {
            elem = (Element)nl.item(0);
            tmp = elem.getAttribute("escapeLineBreak");
            if (!Util.isEmpty(tmp)) {
                this.escapeLineBreak = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute("escapeNbsp"))) {
                this.escapeNbsp = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(LINEBREAKASCODE))) {
                this.lineBreakAsCode = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute("escapeGT"))) {
                this.escapeGT = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(ESCAPEQUOTES))) {
                this.escapeQuotes = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(EXTRACTIFONLYCODES))) {
                this.extractIfOnlyCodes = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(PROTECTENTITYREF))) {
                this.protectEntityRef = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(OMITXMLDECLARATION))) {
                this.omitXMLDeclaration = tmp.equals("yes");
            }
            if (!Util.isEmpty(tmp = elem.getAttribute(MAPANNOTATIONS))) {
                this.mapAnnotations = tmp.equals("yes");
            }
        }
        if ((nl = (NodeList)this.xpath.evaluate("//okp:codeFinder", this.doc, XPathConstants.NODESET)).getLength() > 0) {
            elem = (Element)nl.item(0);
            tmp = elem.getAttribute(USECODEFINDER);
            if (!Util.isEmpty(tmp)) {
                this.useCodeFinder = tmp.equals("yes");
            }
            if ((tmp = Util.getTextContent(elem)) == null) {
                tmp = "";
            }
            this.codeFinder.fromString(tmp);
        }
    }
}

