/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends BaseParameters {
    private static final String EXTRACTBODYPAGES = "extractBodyPages";
    private static final String EXTRACTREFERENCEPAGES = "extractReferencePages";
    private static final String EXTRACTMASTERPAGES = "extractMasterPages";
    private static final String EXTRACTHIDDENPAGES = "extractHiddenPages";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String EXTRACTVARIABLES = "extractVariables";
    private static final String EXTRACTINDEXMARKERS = "extractIndexMarkers";
    private static final String EXTRACTLINKS = "extractLinks";
    private boolean extractBodyPages;
    private boolean extractReferencePages;
    private boolean extractMasterPages;
    private boolean extractHiddenPages;
    private boolean useCodeFinder;
    private InlineCodeFinder codeFinder = new InlineCodeFinder();
    private boolean extractVariables;
    private boolean extractIndexMarkers;
    private boolean extractLinks;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public boolean getUseCodeFinder() {
        return this.useCodeFinder;
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.useCodeFinder = useCodeFinder;
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    public boolean getExtractReferencePages() {
        return this.extractReferencePages;
    }

    public void setExtractReferencePages(boolean extractReferencePages) {
        this.extractReferencePages = extractReferencePages;
    }

    public boolean getExtractMasterPages() {
        return this.extractMasterPages;
    }

    public void setExtractMasterPages(boolean extractMasterPages) {
        this.extractMasterPages = extractMasterPages;
    }

    public boolean getExtractHiddenPages() {
        return this.extractHiddenPages;
    }

    public void setExtractHiddenPages(boolean extractHiddenPages) {
        this.extractHiddenPages = extractHiddenPages;
    }

    public boolean getExtractBodyPages() {
        return this.extractBodyPages;
    }

    public void setExtractBodyPages(boolean extractBodyPages) {
        this.extractBodyPages = extractBodyPages;
    }

    public boolean getExtractVariables() {
        return this.extractVariables;
    }

    public void setExtractVariables(boolean extractVariables) {
        this.extractVariables = extractVariables;
    }

    public boolean getExtractIndexMarkers() {
        return this.extractIndexMarkers;
    }

    public void setExtractIndexMarkers(boolean extractIndexMarkers) {
        this.extractIndexMarkers = extractIndexMarkers;
    }

    public boolean getExtractLinks() {
        return this.extractLinks;
    }

    public void setExtractLinks(boolean extractLinks) {
        this.extractLinks = extractLinks;
    }

    @Override
    public void reset() {
        this.extractBodyPages = true;
        this.extractMasterPages = true;
        this.extractReferencePages = true;
        this.extractHiddenPages = true;
        this.extractVariables = true;
        this.extractIndexMarkers = true;
        this.extractLinks = false;
        this.useCodeFinder = true;
        this.codeFinder.reset();
        this.codeFinder.setSample("text <$varName> text");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("<\\$.*?>");
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.extractBodyPages = this.buffer.getBoolean(EXTRACTBODYPAGES, this.extractBodyPages);
        this.extractHiddenPages = this.buffer.getBoolean(EXTRACTHIDDENPAGES, this.extractHiddenPages);
        this.extractMasterPages = this.buffer.getBoolean(EXTRACTMASTERPAGES, this.extractMasterPages);
        this.extractReferencePages = this.buffer.getBoolean(EXTRACTREFERENCEPAGES, this.extractReferencePages);
        this.extractVariables = this.buffer.getBoolean(EXTRACTVARIABLES, this.extractVariables);
        this.extractIndexMarkers = this.buffer.getBoolean(EXTRACTINDEXMARKERS, this.extractIndexMarkers);
        this.extractLinks = this.buffer.getBoolean(EXTRACTLINKS, this.extractLinks);
        this.useCodeFinder = this.buffer.getBoolean(USECODEFINDER, this.useCodeFinder);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(EXTRACTBODYPAGES, this.extractBodyPages);
        this.buffer.setBoolean(EXTRACTHIDDENPAGES, this.extractHiddenPages);
        this.buffer.setBoolean(EXTRACTMASTERPAGES, this.extractMasterPages);
        this.buffer.setBoolean(EXTRACTREFERENCEPAGES, this.extractReferencePages);
        this.buffer.setBoolean(EXTRACTVARIABLES, this.extractVariables);
        this.buffer.setBoolean(EXTRACTINDEXMARKERS, this.extractIndexMarkers);
        this.buffer.setBoolean(EXTRACTLINKS, this.extractLinks);
        this.buffer.setBoolean(USECODEFINDER, this.useCodeFinder);
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return this.buffer.toString();
    }
}

