/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.externalcommand;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String COMMAND = "command";
    private static final String TIMEOUT = "timeout";
    private String command;
    private int timeout;

    public Parameters() {
        this.reset();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void reset() {
        this.command = "";
        this.timeout = -1;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.command = this.buffer.getString(COMMAND, this.command);
        this.timeout = this.buffer.getInteger(TIMEOUT, -1);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(COMMAND, this.command);
        this.buffer.setParameter(TIMEOUT, this.timeout);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COMMAND, "Command line", "Command path to execute");
        desc.add(TIMEOUT, "Timeout", "Timeout in seconds after which the command is cancelled (use -1 for no timeout)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("External Command", true, false);
        desc.addTextInputPart(paramsDesc.get(COMMAND));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(TIMEOUT));
        tip.setVertical(false);
        return desc;
    }
}

