/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.imagemodification;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.imagemodification.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class ImageModificationStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private boolean isDone;
    private Parameters params = new Parameters();
    private URI outputURI;
    private String currentSuffix;
    private List<String> suffixes;

    @Override
    public String getName() {
        return "Image Modification";
    }

    @Override
    public String getDescription() {
        return "Create a modified copy of image files. Expects: image raw document. Sends back: image raw document.";
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.suffixes = new ArrayList<String>(Arrays.asList(ImageIO.getWriterFileSuffixes()));
        this.isDone = false;
        return event;
    }

    @Override
    public Event handleRawDocument(Event event) {
        block18: {
            RawDocument rd = event.getRawDocument();
            try {
                URI uri = rd.getInputURI();
                if (uri != null) {
                    File outFile;
                    BufferedImage imgOut;
                    File inputFile = new File(uri);
                    String newFormat = this.params.getFormat();
                    if (newFormat.isEmpty()) {
                        String ext = Util.getExtension(inputFile.getAbsolutePath()).toLowerCase();
                        if (ext.length() > 1) {
                            ext = ext.substring(1);
                        }
                        if (!ext.equalsIgnoreCase(this.currentSuffix)) {
                            if (this.suffixes.contains(ext)) {
                                newFormat = this.currentSuffix = ext;
                            } else {
                                this.LOGGER.warn("No image writer available for '{}'. Using 'png' instead.", (Object)newFormat);
                                this.currentSuffix = "png";
                                newFormat = "png";
                            }
                        } else {
                            newFormat = this.currentSuffix;
                        }
                    }
                    BufferedImage imgOri = ImageIO.read(inputFile);
                    BufferedImage imgTmp = this.params.getScaleHeight() != 100 || this.params.getScaleWidth() != 100 ? this.createResizedCopy(imgOri) : imgOri;
                    if (this.params.getMakeGray()) {
                        imgOut = new BufferedImage(imgTmp.getWidth(), imgTmp.getHeight(), 10);
                        Graphics g = imgOut.getGraphics();
                        g.drawImage(imgTmp, 0, 0, null);
                        g.dispose();
                    } else {
                        imgOut = imgTmp;
                    }
                    if (this.isLastOutputStep()) {
                        outFile = new File(this.outputURI);
                        Util.createDirectories(outFile.getAbsolutePath());
                    } else {
                        try {
                            outFile = File.createTempFile("okp-im_", ".tmp");
                        }
                        catch (Throwable e) {
                            throw new OkapiIOException("Cannot create temporary output.", e);
                        }
                        outFile.deleteOnExit();
                    }
                    ImageIO.write((RenderedImage)imgOut, newFormat, outFile);
                    break block18;
                }
                throw new OkapiIOException("Input type not supported (must be URI).");
            }
            catch (Throwable e) {
                throw new OkapiIOException("Error while loading or modifying the image.", e);
            }
            finally {
                this.isDone = true;
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createResizedCopy(Image originalImage) {
        Graphics g2d = null;
        try {
            int oriWidth = originalImage.getWidth(null);
            int oriHeight = originalImage.getHeight(null);
            Double tmp = (double)oriWidth * ((double)this.params.getScaleWidth() / 100.0);
            int newWidth = tmp.intValue() < 1 ? 1 : tmp.intValue();
            tmp = (double)oriHeight * ((double)this.params.getScaleHeight() / 100.0);
            int newHeight = tmp.intValue() < 1 ? 1 : tmp.intValue();
            BufferedImage scaledImg = new BufferedImage(newWidth, newHeight, 1);
            g2d = scaledImg.createGraphics();
            ((Graphics2D)g2d).setComposite(AlphaComposite.Src);
            g2d.drawImage(originalImage, 0, 0, newWidth, newHeight, null);
            BufferedImage bufferedImage = scaledImg;
            return bufferedImage;
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
    }
}

