/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.moses;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=MergingParameters.class)
public class MergingParameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String COPYTOTARGET = "copyToTarget";
    private static final String OVERWRITEEXISINGTARGET = "overwriteExistingTarget";
    private static final String FORCEALTTRANSOUTPUT = "forceAltTransOutput";
    private static final String USEGMODEINALTTRANS = "useGModeInAltTrans";
    private boolean copyToTarget;
    private boolean overwriteExistingTarget;
    private boolean forceAltTransOutput;
    private boolean useGModeInAltTrans;

    public MergingParameters() {
        this.reset();
    }

    public boolean getCopyToTarget() {
        return this.copyToTarget;
    }

    public void setCopyToTarget(boolean copyToTarget) {
        this.copyToTarget = copyToTarget;
    }

    public boolean getOverwriteExistingTarget() {
        return this.overwriteExistingTarget;
    }

    public void setOverwriteExistingTarget(boolean overwriteExistingTarget) {
        this.overwriteExistingTarget = overwriteExistingTarget;
    }

    public boolean getForceAltTransOutput() {
        return this.forceAltTransOutput;
    }

    public void setForceAltTransOutput(boolean forceAltTransOutput) {
        this.forceAltTransOutput = forceAltTransOutput;
    }

    public boolean getUseGModeInAltTrans() {
        return this.useGModeInAltTrans;
    }

    public void setUseGModeInAltTrans(boolean useGModeInAltTrans) {
        this.useGModeInAltTrans = useGModeInAltTrans;
    }

    @Override
    public void reset() {
        this.copyToTarget = false;
        this.overwriteExistingTarget = false;
        this.forceAltTransOutput = true;
        this.useGModeInAltTrans = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.copyToTarget = this.buffer.getBoolean(COPYTOTARGET, this.copyToTarget);
        this.overwriteExistingTarget = this.buffer.getBoolean(OVERWRITEEXISINGTARGET, this.overwriteExistingTarget);
        this.forceAltTransOutput = this.buffer.getBoolean(FORCEALTTRANSOUTPUT, this.forceAltTransOutput);
        this.useGModeInAltTrans = this.buffer.getBoolean(USEGMODEINALTTRANS, this.useGModeInAltTrans);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(COPYTOTARGET, this.copyToTarget);
        this.buffer.setBoolean(OVERWRITEEXISINGTARGET, this.overwriteExistingTarget);
        this.buffer.setBoolean(FORCEALTTRANSOUTPUT, this.forceAltTransOutput);
        this.buffer.setBoolean(USEGMODEINALTTRANS, this.useGModeInAltTrans);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COPYTOTARGET, "Copy the leveraged translation into the target", null);
        desc.add(OVERWRITEEXISINGTARGET, "Overwrite any existing target text", null);
        desc.add(FORCEALTTRANSOUTPUT, "In XLIFF, force the new <alt-trans> in the output", null);
        desc.add(USEGMODEINALTTRANS, "Use the <g> notation in new <alt-trans> elements", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Moses InlineText Leveraging", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(COPYTOTARGET));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(OVERWRITEEXISINGTARGET));
        cbp2.setMasterPart(cbp1, true);
        cbp1 = desc.addCheckboxPart(paramDesc.get(FORCEALTTRANSOUTPUT));
        desc.addCheckboxPart(paramDesc.get(USEGMODEINALTTRANS)).setMasterPart(cbp1, true);
        return desc;
    }
}

