/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.steps.tokenization.common.LanguageParameters;
import net.sf.okapi.steps.tokenization.tokens.Tokens;

public class LexerRule
extends LanguageParameters {
    private String name;
    private String description;
    private boolean enabled;
    private int lexemId;
    private String pattern;
    private String sample;
    private boolean keepInput;
    private List<Integer> inTokenIDs;
    private List<String> inTokens;
    private List<Integer> outTokenIDs;
    private List<String> outTokens;
    private List<Integer> userTokenIDs;
    private List<String> userTokens;

    @Override
    protected void parameters_reset() {
        super.parameters_reset();
        this.name = "";
        this.description = "";
        this.enabled = true;
        this.inTokenIDs.clear();
        this.outTokenIDs.clear();
        this.userTokenIDs.clear();
        this.lexemId = 0;
        this.pattern = "";
        this.sample = "";
        this.keepInput = false;
    }

    @Override
    protected void parameters_init() {
        super.parameters_init();
        this.inTokenIDs = new ArrayList<Integer>();
        this.inTokens = new ArrayList<String>();
        this.outTokenIDs = new ArrayList<Integer>();
        this.outTokens = new ArrayList<String>();
        this.userTokenIDs = new ArrayList<Integer>();
        this.userTokens = new ArrayList<String>();
    }

    @Override
    protected void parameters_load(ParametersString buffer) {
        super.parameters_load(buffer);
        this.name = buffer.getString("name", "");
        this.description = buffer.getString("description", "");
        this.enabled = buffer.getBoolean("enabled", true);
        ListUtil.stringAsList(this.inTokens, buffer.getString("inTokens"));
        this.inTokenIDs.clear();
        for (String tokenName : this.inTokens) {
            this.inTokenIDs.add(Tokens.getTokenId(tokenName));
        }
        ListUtil.stringAsList(this.outTokens, buffer.getString("outTokens"));
        this.outTokenIDs.clear();
        for (String tokenName : this.outTokens) {
            this.outTokenIDs.add(Tokens.getTokenId(tokenName));
        }
        ListUtil.stringAsList(this.userTokens, buffer.getString("userTokens"));
        this.userTokenIDs.clear();
        for (String tokenName : this.userTokens) {
            this.userTokenIDs.add(Tokens.getTokenId(tokenName));
        }
        this.lexemId = buffer.getInteger("lexemId", 0);
        this.pattern = buffer.getString("pattern", "");
        this.sample = buffer.getString("sample", "");
        this.keepInput = buffer.getBoolean("keepInput");
    }

    @Override
    protected void parameters_save(ParametersString buffer) {
        buffer.setString("name", this.name);
        buffer.setString("description", this.description);
        buffer.setBoolean("enabled", this.enabled);
        this.inTokens.clear();
        for (Integer tokenId : this.inTokenIDs) {
            this.inTokens.add(Tokens.getTokenName(tokenId));
        }
        buffer.setString("inTokens", ListUtil.listAsString(this.inTokens));
        this.outTokens.clear();
        for (Integer tokenId : this.outTokenIDs) {
            this.outTokens.add(Tokens.getTokenName(tokenId));
        }
        buffer.setString("outTokens", ListUtil.listAsString(this.outTokens));
        this.userTokens.clear();
        for (Integer tokenId : this.userTokenIDs) {
            this.userTokens.add(Tokens.getTokenName(tokenId));
        }
        buffer.setString("userTokens", ListUtil.listAsString(this.userTokens));
        buffer.setInteger("lexemId", this.lexemId);
        buffer.setString("pattern", this.pattern);
        buffer.setString("sample", this.sample);
        buffer.setBoolean("keepInput", this.keepInput);
        super.parameters_save(buffer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getLexemId() {
        return this.lexemId;
    }

    public void setLexemId(int lexemId) {
        this.lexemId = lexemId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String sample) {
        this.sample = sample;
    }

    public List<Integer> getInTokenIDs() {
        return this.inTokenIDs;
    }

    public List<Integer> getOutTokenIDs() {
        return this.outTokenIDs;
    }

    public List<Integer> getUserTokenIDs() {
        return this.userTokenIDs;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getKeepInput() {
        return this.keepInput;
    }

    public void setKeepInput(boolean keepInput) {
        this.keepInput = keepInput;
    }
}

