/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;

public class Main {
    private static LocaleId srcLang = LocaleId.fromString((String)"en");
    private static LocaleId trgLang = LocaleId.fromString((String)"fr");
    private static String inputEncoding = "UTF-8";
    private static String outputEncoding = "UTF-8";
    private static String inputPath = null;
    private static String outputPath = null;
    private static String steps = "";
    private static IFilterConfigurationMapper fcMapper;

    public static void main(String[] args) {
        try {
            System.out.println("------------------------------------------------------------");
            if (args.length == 0) {
                Main.printUsage();
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-sl")) {
                    srcLang = LocaleId.fromString((String)args[++i]);
                    continue;
                }
                if (args[i].equals("-tl")) {
                    trgLang = LocaleId.fromString((String)args[++i]);
                    continue;
                }
                if (args[i].equals("-ie")) {
                    inputEncoding = args[++i];
                    continue;
                }
                if (args[i].equals("-oe")) {
                    outputEncoding = args[++i];
                    continue;
                }
                if (args[i].equals("-s")) {
                    if (args[++i].equals("pseudo")) {
                        steps = steps + "p";
                        continue;
                    }
                    if (args[i].equals("upper")) {
                        steps = steps + "u";
                        continue;
                    }
                    throw new RuntimeException("Unknown step.");
                }
                if (args[i].equals("-?")) {
                    Main.printUsage();
                    return;
                }
                if (inputPath == null) {
                    inputPath = args[i];
                    continue;
                }
                outputPath = args[i];
            }
            if (inputPath == null) {
                throw new RuntimeException("No input file defined.");
            }
            if (outputPath == null) {
                outputPath = Util.getFilename((String)inputPath, (boolean)false) + ".out" + Util.getExtension((String)inputPath);
            }
            fcMapper = new FilterConfigurationMapper();
            fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
            fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
            fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
            fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
            String ext = Util.getExtension((String)inputPath);
            if (Util.isEmpty((String)ext)) {
                throw new RuntimeException("No filter detected for the file extension.");
            }
            String mimeType = MimeTypeMapper.getMimeType((String)(ext = ext.substring(1)));
            FilterConfiguration cfg = fcMapper.getDefaultConfiguration(mimeType);
            if (cfg == null) {
                throw new RuntimeException(String.format("No configuration defined for the MIME type '%s'.", mimeType));
            }
            System.out.println("            input file: " + inputPath);
            System.out.println("default input encoding: " + inputEncoding);
            System.out.println("           output file: " + outputPath);
            System.out.println("       output encoding: " + inputEncoding);
            System.out.println("       source language: " + srcLang);
            System.out.println("       target language: " + trgLang);
            System.out.println("    MIME type detected: " + mimeType);
            System.out.println("configuration detected: " + cfg.configId);
            Main.pipeline1(cfg);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: [option(s)] inputFile[ outputFile]");
        System.out.println("where the options are:");
        System.out.println(" -sl <sourceLang>");
        System.out.println(" -tl <targetLang>");
        System.out.println(" -ie <inputEncoding>");
        System.out.println(" -oe <outputEncoding>");
        System.out.println(" -s pseudo|upper");
    }

    private static void pipeline1(FilterConfiguration config) {
        PipelineDriver driver = new PipelineDriver();
        driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        block4: for (int i = 0; i < steps.length(); ++i) {
            switch (steps.charAt(i)) {
                case 'p': {
                    driver.addStep((IPipelineStep)new PseudoTranslateStep());
                    continue block4;
                }
                case 'u': {
                    driver.addStep((IPipelineStep)new UppercaseStep());
                }
            }
        }
        driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        driver.setFilterConfigurationMapper(fcMapper);
        driver.addBatchItem((IBatchItemContext)new BatchItemContext(new File(inputPath).toURI(), inputEncoding, config.configId, new File(outputPath).toURI(), outputEncoding, srcLang, trgLang));
        driver.processBatch();
    }
}

