/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff.Markers;
import net.sf.okapi.lib.xliff.XLIFFReaderException;
import org.oasisopen.xliff.v2.Directionality;
import org.oasisopen.xliff.v2.ICMarker;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.IMarkers;

public class DataStore
implements IDataStore {
    private static final long serialVersionUID = 64L;
    private Markers srcMarkers;
    private Markers trgMarkers;
    private int lastSuggested;
    private Directionality srcDir = Directionality.LTR;
    private Directionality trgDir = Directionality.LTR;
    private transient Map<String, String> map;

    @Override
    public boolean hasCodeWithOriginalData() {
        if (this.srcMarkers != null && this.srcMarkers.hasCodeWithOriginalData()) {
            return true;
        }
        return this.trgMarkers != null && this.trgMarkers.hasCodeWithOriginalData();
    }

    @Override
    public boolean hasSourceMarker() {
        return this.srcMarkers != null && this.srcMarkers.size() > 0;
    }

    @Override
    public boolean hasTargetMarker() {
        return this.trgMarkers != null && this.trgMarkers.size() > 0;
    }

    @Override
    public IMarkers getSourceMarkers() {
        if (this.srcMarkers == null) {
            this.srcMarkers = new Markers(this);
        }
        return this.srcMarkers;
    }

    @Override
    public IMarkers getTargetMarkers() {
        if (this.trgMarkers == null) {
            this.trgMarkers = new Markers(this);
        }
        return this.trgMarkers;
    }

    @Override
    public void calculateOriginalDataToIdsMap() {
        String tmp;
        ICMarker code;
        int i;
        this.map = new LinkedHashMap<String, String>();
        int mapId = 0;
        if (this.srcMarkers != null) {
            i = 0;
            while (i < this.srcMarkers.size()) {
                if (!this.srcMarkers.get(i).isAnnotation()) {
                    code = (ICMarker)this.srcMarkers.get(i);
                    tmp = code.getOriginalData();
                    if (tmp == null) {
                        tmp = "";
                    }
                    if (!this.map.containsKey(tmp)) {
                        this.map.put(code.getOriginalData(), "d" + String.valueOf(++mapId));
                    }
                }
                ++i;
            }
        }
        if (this.trgMarkers != null) {
            i = 0;
            while (i < this.trgMarkers.size()) {
                if (!this.trgMarkers.get(i).isAnnotation()) {
                    code = (ICMarker)this.trgMarkers.get(i);
                    tmp = code.getOriginalData();
                    if (tmp == null) {
                        tmp = "";
                    }
                    if (!this.map.containsKey(tmp)) {
                        this.map.put(code.getOriginalData(), "d" + String.valueOf(++mapId));
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void setOutsideRepresentationMap(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public Map<String, String> getOutsideRepresentationMap() {
        return this.map;
    }

    @Override
    public String getIdForOriginalData(String originalData) {
        if (this.map == null) {
            this.calculateOriginalDataToIdsMap();
        }
        if (!this.map.containsKey(originalData)) {
            this.calculateOriginalDataToIdsMap();
            if (!this.map.containsKey(originalData)) {
                throw new XLIFFReaderException(String.format("No id found for the original data '%s'.", originalData));
            }
        }
        return this.map.get(originalData);
    }

    public boolean isIdUsedForMarker(String id) {
        if (this.srcMarkers != null) {
            for (IMarker marker : this.srcMarkers) {
                if (!id.equals(marker.getId())) continue;
                return true;
            }
        }
        if (this.trgMarkers != null) {
            for (IMarker marker : this.trgMarkers) {
                if (!id.equals(marker.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public String suggestId() {
        String id;
        while (!this.isIdUsedForMarker(id = String.valueOf(++this.lastSuggested))) {
        }
        return id;
    }

    @Override
    public Directionality getSourceDir() {
        return this.srcDir;
    }

    @Override
    public void setSourceDir(Directionality dir) {
        this.srcDir = dir;
    }

    @Override
    public Directionality getTargetDir() {
        return this.trgDir;
    }

    @Override
    public void setTargetDir(Directionality dir) {
        this.trgDir = dir;
    }
}

