/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.ICMarker;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.IMarkers;
import org.oasisopen.xliff.v2.MarkerType;

public class Markers
implements IMarkers {
    private static final long serialVersionUID = 64L;
    private IDataStore store;
    private ArrayList<IMarker> markers;

    public Markers(IDataStore store) {
        if (store == null) {
            throw new InvalidParameterException("The store parameter cannot be null.");
        }
        this.store = store;
    }

    @Override
    public boolean hasCodeWithOriginalData() {
        if (this.markers != null) {
            for (IMarker marker : this.markers) {
                if (marker.isAnnotation() || !((ICMarker)marker).hasOriginalData()) continue;
                return true;
            }
        }
        return false;
    }

    public IMarker getClosingPart(IMarker openingMarker) {
        for (IMarker marker : this.markers) {
            if (!marker.getId().equals(openingMarker.getId())) continue;
            return marker;
        }
        return null;
    }

    public IMarker getOpeningPart(IMarker closingMarker) {
        for (IMarker marker : this.markers) {
            if (!marker.getId().equals(closingMarker.getId())) continue;
            return marker;
        }
        return null;
    }

    @Override
    public int size() {
        if (this.markers == null) {
            return 0;
        }
        return this.markers.size();
    }

    @Override
    public IDataStore getDataStore() {
        return this.store;
    }

    @Override
    public IMarker get(int index) {
        if (this.markers != null) {
            return this.markers.get(index);
        }
        throw new IndexOutOfBoundsException("Empty list of codes.");
    }

    @Override
    public IMarker get(String id, MarkerType type) {
        if (this.markers == null) {
            return null;
        }
        String tmp = Util.toInternalId(id, type);
        for (IMarker marker : this.markers) {
            if (!marker.getInternalId().equals(tmp)) continue;
            return marker;
        }
        return null;
    }

    @Override
    public void add(IMarker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        this.markers.add(marker);
    }

    @Override
    public Iterator<IMarker> iterator() {
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        return this.markers.iterator();
    }
}

