/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.AnnotatedSpan;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.InvalidPositionException;

public class TextFragment
implements Appendable,
CharSequence,
Comparable<Object> {
    public static final int MARKER_OPENING = 57601;
    public static final int MARKER_CLOSING = 57602;
    public static final int MARKER_ISOLATED = 57603;
    public static final int CHARBASE = 57616;
    public static final String REFMARKER_START = "[#$";
    public static final String REFMARKER_END = "]";
    public static final String REFMARKER_SEP = "@%";
    public static final Pattern MARKERS_REGEX = Pattern.compile("[\ue101\ue102\ue103\ue104].");
    private static final String WHITESPACE_REGEX = "[ \t\r\n\f\u200b]+";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \t\r\n\f\u200b]+");
    protected StringBuilder text;
    protected List<Code> codes;
    protected boolean isBalanced;
    protected int lastCodeID;

    public static char toChar(int index) {
        return (char)(index + 57616);
    }

    public static int toIndex(char index) {
        return index - 57616;
    }

    public static String makeRefMarker(String id) {
        return REFMARKER_START + id + REFMARKER_END;
    }

    public static String makeRefMarker(String id, String propertyName) {
        return REFMARKER_START + id + REFMARKER_SEP + propertyName + REFMARKER_END;
    }

    public static Object[] getRefMarker(StringBuilder text) {
        int start = text.indexOf(REFMARKER_START);
        if (start == -1) {
            return null;
        }
        int end = text.indexOf(REFMARKER_END, start);
        if (end == -1) {
            return null;
        }
        String id = text.substring(start + REFMARKER_START.length(), end);
        Object[] result = new Object[4];
        result[1] = start;
        result[2] = end + REFMARKER_END.length();
        int sep = id.indexOf(REFMARKER_SEP);
        if (sep > -1) {
            String propName = id.substring(sep + REFMARKER_SEP.length());
            id = id.substring(0, sep);
            result[3] = propName;
        }
        result[0] = id;
        return result;
    }

    public static int fromFragmentToString(TextFragment frag, int pos) {
        if (!frag.hasCode()) {
            return pos;
        }
        int len = 0;
        String text = frag.getCodedText();
        for (int i = 0; i < text.length(); ++i) {
            if (i >= pos) {
                return len;
            }
            if (TextFragment.isMarker(text.charAt(i))) {
                Code code = frag.getCode(text.charAt(++i));
                len += code.getData().length();
                continue;
            }
            ++len;
        }
        return len;
    }

    public static int indexOfLastNonWhitespace(String codedText, int fromIndex, int untilIndex, boolean openingMarkerIsWS, boolean closingMarkerIsWS, boolean isolatedMarkerIsWS, boolean whitespaceIsWS) {
        if (codedText == null || codedText.length() == 0) {
            return -1;
        }
        if (fromIndex == -1) {
            fromIndex = codedText.length() - 1;
        }
        int textEnd = fromIndex;
        boolean done = false;
        while (!done) {
            switch (codedText.charAt(textEnd)) {
                case '\ue101': {
                    if (openingMarkerIsWS) break;
                    ++textEnd;
                    done = true;
                    break;
                }
                case '\ue102': {
                    if (closingMarkerIsWS) break;
                    ++textEnd;
                    done = true;
                    break;
                }
                case '\ue103': {
                    if (isolatedMarkerIsWS) break;
                    ++textEnd;
                    done = true;
                    break;
                }
                default: {
                    if (whitespaceIsWS && Character.isWhitespace(codedText.charAt(textEnd))) break;
                    done = true;
                    if (textEnd <= 1) break;
                    switch (codedText.charAt(textEnd - 1)) {
                        case '\ue101': 
                        case '\ue102': 
                        case '\ue103': {
                            done = false;
                        }
                    }
                }
            }
            if (done) continue;
            if (textEnd - 1 < untilIndex) {
                textEnd = -1;
                break;
            }
            --textEnd;
        }
        return textEnd;
    }

    public static int indexOfFirstNonWhitespace(String codedText, int fromIndex, int untilIndex, boolean openingMarkerIsWS, boolean closingMarkerIsWS, boolean isolatedMarkerIsWS, boolean whitespaceIsWS) {
        if (codedText == null || codedText.length() == 0) {
            return -1;
        }
        if (untilIndex == -1) {
            untilIndex = codedText.length() - 1;
        }
        int textStart = fromIndex;
        boolean done = false;
        while (!done) {
            switch (codedText.charAt(textStart)) {
                case '\ue101': {
                    if (openingMarkerIsWS) {
                        ++textStart;
                        break;
                    }
                    done = true;
                    break;
                }
                case '\ue102': {
                    if (closingMarkerIsWS) {
                        ++textStart;
                        break;
                    }
                    done = true;
                    break;
                }
                case '\ue103': {
                    if (isolatedMarkerIsWS) {
                        ++textStart;
                        break;
                    }
                    done = true;
                    break;
                }
                default: {
                    if (whitespaceIsWS && Character.isWhitespace(codedText.charAt(textStart))) break;
                    done = true;
                }
            }
            if (done) continue;
            if (textStart == untilIndex) {
                textStart = -1;
                break;
            }
            ++textStart;
        }
        return textStart;
    }

    public static void unwrap(TextFragment frag) {
        String text = frag.getCodedText();
        StringBuilder tmp = new StringBuilder(text.length());
        boolean wasWS = true;
        block4: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    tmp.append(text.charAt(i));
                    tmp.append(text.charAt(++i));
                    wasWS = false;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (wasWS) continue block4;
                    wasWS = true;
                    tmp.append(' ');
                    continue block4;
                }
                default: {
                    wasWS = false;
                    tmp.append(text.charAt(i));
                }
            }
        }
        frag.setCodedText(tmp.toString().trim());
    }

    public static boolean isMarker(char ch) {
        return ch == '\ue101' || ch == '\ue102' || ch == '\ue103';
    }

    public TextFragment() {
        this.text = new StringBuilder();
        this.isBalanced = true;
    }

    public TextFragment(String text) {
        this.text = new StringBuilder(text == null ? "" : text);
        this.isBalanced = true;
    }

    public TextFragment(String text, int lastCodeId) {
        this(text);
        if (lastCodeId < -1) {
            lastCodeId = -1;
        }
        this.lastCodeID = lastCodeId;
    }

    public TextFragment(TextFragment fragment) {
        this.setCodedText(fragment.getCodedText(), fragment.getCodes(), false);
        this.lastCodeID = fragment.lastCodeID;
    }

    public TextFragment(String newCodedText, List<Code> newCodes) {
        this.setCodedText(newCodedText, newCodes, false);
    }

    public TextFragment clone() {
        TextFragment tf = new TextFragment(this.getCodedText(), this.getClonedCodes());
        tf.lastCodeID = this.getLastCodeId();
        return tf;
    }

    public boolean hasReference() {
        if (!this.hasCode()) {
            return false;
        }
        for (Code code : this.codes) {
            if (!code.hasReference()) continue;
            return true;
        }
        return false;
    }

    public void append(String text) {
        if (text == null) {
            return;
        }
        this.text.append(text);
    }

    public TextFragment append(TextFragment fragment) {
        return this.append(fragment, false);
    }

    public TextFragment append(TextFragment fragment, boolean keepCodeIds) {
        this.insert(-1, fragment, keepCodeIds);
        return this;
    }

    public Code append(Code code) {
        if (this.codes == null) {
            this.codes = new ArrayList<Code>();
        }
        switch (code.tagType) {
            case OPENING: {
                this.append("\ue101" + TextFragment.toChar(this.codes.size()));
                break;
            }
            case CLOSING: {
                this.append("\ue102" + TextFragment.toChar(this.codes.size()));
                break;
            }
            case PLACEHOLDER: {
                this.append("\ue103" + TextFragment.toChar(this.codes.size()));
            }
        }
        if (code.tagType != TagType.PLACEHOLDER && code.id == -1) {
            this.isBalanced = false;
        }
        this.codes.add(code);
        if (code.tagType != TagType.CLOSING) {
            if (this.codes.get((int)(this.codes.size() - 1)).id == -1) {
                this.codes.get((int)(this.codes.size() - 1)).id = ++this.lastCodeID;
            } else if (this.codes.get((int)(this.codes.size() - 1)).id > this.lastCodeID) {
                this.lastCodeID = this.codes.get((int)(this.codes.size() - 1)).id;
            }
        }
        return code;
    }

    public Code append(TagType tagType, String type, InlineAnnotation annotation) {
        Code code = this.append(tagType, type, "");
        code.setAnnotation(type, annotation);
        return code;
    }

    public Code append(TagType tagType, String type, String data) {
        if (this.codes == null) {
            this.codes = new ArrayList<Code>();
        }
        switch (tagType) {
            case OPENING: {
                this.append("\ue101" + TextFragment.toChar(this.codes.size()));
                break;
            }
            case CLOSING: {
                this.append("\ue102" + TextFragment.toChar(this.codes.size()));
                break;
            }
            case PLACEHOLDER: {
                this.append("\ue103" + TextFragment.toChar(this.codes.size()));
            }
        }
        this.codes.add(new Code(tagType, type, data));
        if (tagType != TagType.CLOSING) {
            this.codes.get((int)(this.codes.size() - 1)).id = ++this.lastCodeID;
        }
        if (tagType != TagType.PLACEHOLDER) {
            this.isBalanced = false;
        }
        return this.codes.get(this.codes.size() - 1);
    }

    public Code append(TagType tagType, String type, String data, int id) {
        if (this.codes == null) {
            this.codes = new ArrayList<Code>();
        }
        switch (tagType) {
            case OPENING: {
                this.append("\ue101" + TextFragment.toChar(this.codes.size()));
                break;
            }
            case CLOSING: {
                this.append("\ue102" + TextFragment.toChar(this.codes.size()));
                break;
            }
            case PLACEHOLDER: {
                this.append("\ue103" + TextFragment.toChar(this.codes.size()));
            }
        }
        Code code = new Code(tagType, type, data);
        code.id = id;
        this.codes.add(code);
        if (code.tagType != TagType.PLACEHOLDER && id == -1) {
            this.isBalanced = false;
        }
        if (code.tagType != TagType.CLOSING) {
            if (id == -1) {
                code.id = ++this.lastCodeID;
            } else if (id > this.lastCodeID) {
                this.lastCodeID = id;
            }
        }
        return this.codes.get(this.codes.size() - 1);
    }

    public void insert(int offset, TextFragment fragment) {
        this.insert(offset, fragment, false);
    }

    public void insert(int offset, TextFragment fragment, boolean keepCodeIds) {
        if (fragment == null) {
            return;
        }
        this.checkPositionForMarker(offset);
        StringBuilder tmp = new StringBuilder(fragment.getCodedText());
        List<Code> newCodes = fragment.getCodes();
        if (!newCodes.isEmpty()) {
            if (this.codes == null) {
                this.codes = new ArrayList<Code>();
            }
            int newLastId = this.lastCodeID;
            int idOffset = this.lastCodeID;
            int negId = fragment.getLastCodeId() + idOffset;
            boolean doit = false;
            for (int i = 0; i < tmp.length(); ++i) {
                switch (tmp.charAt(i)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        Code c = newCodes.get(TextFragment.toIndex(tmp.charAt(++i))).clone();
                        int cid = c.getId();
                        if (!keepCodeIds) {
                            if (c.getTagType() != TagType.CLOSING) {
                                if (cid < 0) {
                                    c.setId(++negId);
                                    if (c.getId() > newLastId) {
                                        newLastId = c.getId();
                                    }
                                } else if (doit || cid <= this.lastCodeID) {
                                    c.setId(cid + idOffset);
                                    if (c.getId() > newLastId) {
                                        newLastId = c.getId();
                                    }
                                    doit = true;
                                }
                            } else {
                                c.setId(-1);
                            }
                        }
                        this.codes.add(c);
                        tmp.setCharAt(i, TextFragment.toChar(this.codes.size() - 1));
                    }
                }
            }
            this.lastCodeID = newLastId;
        }
        if (offset < 0) {
            this.text.append((CharSequence)tmp);
        } else {
            this.text.insert(offset, tmp);
        }
        if (!newCodes.isEmpty()) {
            this.isBalanced = false;
        }
    }

    public void clear() {
        this.text = new StringBuilder();
        this.codes = null;
        this.lastCodeID = 0;
        this.isBalanced = true;
    }

    public void trim() {
        this.text = new StringBuilder(this.text.toString().trim());
    }

    public void ltrim() {
        this.text = new StringBuilder(this.text.toString().replaceAll("^\\s+", ""));
    }

    public void rtrim() {
        this.text = new StringBuilder(this.text.toString().replaceAll("\\s+$", ""));
    }

    public void collapseWhitespace() {
        this.text = new StringBuilder(WHITESPACE_PATTERN.matcher(this.text).replaceAll(" "));
    }

    public String getText() {
        if (!this.hasCode()) {
            return this.text.toString();
        }
        Matcher m = MARKERS_REGEX.matcher(new String(this.text));
        return m.replaceAll("");
    }

    public static String getText(String codedText) {
        Matcher m = MARKERS_REGEX.matcher(codedText);
        return m.replaceAll("");
    }

    public String getCodedText() {
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        return this.text.toString();
    }

    public String getCodedText(int start, int end) {
        if (end == -1) {
            end = this.text.length();
        }
        this.checkPositionForMarker(start);
        this.checkPositionForMarker(end);
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        return this.text.substring(start, end);
    }

    public Code getCode(char indexAsChar) {
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        return this.codes.get(TextFragment.toIndex(indexAsChar));
    }

    public Code getCode(int index) {
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        return this.codes.get(index);
    }

    public List<Code> getCodes() {
        if (this.codes == null) {
            this.codes = new ArrayList<Code>();
        }
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        return Collections.unmodifiableList(this.codes);
    }

    protected void setCodes(List<Code> codes) {
        this.codes = codes;
    }

    public List<Code> getClonedCodes() {
        ArrayList<Code> clones = new ArrayList<Code>();
        for (Code code : this.getCodes()) {
            clones.add(code.clone());
        }
        return clones;
    }

    public List<Code> getCodes(int start, int end) {
        ArrayList<Code> tmpCodes = new ArrayList<Code>();
        if (this.codes == null) {
            return tmpCodes;
        }
        if (this.codes.isEmpty()) {
            return tmpCodes;
        }
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        this.checkPositionForMarker(start);
        this.checkPositionForMarker(end);
        for (int i = start; i < end; ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code ori = this.codes.get(TextFragment.toIndex(this.text.charAt(++i)));
                    tmpCodes.add(ori.clone());
                }
            }
        }
        return tmpCodes;
    }

    public int getIndex(int id) {
        if (this.codes == null) {
            return -1;
        }
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        int i = 0;
        for (Code code : this.codes) {
            if (code.id == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndexForClosing(int id) {
        if (this.codes == null) {
            return -1;
        }
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        int i = 0;
        for (Code code : this.codes) {
            if (code.tagType == TagType.CLOSING && code.id == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.text == null || this.text.length() == 0;
    }

    public boolean hasText() {
        return this.hasText(false);
    }

    public boolean hasText(boolean whiteSpacesAreText) {
        block3: for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    ++i;
                    continue block3;
                }
                default: {
                    if (whiteSpacesAreText) {
                        return true;
                    }
                    if (Character.isWhitespace(this.text.charAt(i))) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasCode() {
        if (this.codes == null) {
            return false;
        }
        return this.codes.size() > 0;
    }

    public void remove(int start, int end) {
        if (end == -1) {
            end = this.text.length();
        }
        this.checkPositionForMarker(start);
        this.checkPositionForMarker(end);
        this.text.replace(start, end, "");
        if (this.codes == null || this.codes.size() == 0) {
            return;
        }
        ArrayList<Code> remaining = new ArrayList<Code>();
        for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    remaining.add(this.codes.get(TextFragment.toIndex(this.text.charAt(++i))));
                    this.text.setCharAt(i, TextFragment.toChar(remaining.size() - 1));
                }
            }
        }
        this.codes.clear();
        this.codes = remaining;
        this.isBalanced = false;
    }

    @Override
    public TextFragment subSequence(int start, int end) {
        TextFragment sub = new TextFragment();
        if (this.isEmpty()) {
            return sub;
        }
        StringBuilder tmpText = new StringBuilder(this.getCodedText(start, end));
        ArrayList<Code> tmpCodes = null;
        if (this.codes != null && this.codes.size() > 0) {
            tmpCodes = new ArrayList<Code>();
            block3: for (int i = 0; i < tmpText.length(); ++i) {
                switch (tmpText.charAt(i)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        tmpCodes.add(this.codes.get(TextFragment.toIndex(tmpText.charAt(++i))).clone());
                        tmpText.setCharAt(i, TextFragment.toChar(tmpCodes.size() - 1));
                        if (sub.lastCodeID >= ((Code)tmpCodes.get((int)(tmpCodes.size() - 1))).id) continue block3;
                        sub.lastCodeID = ((Code)tmpCodes.get((int)(tmpCodes.size() - 1))).id;
                    }
                }
            }
        }
        sub.setCodedText(tmpText.toString(), tmpCodes, false);
        return sub;
    }

    public void setCodedText(String newCodedText) {
        this.setCodedText(newCodedText, this.codes, false);
    }

    public void setCodedText(String newCodedText, boolean allowCodeDeletion) {
        this.setCodedText(newCodedText, this.codes, allowCodeDeletion);
    }

    public void setCodedText(String newCodedText, List<Code> newCodes) {
        this.setCodedText(newCodedText, newCodes, false);
    }

    public void setCodedText(String newCodedText, List<Code> newCodes, boolean allowCodeDeletion) {
        this.isBalanced = false;
        this.text = new StringBuilder(newCodedText);
        if (newCodes == null) {
            if (this.codes != null && !allowCodeDeletion) {
                throw new InvalidContentException("Missing codes in the new list: " + this.codes.size());
            }
            this.codes = null;
        } else {
            this.codes = new ArrayList<Code>(newCodes);
        }
        if (this.codes == null || this.codes.size() == 0) {
            this.lastCodeID = 0;
            return;
        }
        ArrayList<Code> activeCodes = new ArrayList<Code>();
        int j = 0;
        block5: for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    ++j;
                    if (this.codes == null) {
                        throw new InvalidContentException("Invalid index for marker " + j);
                    }
                    try {
                        activeCodes.add(this.codes.get(TextFragment.toIndex(this.text.charAt(++i))));
                        continue block5;
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new InvalidContentException("Invalid index for marker " + j);
                    }
                }
            }
        }
        if (allowCodeDeletion) {
            this.codes.retainAll(activeCodes);
        } else if (j > 0 && (this.codes == null || j < this.codes.size())) {
            throw new InvalidContentException(String.format("Markers in coded text: %d. Listed codes: %d. New text=\"%s\" ", j, this.codes.size(), newCodedText));
        }
    }

    @Override
    public String toString() {
        return this.text.toString();
    }

    public String toText() {
        if (this.codes == null || this.codes.size() == 0) {
            return this.text.toString();
        }
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = this.codes.get(TextFragment.toIndex(this.text.charAt(++i)));
                    tmp.append((CharSequence)code.data);
                    continue block3;
                }
                default: {
                    tmp.append(this.text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    @Override
    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof TextFragment) {
            return this.compareTo((TextFragment)object, false);
        }
        return this.toText().compareTo(object.toString());
    }

    public int compareTo(TextFragment frag, boolean codeSensitive) {
        if (frag == null) {
            return -1;
        }
        int textOnlyCompare = this.getText().compareTo(frag.getText());
        if (codeSensitive) {
            if (this.hasCode() && textOnlyCompare == 0) {
                if (!frag.hasCode()) {
                    return 1;
                }
                String otherCodes = frag.getCodes().toString();
                return otherCodes.compareTo(this.codes.toString());
            }
            if (frag.hasCode()) {
                return -1;
            }
        }
        return textOnlyCompare;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int changeToCode(int start, int end, TagType tagType, String type) {
        TextFragment sub = this.subSequence(start, end);
        int before = this.text.length();
        Code code = new Code(tagType, type, sub.toText());
        if (this.codes == null) {
            this.codes = new ArrayList<Code>();
        }
        this.remove(start, end);
        String marker = null;
        switch (tagType) {
            case OPENING: {
                marker = "\ue101" + TextFragment.toChar(this.codes.size());
                code.id = ++this.lastCodeID;
                break;
            }
            case CLOSING: {
                marker = "\ue102" + TextFragment.toChar(this.codes.size());
                break;
            }
            case PLACEHOLDER: {
                marker = "\ue103" + TextFragment.toChar(this.codes.size());
                code.id = ++this.lastCodeID;
            }
        }
        this.text.insert(start, marker);
        if (code.data.toString().contains(REFMARKER_START)) {
            code.setReferenceFlag(true);
        }
        this.codes.add(code);
        this.isBalanced = false;
        return this.text.length() - before;
    }

    private int findClosingCodePosition(int id, int indexOfOpening) {
        for (int i = indexOfOpening + 1; i < this.codes.size(); ++i) {
            if (this.codes.get((int)i).id != id || !this.codes.get((int)i).type.equals(this.codes.get((int)indexOfOpening).type)) continue;
            char ci = TextFragment.toChar(i);
            for (int j = 0; j < this.text.length(); ++j) {
                if (this.text.charAt(j) != '\ue102' || this.text.charAt(j + 1) != ci) continue;
                return j;
            }
            return -1;
        }
        return -1;
    }

    public int annotate(int start, int end, String type, InlineAnnotation annotation) {
        int sci;
        int ccp;
        this.checkPositionForMarker(start);
        this.checkPositionForMarker(end);
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        int before = this.text.length();
        Code startCode = null;
        Code endCode = null;
        if (this.codes == null) {
            this.codes = new ArrayList<Code>();
        } else if (start > 1 && this.text.charAt(start - 2) == '\ue101' && (ccp = this.findClosingCodePosition(this.codes.get((int)sci).id, sci = TextFragment.toIndex(this.text.charAt(start - 1)))) != -1 && ccp == end) {
            startCode = this.codes.get(sci);
            endCode = this.codes.get(TextFragment.toIndex(this.text.charAt(ccp + 1)));
        }
        String startBuf = "";
        if (startCode == null) {
            startCode = new Code(TagType.OPENING, "_annotation_");
            startBuf = "\ue101" + TextFragment.toChar(this.codes.size());
            startCode.id = ++this.lastCodeID;
            this.text.insert(start, startBuf);
            this.codes.add(startCode);
        }
        startCode.setAnnotation(type, annotation);
        if (endCode == null) {
            endCode = new Code(TagType.CLOSING, "_annotation_");
            String endBuf = "\ue102" + TextFragment.toChar(this.codes.size());
            endCode.id = startCode.id;
            this.text.insert(end + startBuf.length(), endBuf);
            this.codes.add(endCode);
        }
        endCode.setAnnotation(type, annotation);
        return this.text.length() - before;
    }

    public void removeAnnotations() {
        if (!this.hasCode()) {
            return;
        }
        boolean clean = false;
        for (Code code : this.codes) {
            if (code.annotations == null) continue;
            code.annotations.clear();
            code.annotations = null;
            clean = true;
        }
        if (clean) {
            this.cleanUnusedCodes();
        }
    }

    public void removeAnnotations(String type) {
        if (!this.hasCode()) {
            return;
        }
        boolean clean = false;
        for (Code code : this.codes) {
            code.removeAnnotation(type);
            clean = true;
        }
        if (clean) {
            this.cleanUnusedCodes();
        }
    }

    public boolean hasAnnotation() {
        if (!this.hasCode()) {
            return false;
        }
        for (Code code : this.codes) {
            if (!code.hasAnnotation()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnnotation(String type) {
        if (!this.hasCode()) {
            return false;
        }
        for (Code code : this.codes) {
            if (!code.hasAnnotation(type)) continue;
            return true;
        }
        return false;
    }

    private void cleanUnusedCodes() {
        int before = this.text.length();
        block6: for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = this.codes.get(TextFragment.toIndex(this.text.charAt(++i)));
                    if (code.hasData() || code.hasAnnotation()) continue block6;
                    this.text = this.text.delete(i - 1, i + 1);
                    --i;
                }
            }
        }
        if (this.text.length() == before) {
            return;
        }
        ArrayList<Code> remaining = new ArrayList<Code>();
        for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    remaining.add(this.codes.get(TextFragment.toIndex(this.text.charAt(++i))));
                    this.text.setCharAt(i, TextFragment.toChar(remaining.size() - 1));
                }
            }
        }
        this.codes.clear();
        this.codes = remaining;
        this.isBalanced = false;
    }

    private int getCodePosition(int index) {
        int n = this.text.indexOf(String.valueOf(TextFragment.toChar(index)), 0);
        if (n == -1) {
            return -1;
        }
        return n - 1;
    }

    public List<AnnotatedSpan> getAnnotatedSpans(String type) {
        ArrayList<AnnotatedSpan> list = new ArrayList<AnnotatedSpan>();
        if (this.codes == null) {
            return list;
        }
        for (int i = 0; i < this.codes.size(); ++i) {
            if (this.codes.get((int)i).tagType != TagType.OPENING || !this.codes.get(i).hasAnnotation(type)) continue;
            int start = this.getCodePosition(i) + 2;
            int end = this.findClosingCodePosition(this.codes.get((int)i).id, i);
            if (start == -1 || end == -1) continue;
            list.add(new AnnotatedSpan(type, this.codes.get(i).getAnnotation(type), this.subSequence(start, end), start, end));
        }
        return list;
    }

    public int renumberCodes() {
        if (this.codes == null) {
            return 0;
        }
        HashMap<Integer, Integer> lookup = new HashMap<Integer, Integer>();
        int curId = 1;
        block5: for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (!TextFragment.isMarker(ch)) continue;
            Code code = this.codes.get(TextFragment.toIndex(this.text.charAt(++i)));
            switch (code.tagType) {
                case OPENING: {
                    if (code.id != curId) {
                        lookup.put(code.id, curId);
                        code.id = curId;
                    }
                    this.lastCodeID = curId++;
                    continue block5;
                }
                case CLOSING: {
                    if (!lookup.containsKey(code.id)) continue block5;
                    code.id = (Integer)lookup.get(code.id);
                    continue block5;
                }
                case PLACEHOLDER: {
                    code.id = curId;
                    this.lastCodeID = curId++;
                }
            }
        }
        return this.lastCodeID;
    }

    public int renumberCodes(int idBase) {
        return this.renumberCodes(idBase, true);
    }

    public int renumberCodes(int idBase, boolean mindPosition) {
        int i;
        AbstractMap map;
        if (this.codes == null) {
            return idBase - 1;
        }
        if (mindPosition) {
            map = new LinkedHashMap();
            for (i = 0; i < this.text.length(); ++i) {
                switch (this.text.charAt(i)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        int index = TextFragment.toIndex(this.text.charAt(++i));
                        Code code = this.codes.get(index);
                        map.put(code.getId(), -1);
                    }
                }
            }
        } else {
            map = new TreeMap();
            for (Code code : this.codes) {
                map.put(code.getId(), -1);
            }
        }
        i = idBase;
        Iterator<Object> i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            map.put(key, i++);
        }
        this.lastCodeID = i - 1;
        if (this.codes != null) {
            for (Code code : this.codes) {
                code.setId((Integer)map.get(code.getId()));
            }
        }
        return this.lastCodeID;
    }

    public void removeCode(Code code) {
        if (code == null || this.codes == null || this.codes.isEmpty()) {
            return;
        }
        block3: for (int i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    int index = TextFragment.toIndex(this.text.charAt(i + 1));
                    if (this.codes.get(index).getId() == code.getId() && this.codes.get(index).getTagType() == code.getTagType()) {
                        this.remove(i, i + 2);
                        return;
                    }
                    ++i;
                    continue block3;
                }
            }
        }
    }

    private void checkPositionForMarker(int position) {
        if (position > 0) {
            switch (this.text.charAt(position - 1)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    throw new InvalidPositionException(String.format("Position %d is inside a marker.", position));
                }
            }
        }
    }

    public void balanceMarkers() {
        if (this.codes == null) {
            return;
        }
        this.lastCodeID = 0;
        int[] closingIds = new int[this.codes.size()];
        int i = 0;
        for (Code item : this.codes) {
            closingIds[i] = item.id;
            if (item.id > this.lastCodeID) {
                this.lastCodeID = item.id;
            }
            ++i;
        }
        for (i = 0; i < this.text.length(); ++i) {
            switch (this.text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    int index = TextFragment.toIndex(this.text.charAt(i + 1));
                    Code code = this.codes.get(index);
                    switch (code.tagType) {
                        case PLACEHOLDER: {
                            this.text.setCharAt(i, '\ue103');
                            break;
                        }
                        case OPENING: {
                            boolean found = false;
                            for (int j = index + 1; j < this.codes.size(); ++j) {
                                if (this.codes.get((int)j).tagType != TagType.CLOSING || !this.codes.get((int)j).type.equals(code.type) || this.codes.get((int)j).id != code.id) continue;
                                found = true;
                                closingIds[j] = -9999;
                                this.text.setCharAt(i, '\ue101');
                                break;
                            }
                            if (found) break;
                            boolean fixupMode = false;
                            int candidate = -1;
                            int stackElem = 1;
                            int stackType = 1;
                            for (int j = index + 1; j < this.codes.size(); ++j) {
                                if (this.codes.get((int)j).type.equals(code.type)) {
                                    if (this.codes.get((int)j).tagType == TagType.OPENING) {
                                        ++stackElem;
                                        ++stackType;
                                        continue;
                                    }
                                    if (this.codes.get((int)j).tagType != TagType.CLOSING) continue;
                                    --stackElem;
                                    --stackType;
                                    if (fixupMode) {
                                        if (stackType != 0 || closingIds[j] == -9999) continue;
                                        candidate = j;
                                        break;
                                    }
                                    if (stackElem == 0) {
                                        if (stackType == 0 && closingIds[j] != -9999) {
                                            this.codes.get((int)j).id = code.id;
                                            closingIds[j] = -9999;
                                            found = true;
                                            break;
                                        }
                                        fixupMode = true;
                                        continue;
                                    }
                                    if (stackElem > 0) {
                                        if (stackType != 0 || closingIds[j] == -9999) continue;
                                        candidate = j;
                                        continue;
                                    }
                                    if (candidate != -1) break;
                                    if (stackType == 0 && closingIds[j] != -9999) {
                                        candidate = j;
                                        break;
                                    }
                                    fixupMode = true;
                                    continue;
                                }
                                if (this.codes.get((int)j).tagType == TagType.OPENING) {
                                    ++stackElem;
                                } else if (this.codes.get((int)j).tagType == TagType.CLOSING) {
                                    --stackElem;
                                }
                                if (stackElem != 0) continue;
                                fixupMode = true;
                            }
                            if (found) {
                                this.text.setCharAt(i, '\ue101');
                                break;
                            }
                            if (candidate != -1) {
                                this.codes.get((int)candidate).id = code.id;
                                closingIds[candidate] = -88;
                            }
                            this.text.setCharAt(i, '\ue103');
                            break;
                        }
                        case CLOSING: {
                            if (closingIds[index] == -9999) {
                                this.text.setCharAt(i, '\ue102');
                                break;
                            }
                            if (closingIds[index] == -1) {
                                this.text.setCharAt(i, '\ue103');
                                code.id = ++this.lastCodeID;
                                break;
                            }
                            this.text.setCharAt(i, '\ue103');
                        }
                    }
                    ++i;
                }
            }
        }
        this.isBalanced = true;
    }

    public void alignCodeIds(TextFragment base) {
        if (!base.hasCode()) {
            return;
        }
        if (this.codes == null) {
            return;
        }
        ArrayList<Code> toUse = new ArrayList<Code>(base.getCodes());
        this.isBalanced = false;
        this.lastCodeID = 0;
        boolean needExtra = false;
        for (Code trgCode : this.codes) {
            if (trgCode.tagType == TagType.CLOSING) continue;
            Code srcCode = null;
            while (!toUse.isEmpty()) {
                srcCode = (Code)toUse.get(0);
                if (srcCode.tagType != TagType.CLOSING) break;
                toUse.remove(0);
            }
            if (srcCode == null || Util.isEmpty(srcCode.getData()) || Util.isEmpty(trgCode.getData())) continue;
            if (trgCode.getData().equals(srcCode.getData()) && trgCode.getId() == srcCode.getId()) {
                toUse.remove(0);
                if (this.lastCodeID >= trgCode.getId()) continue;
                this.lastCodeID = trgCode.getId();
                continue;
            }
            boolean found = false;
            for (int i = 0; i < toUse.size(); ++i) {
                Code candidate = (Code)toUse.get(i);
                if (!trgCode.getData().equals(candidate.getData())) continue;
                trgCode.setId(candidate.getId());
                toUse.remove(i);
                found = true;
                if (this.lastCodeID >= trgCode.getId()) break;
                this.lastCodeID = trgCode.getId();
                break;
            }
            if (found || Util.isEmpty(trgCode.getData())) continue;
            trgCode.setId(-1);
            needExtra = true;
        }
        if (needExtra) {
            for (Code trgCode : this.codes) {
                if (Util.isEmpty(trgCode.getData())) {
                    Code code = base.findCode(trgCode.getId());
                    if (code == null) continue;
                    trgCode.setData(code.getData());
                    continue;
                }
                if (trgCode.tagType == TagType.CLOSING || trgCode.getId() != -1) continue;
                trgCode.setId(++this.lastCodeID);
            }
        }
    }

    @Override
    public Appendable append(char value) {
        this.text.append(value);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) {
        this.text.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public int length() {
        return this.text.length();
    }

    public void invalidate() {
        this.isBalanced = false;
    }

    public int getLastCodeId() {
        if (!this.isBalanced) {
            this.balanceMarkers();
        }
        return this.lastCodeID;
    }

    public Code findCode(int id) {
        for (Code code : this.codes) {
            if (code.getId() != id) continue;
            return code;
        }
        return null;
    }

    public static enum Marker {
        OPENING(57601),
        CLOSING(57602),
        ISOLATED(57603),
        UNKOWN(-1);

        private int markerType;

        private Marker(int markerType) {
            this.markerType = markerType;
        }

        public int getMarkerType() {
            return this.markerType;
        }

        public static Marker asEnum(int markerType) {
            switch (markerType) {
                case 57601: {
                    return OPENING;
                }
                case 57602: {
                    return CLOSING;
                }
                case 57603: {
                    return ISOLATED;
                }
            }
            return UNKOWN;
        }
    }

    public static enum TagType {
        OPENING,
        CLOSING,
        PLACEHOLDER;

    }
}

