/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.archive;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String MIMETYPE = "mimeType";
    private static final String FILENAMES = "fileNames";
    private static final String CONFIGIDS = "configIds";

    @Override
    public void reset() {
        super.reset();
        this.setMimeType("application/x-archive");
        this.setFileNames("*.tmx,*.xlf,*.xlff");
        this.setConfigIds("okf_tmx,okf_xliff,okf_xliff");
    }

    public void setFileNames(String fileNames) {
        this.setString(FILENAMES, fileNames);
    }

    public String getFileNames() {
        return this.getString(FILENAMES);
    }

    public void setConfigIds(String configIds) {
        this.setString(CONFIGIDS, configIds);
    }

    public String getConfigIds() {
        return this.getString(CONFIGIDS);
    }

    public void setMimeType(String mimeType) {
        this.setString(MIMETYPE, mimeType);
    }

    public String getMimeType() {
        return this.getString(MIMETYPE);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(MIMETYPE, "MIME type of the filter's container format", null);
        desc.add(FILENAMES, "File names", "Comma-delimited list of file names to be processed (wildcards are allowed) in the same order as configuration ids");
        desc.add(CONFIGIDS, "Filter configuration ids", "Comma-delimited list of configuration ids corresponding to the file names");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("Archive Filter Parameters", true, false);
        desc.addTextInputPart(parametersDescription.get(MIMETYPE));
        desc.addTextInputPart(parametersDescription.get(FILENAMES));
        desc.addTextInputPart(parametersDescription.get(CONFIGIDS));
        return desc;
    }
}

