/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.ExcelWorksheet;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.SharedStringMap;

public class ExcelWorksheetPartHandler
extends NonTranslatablePartHandler {
    private ConditionalParameters cparams;
    private int sheetNumber;
    private SharedStringMap ssm;
    private ExcelStyles styles;

    ExcelWorksheetPartHandler(OpenXMLZipFile zipFile, ZipEntry entry, SharedStringMap ssm, ExcelStyles styles, int sheetNumber, ConditionalParameters cparams) {
        super(zipFile, entry);
        this.sheetNumber = sheetNumber;
        this.ssm = ssm;
        this.cparams = cparams;
        this.styles = styles;
    }

    @Override
    protected String getModifiedContent() {
        try {
            StringWriter sw = new StringWriter();
            Set<String> excludedColumns = this.cparams.findExcludedColumnsForSheetNumber(this.sheetNumber);
            XMLEventReader r = this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(this.getEntry().getName()));
            XMLEventWriter w = this.getZipFile().getOutputFactory().createXMLEventWriter(sw);
            new ExcelWorksheet(this.getZipFile().getEventFactory(), this.ssm, this.styles, excludedColumns, this.cparams.tsExcelExcludedColors).parse(r, w);
            return sw.toString();
        }
        catch (IOException e) {
            throw new OkapiBadFilterInputException(e);
        }
        catch (XMLStreamException e) {
            throw new OkapiBadFilterInputException(e);
        }
    }
}

