/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.zip.ZipEntry;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTranslatablePartHandler
implements OpenXMLPartHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private OpenXMLZipFile zipFile;
    private ZipEntry entry;

    NonTranslatablePartHandler(OpenXMLZipFile zipFile, ZipEntry entry) {
        this.zipFile = zipFile;
        this.entry = entry;
    }

    protected OpenXMLZipFile getZipFile() {
        return this.zipFile;
    }

    protected ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public Event open(String docId, String subDocId, LocaleId srcLang) throws IOException {
        DocumentPart dp = new DocumentPart(this.entry.getName(), false);
        ZipSkeleton skel = new ZipSkeleton(this.zipFile.getZip(), this.entry);
        skel.setModifiedContents(this.getModifiedContent());
        return new Event(EventType.DOCUMENT_PART, dp, skel);
    }

    protected String getModifiedContent() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public Event next() {
        throw new IllegalStateException();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
        this.LOGGER.trace("[[ Non-translatable Part: " + this.entry.getName() + " ]]");
    }
}

