/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentTypes;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelDocument;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.PowerpointDocument;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.WordDocument;
import net.sf.okapi.filters.openxml.XMLFactories;

public class OpenXMLZipFile {
    private ZipFile zipFile;
    private String encoding;
    private ContentTypes contentTypes;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private XMLEventFactory eventFactory;
    private String mainDocumentPart;
    public static final String CONTENT_TYPES_PART = "[Content_Types].xml";
    public static final String ROOT_RELS_PART = "_rels/.rels";
    private static final String OFFICE_DOCUMENT_RELATIONSHIP = Namespaces.DocumentRels.getDerivedURI("/officeDocument");

    public OpenXMLZipFile(ZipFile zipFile, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String encoding) {
        this.zipFile = zipFile;
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.encoding = encoding;
    }

    private void initializeContentTypes() throws XMLStreamException, IOException {
        this.contentTypes = new ContentTypes(this.inputFactory);
        this.contentTypes.parseFromXML(this.getPartReader(CONTENT_TYPES_PART));
    }

    public XMLFactories getFactories() {
        return new XMLFactories(){

            @Override
            public XMLOutputFactory getOutputFactory() {
                return OpenXMLZipFile.this.outputFactory;
            }

            @Override
            public XMLInputFactory getInputFactory() {
                return OpenXMLZipFile.this.inputFactory;
            }

            @Override
            public XMLEventFactory getEventFactory() {
                return OpenXMLZipFile.this.eventFactory;
            }
        };
    }

    public DocumentType createDocument(ConditionalParameters params) throws XMLStreamException, IOException {
        this.initializeContentTypes();
        this.mainDocumentPart = this.findMainDocumentPart();
        switch (this.contentTypes.getContentType(this.mainDocumentPart)) {
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": {
                return new WordDocument(this, params);
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
                return new ExcelDocument(this, params);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": {
                return new PowerpointDocument(this, params);
            }
        }
        return null;
    }

    public ContentTypes getContentTypes() {
        return this.contentTypes;
    }

    public XMLInputFactory getInputFactory() {
        return this.inputFactory;
    }

    public XMLOutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    public XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    public String getMainDocumentPart() throws IOException, XMLStreamException {
        return this.mainDocumentPart;
    }

    private String findMainDocumentPart() throws IOException, XMLStreamException {
        Relationships rels = this.getRelationships(ROOT_RELS_PART);
        Relationships.Rel docRel = rels.getRelByType(OFFICE_DOCUMENT_RELATIONSHIP).get(0);
        if (docRel == null) {
            return null;
        }
        return docRel.target;
    }

    public Reader getPartReader(String partName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(partName);
        if (entry == null) {
            throw new OkapiBadFilterInputException("File is missing " + partName);
        }
        return Util.skipBOM(new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding));
    }

    public Relationships getRelationships(String relsPartName) throws IOException, XMLStreamException {
        Relationships rels = new Relationships(this.inputFactory);
        rels.parseFromXML(relsPartName, this.getPartReader(relsPartName));
        return rels;
    }

    public Relationships getRelationshipsForPart(String partName) throws IOException, XMLStreamException {
        int lastSlash = partName.lastIndexOf("/");
        if (lastSlash == -1) {
            return this.getRelationships("_rels/" + partName + ".rels");
        }
        String relPart = partName.substring(0, lastSlash) + "/_rels" + partName.substring(lastSlash) + ".rels";
        return this.getRelationships(relPart);
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.zipFile.getInputStream(entry);
    }

    public ZipFile getZip() {
        return this.zipFile;
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public Enumeration<? extends ZipEntry> entries() {
        return this.zipFile.entries();
    }
}

