/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Presentation;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

public class PowerpointDocument
extends DocumentType {
    private List<String> slideNames = new ArrayList<String>();
    private List<String> slideLayoutNames = new ArrayList<String>();
    private static final String SLIDE_LAYOUT_REL = Namespaces.DocumentRels.getDerivedURI("/slideLayout");

    public PowerpointDocument(OpenXMLZipFile zipFile, ConditionalParameters params) {
        super(zipFile, params);
    }

    @Override
    public ParseType getDefaultParseType() {
        return ParseType.MSPOWERPOINT;
    }

    @Override
    public void initialize() throws IOException, XMLStreamException {
        this.slideNames = this.findSlides();
        this.slideLayoutNames = this.findSlideLayouts(this.slideNames);
    }

    @Override
    public OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType, boolean squishable) {
        if (!this.isTranslatableType(entry.getName(), contentType)) {
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getZipFile().getFactories(), this.getParams());
        openXMLContentFilter.setPartName(entry.getName());
        ParseType parseType = ParseType.MSPOWERPOINT;
        boolean shouldSquishPart = false;
        if ("application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(contentType)) {
            openXMLContentFilter.setBInMainFile(true);
            openXMLContentFilter.setUpConfig(ParseType.MSPOWERPOINT);
            shouldSquishPart = squishable;
        } else if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            parseType = ParseType.MSPOWERPOINTCOMMENTS;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            shouldSquishPart = squishable;
        }
        openXMLContentFilter.setUpConfig(parseType);
        return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry, shouldSquishPart);
    }

    private boolean isTranslatableType(String entryName, String type) {
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")) {
            return true;
        }
        if (this.getParams().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (this.getParams().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        if (this.getParams().getTranslatePowerpointNotes() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml")) {
            return true;
        }
        if (this.getParams().getTranslatePowerpointMasters()) {
            if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")) {
                return true;
            }
            if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml") && this.slideLayoutNames.contains(entryName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException {
        OpenXMLZipFile zipFile = this.getZipFile();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        Collections.sort(entryList, new ZipEntryComparator(this.slideNames));
        return Collections.enumeration(entryList);
    }

    List<String> findSlides() throws IOException, XMLStreamException {
        OpenXMLZipFile zipFile = this.getZipFile();
        Relationships rels = zipFile.getRelationships("ppt/_rels/presentation.xml.rels");
        Presentation pres = new Presentation(zipFile.getInputFactory(), rels);
        pres.parseFromXML(zipFile.getPartReader("ppt/presentation.xml"));
        return pres.getSlidePartNames();
    }

    List<String> findSlideLayouts(List<String> slideNames) throws IOException, XMLStreamException {
        ArrayList<String> layouts = new ArrayList<String>();
        OpenXMLZipFile zipFile = this.getZipFile();
        for (String slideName : slideNames) {
            List<Relationships.Rel> rels = zipFile.getRelationshipsForPart(slideName).getRelByType(SLIDE_LAYOUT_REL);
            if (rels.isEmpty()) continue;
            layouts.add(rels.get((int)0).target);
        }
        return layouts;
    }
}

