/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentFilterBasedPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;

public class StandardPartHandler
extends ContentFilterBasedPartHandler {
    private boolean squishable;

    public StandardPartHandler(OpenXMLContentFilter contentFilter, ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, boolean squishable) {
        super(contentFilter, cparams, zipFile, entry);
        this.squishable = squishable;
    }

    @Override
    public Event open(String docId, String subDocId, LocaleId srcLang) throws IOException {
        InputStream isInputStream = new BufferedInputStream(this.zipFile.getInputStream(this.entry));
        if (this.squishable) {
            isInputStream = this.contentFilter.combineRepeatedFormat(isInputStream);
        }
        return this.openContentFilter(isInputStream, docId, subDocId, srcLang);
    }

    @Override
    public Event next() {
        Event e = super.next();
        if (e.isEndDocument() && !this.cparams.getTranslateWordHidden()) {
            this.cparams.tsExcludeWordStyles.addAll(this.contentFilter.getTsExcludeWordStyles());
        }
        return e;
    }
}

