/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.jarswitcher;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.persistence.json.jackson.JSONUtil;
import net.sf.okapi.lib.tkit.jarswitcher.VMClassLoader;
import net.sf.okapi.lib.tkit.jarswitcher.VersionInfo;
import net.sf.okapi.lib.tkit.jarswitcher.Versions;
import org.apache.commons.io.FileUtils;

public class VersionManager {
    public static final String CONFIG = "/versions.json";
    private Versions versions;
    private static final VersionInfo EMPTY_INFO = new VersionInfo();
    private VersionInfo activeVersion = EMPTY_INFO;
    private ClassLoader classLoader;
    private String path;

    public VersionManager() {
        this.versions = new Versions();
    }

    public String getPathByDate(String date) {
        return this.getVersionInfoByDate(date).getPath();
    }

    public String getLabelByDate(String date) {
        return this.getVersionInfoByDate(date).getLabel();
    }

    private boolean isDateRegistered(String date) {
        for (VersionInfo vi : this.versions) {
            if (!vi.getDate().equals(date)) continue;
            return true;
        }
        return false;
    }

    private VersionInfo getVersionInfoByDate(String date) {
        VersionInfo info = null;
        Date d = null;
        try {
            d = VersionInfo.parseLongDate(date);
        }
        catch (ParseException e) {
            try {
                d = VersionInfo.parseShortDate(date);
            }
            catch (ParseException e1) {
                return EMPTY_INFO;
            }
        }
        long time = d.getTime();
        for (VersionInfo vi : this.versions) {
            try {
                Date viDate = VersionInfo.parseShortDate(vi.getDate());
                long viTime = viDate.getTime();
                if (time < viTime) break;
                info = vi;
            }
            catch (ParseException e) {}
        }
        return info == null ? EMPTY_INFO : info;
    }

    public String getPathByLabel(String label) {
        for (VersionInfo vi : this.versions) {
            if (!vi.getLabel().equals(label)) continue;
            return vi.getPath();
        }
        return "";
    }

    private VersionInfo getVersionInfoByPath(String path) {
        for (VersionInfo vi : this.versions) {
            if (!vi.getPath().equals(path)) continue;
            return vi;
        }
        return EMPTY_INFO;
    }

    public Versions getVersions() {
        return this.versions;
    }

    public void setVersions(Versions versions) {
        this.versions = versions;
    }

    public void add(VersionInfo versionInfo) {
        if (this.isDateRegistered(versionInfo.getDate())) {
            throw new OkapiException("Date is already bound to another version");
        }
        this.getVersions().add(versionInfo);
    }

    public void add(String label, String path, String startDate) {
        this.add(new VersionInfo(label, path, startDate));
    }

    public void load(String path) {
        this.versions = (Versions)JSONUtil.fromJSON(StringUtil.readString(new File(path)));
    }

    public void load(URL url) {
        this.versions = (Versions)JSONUtil.fromJSON(StringUtil.readString(url));
    }

    public void load(URI uri) throws MalformedURLException {
        this.versions = (Versions)JSONUtil.fromJSON(StringUtil.readString(uri.toURL()));
    }

    public void load(InputStream in) {
        this.versions = (Versions)JSONUtil.fromJSON(StreamUtil.streamUtf8AsString(in));
    }

    public void store(String path) {
        String json = JSONUtil.toJSON(this.versions, true);
        StringUtil.writeString(json, new File(path));
    }

    public void store(OutputStream os) {
        String json = JSONUtil.toJSON(this.versions, true);
        StringUtil.writeString(json, os);
    }

    public String toString() {
        return JSONUtil.toJSON(this.versions, true);
    }

    public ClassLoader setClassLoader(String path) {
        return this.setClassLoader(FileUtil.fileToUrl(new File(path)));
    }

    public ClassLoader setClassLoader(URL url) {
        URL[] urls = null;
        if (url.getFile().endsWith(".jar")) {
            urls = new URL[]{url};
        } else {
            Collection jars = FileUtils.listFiles((File)FileUtil.urlToFile(url), (String[])new String[]{"jar"}, (boolean)true);
            ArrayList<URL> urlList = new ArrayList<URL>(jars.size() + 1);
            urlList.add(url);
            for (File jar : jars) {
                urlList.add(FileUtil.fileToUrl(jar));
            }
            urls = urlList.toArray(new URL[urlList.size()]);
        }
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        if (sysClassLoader instanceof VMClassLoader) {
            for (URL u : urls) {
                ((VMClassLoader)sysClassLoader).addURL(u);
            }
            this.classLoader = sysClassLoader;
        } else {
            this.classLoader = new VMClassLoader(urls);
        }
        return this.classLoader;
    }

    public void loadVersion(String label) {
        this.checkVersions();
        this.path = this.getPathByLabel(label);
        this.activeVersion = this.getVersionInfoByPath(this.path);
        this.setClassLoader(this.path);
    }

    public void loadVersion(File file) {
        this.checkVersions();
        String date = VersionInfo.getFileCreationDate(file);
        this.path = this.getPathByDate(date);
        this.activeVersion = this.getVersionInfoByPath(this.path);
        this.setClassLoader(this.path);
    }

    public void loadVersion(URL url) {
        this.checkVersions();
        this.path = url.getPath();
        this.activeVersion = EMPTY_INFO;
        this.setClassLoader(url);
    }

    private void checkVersions() {
        if (this.versions.size() == 0) {
            this.load(VersionManager.class.getResource(CONFIG));
        }
    }

    public String getActiveVersionLabel() {
        return this.activeVersion.getLabel();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPath() {
        return this.path;
    }
}

