/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.document.EventIterator;
import net.sf.okapi.lib.xliff2.document.GroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.URIContext;

public class GroupNode
extends GroupOrUnitNode {
    private GroupNode parent;
    private StartGroupData data;
    private LinkedHashMap<String, GroupOrUnitNode> nodes;

    public GroupNode(GroupNode parent, StartGroupData data) {
        if (data == null) {
            throw new InvalidParameterException("The data associated with the new group node must not be null.");
        }
        this.parent = parent;
        this.data = data;
        this.nodes = new LinkedHashMap();
    }

    public StartGroupData get() {
        return this.data;
    }

    @Override
    public boolean isUnit() {
        return false;
    }

    public UnitNode add(UnitNode node) {
        this.nodes.put("u" + node.get().getId(), node);
        return node;
    }

    public GroupNode add(GroupNode node) {
        this.nodes.put("g" + node.get().getId(), node);
        return node;
    }

    public GroupNode getParent() {
        return this.parent;
    }

    public UnitNode getUnitNode(String id) {
        UnitNode item = (UnitNode)this.nodes.get("u" + id);
        if (item != null) {
            return item;
        }
        for (GroupOrUnitNode node : this.nodes.values()) {
            if (node.isUnit() || (item = ((GroupNode)node).getUnitNode(id)) == null) continue;
            return item;
        }
        return null;
    }

    public GroupNode getGroupNode(String id) {
        GroupNode item = (GroupNode)this.nodes.get("g" + id);
        if (item != null) {
            return item;
        }
        for (GroupOrUnitNode node : this.nodes.values()) {
            if (node.isUnit() || (item = ((GroupNode)node).getGroupNode(id)) == null) continue;
            return item;
        }
        return null;
    }

    public Iterator<GroupOrUnitNode> createGroupOrUnitIterator() {
        return this.nodes.values().iterator();
    }

    public Iterator<Event> createEventIterator(Stack<URIContext> uriContext) {
        EventIterator ei = new EventIterator(){
            private Iterator<GroupOrUnitNode> topIter;
            private Stack<Iterator<GroupOrUnitNode>> groups;
            private Iterator<GroupOrUnitNode> groupIter;
            private int state;
            {
                this.topIter = GroupNode.this.nodes.values().iterator();
                this.groups = new Stack();
                this.groupIter = null;
                this.state = 0;
            }

            @Override
            public boolean hasNext() {
                switch (this.state) {
                    case 0: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                }
                if (this.groupIter != null) {
                    if (this.groupIter.hasNext()) {
                        return true;
                    }
                    this.groups.pop();
                    this.state = 2;
                    this.groupIter = this.groups.isEmpty() ? null : this.groups.peek();
                    return true;
                }
                if (this.topIter.hasNext()) {
                    return true;
                }
                this.state = 3;
                return true;
            }

            @Override
            public Event next() {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                        ((URIContext)this.uriContext.peek()).setGroupId(GroupNode.this.data.getId());
                        return new Event(EventType.START_GROUP, (URIContext)this.uriContext.peek(), GroupNode.this.data);
                    }
                    case 2: {
                        this.state = 1;
                        this.uriContext.pop();
                        return new Event(EventType.END_GROUP, null);
                    }
                    case 3: {
                        this.state = -1;
                        this.uriContext.pop();
                        return new Event(EventType.END_GROUP, null);
                    }
                }
                if (this.groupIter != null) {
                    GroupOrUnitNode node = this.groupIter.next();
                    if (node.isUnit()) {
                        this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                        ((URIContext)this.uriContext.peek()).setUnitId(((UnitNode)node).get().getId());
                        Event event = new Event(EventType.TEXT_UNIT, (URIContext)this.uriContext.peek(), ((UnitNode)node).get());
                        this.uriContext.pop();
                        return event;
                    }
                    GroupNode gn = (GroupNode)node;
                    this.groups.push(gn.createGroupOrUnitIterator());
                    this.groupIter = this.groups.peek();
                    this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                    ((URIContext)this.uriContext.peek()).setGroupId(gn.get().getId());
                    return new Event(EventType.START_GROUP, (URIContext)this.uriContext.peek(), gn.get());
                }
                GroupOrUnitNode node = this.topIter.next();
                if (node.isUnit()) {
                    this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                    ((URIContext)this.uriContext.peek()).setUnitId(((UnitNode)node).get().getId());
                    Event event = new Event(EventType.TEXT_UNIT, (URIContext)this.uriContext.peek(), ((UnitNode)node).get());
                    this.uriContext.pop();
                    return event;
                }
                GroupNode gn = (GroupNode)node;
                this.groups.push(gn.createGroupOrUnitIterator());
                this.groupIter = this.groups.peek();
                this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                ((URIContext)this.uriContext.peek()).setGroupId(gn.get().getId());
                return new Event(EventType.START_GROUP, (URIContext)this.uriContext.peek(), gn.get());
            }
        };
        ei.setURIContext(uriContext);
        return ei;
    }
}

