/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.pipeline;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.sf.okapi.applications.rainbow.pipeline.EmbeddableEditorButton;
import net.sf.okapi.applications.rainbow.pipeline.PipelineWrapper;
import net.sf.okapi.applications.rainbow.pipeline.StepInfo;
import net.sf.okapi.applications.rainbow.pipeline.StepPicker;
import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiEditorCreationException;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.ui.DefaultEmbeddableEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.genericeditor.GenericEmbeddableEditor;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PipelineEditor {
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_CLOSE = 1;
    public static final int RESULT_EXECUTE = 2;
    private Shell shell;
    private int result;
    private IHelp help;
    private PipelineWrapper wrapper;
    private Map<String, StepInfo> availableSteps;
    private ArrayList<StepInfo> workSteps;
    private ArrayList<ISWTEmbeddableParametersEditor> panels;
    private Text edPath;
    private List lbSteps;
    private Button btLoad;
    private Button btSave;
    private Button btSaveAs;
    private Button btNew;
    private Button btAddStep;
    private Button btRemoveStep;
    private Button btMoveStepUp;
    private Button btMoveStepDown;
    private Button btStepHelp;
    private Text edDescription;
    private BaseContext context;
    private String predefined;
    private Composite optionsHolder;
    private Composite noParametersPanel;
    private Composite noStepsPanel;
    private Point minSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int edit(Shell parent, Map<String, StepInfo> availableSteps, PipelineWrapper wrapper, String predefined, IHelp helpParam, String projectDir, int initialSelectedStep) {
        this.context = new BaseContext();
        this.context.setObject("shell", parent);
        this.predefined = predefined;
        int result = 0;
        try {
            this.availableSteps = availableSteps;
            this.wrapper = wrapper;
            this.help = helpParam;
            this.create(parent);
            this.setDataFromWrapper();
            this.populate(0);
            if (this.lbSteps.getItemCount() > 0) {
                this.lbSteps.setFocus();
            }
            if (initialSelectedStep > -1 && initialSelectedStep < this.lbSteps.getItemCount()) {
                this.lbSteps.select(initialSelectedStep);
            } else {
                for (int i = 0; i < this.workSteps.size(); ++i) {
                    if (this.workSteps.get((int)i).paramsData == null) continue;
                    this.lbSteps.select(i);
                    break;
                }
            }
            this.updateStepDisplay();
            result = this.showDialog();
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            result = 0;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return result;
    }

    private void setDataFromWrapper() {
        this.workSteps = new ArrayList();
        this.panels = new ArrayList();
        for (StepInfo step : this.wrapper.getSteps()) {
            this.workSteps.add(step.clone());
            this.panels.add(this.createPanel(step));
        }
    }

    private int showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void create(Shell parent) {
        this.shell = new Shell(parent, 65648);
        if (this.predefined == null) {
            this.shell.setText("Edit / Execute Pipeline");
        } else {
            this.shell.setText("Pre-Defined Pipeline : " + this.predefined);
        }
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        this.edPath = new Text((Composite)this.shell, 2048);
        this.edPath.setLayoutData((Object)new GridData(768));
        this.edPath.setEditable(false);
        int width = 100;
        Composite cmpTmp = new Composite((Composite)this.shell, 0);
        GridLayout layTmp = new GridLayout(2, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        cmpTmp.setLayout((Layout)layTmp);
        GridData gdTmp = new GridData(1808);
        cmpTmp.setLayoutData((Object)gdTmp);
        this.lbSteps = new List(cmpTmp, 2816);
        gdTmp = new GridData(1040);
        gdTmp.widthHint = 185;
        gdTmp.heightHint = 300;
        this.lbSteps.setLayoutData((Object)gdTmp);
        this.lbSteps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineEditor.this.updateStepDisplay();
            }
        });
        this.optionsHolder = new Composite(cmpTmp, 0);
        this.optionsHolder.setLayoutData((Object)new GridData(1808));
        StackLayout stkTmp = new StackLayout();
        stkTmp.marginHeight = 0;
        stkTmp.marginWidth = 0;
        this.optionsHolder.setLayout((Layout)stkTmp);
        this.noParametersPanel = new Composite(this.optionsHolder, 2048);
        this.noParametersPanel.setLayoutData((Object)new GridData(1808));
        this.noParametersPanel.setLayout((Layout)new GridLayout());
        Label stTmp = new Label(this.noParametersPanel, 0);
        stTmp.setText("This step has no parameters");
        this.noStepsPanel = new Composite(this.optionsHolder, 2048);
        this.noStepsPanel.setLayoutData((Object)new GridData(1808));
        this.noStepsPanel.setLayout((Layout)new GridLayout());
        stTmp = new Label(this.noStepsPanel, 0);
        stTmp.setText("Click on \"Add Step\" to start");
        cmpTmp = new Composite((Composite)this.shell, 0);
        cmpTmp.setLayout((Layout)new GridLayout(4, false));
        gdTmp = new GridData(768);
        cmpTmp.setLayoutData((Object)gdTmp);
        if (this.predefined == null) {
            this.btAddStep = new Button(cmpTmp, 8);
            this.btAddStep.setText("Add Step...");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btAddStep.setLayoutData((Object)gdTmp);
            this.btAddStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.addStep();
                }
            });
            this.btRemoveStep = new Button(cmpTmp, 8);
            this.btRemoveStep.setText("Remove Step");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btRemoveStep.setLayoutData((Object)gdTmp);
            this.btRemoveStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.removeStep();
                }
            });
            this.btMoveStepUp = new Button(cmpTmp, 8);
            this.btMoveStepUp.setText("Move Up");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btMoveStepUp.setLayoutData((Object)gdTmp);
            this.btMoveStepUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.moveStepUp();
                }
            });
            this.btMoveStepDown = new Button(cmpTmp, 8);
            this.btMoveStepDown.setText("Move Down");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btMoveStepDown.setLayoutData((Object)gdTmp);
            this.btMoveStepDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.moveStepDown();
                }
            });
            this.btLoad = new Button(cmpTmp, 8);
            this.btLoad.setText("Load...");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btLoad.setLayoutData((Object)gdTmp);
            this.btLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.load(null);
                }
            });
            this.btNew = new Button(cmpTmp, 8);
            this.btNew.setText("New");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btNew.setLayoutData((Object)gdTmp);
            this.btNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.newPipeline();
                }
            });
            this.btSave = new Button(cmpTmp, 8);
            this.btSave.setText("Save");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btSave.setLayoutData((Object)gdTmp);
            this.btSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.save(PipelineEditor.this.predefined == null ? PipelineEditor.this.edPath.getText() : null);
                }
            });
            this.btSaveAs = new Button(cmpTmp, 8);
            this.btSaveAs.setText("Save As...");
            gdTmp = new GridData(2);
            gdTmp.widthHint = width;
            this.btSaveAs.setLayoutData((Object)gdTmp);
            this.btSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipelineEditor.this.save(null);
                }
            });
        }
        this.btStepHelp = new Button(cmpTmp, 8);
        this.btStepHelp.setText("Step Help");
        gdTmp = new GridData(2);
        gdTmp.widthHint = width;
        this.btStepHelp.setLayoutData((Object)gdTmp);
        this.btStepHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineEditor.this.showStepHelp();
            }
        });
        this.edDescription = new Text(cmpTmp, 2624);
        gdTmp = new GridData(768);
        gdTmp.heightHint = 48;
        gdTmp.horizontalSpan = 3;
        this.edDescription.setLayoutData((Object)gdTmp);
        this.edDescription.setEditable(false);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineEditor.this.result = 0;
                if (e.widget.getData().equals("h")) {
                    if (PipelineEditor.this.help != null) {
                        PipelineEditor.this.help.showWiki("Rainbow - Edit / Execute Pipeline");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!PipelineEditor.this.saveData()) {
                        return;
                    }
                    PipelineEditor.this.result = 1;
                }
                if (e.widget.getData().equals("x")) {
                    if (!PipelineEditor.this.saveData()) {
                        return;
                    }
                    PipelineEditor.this.result = 2;
                }
                PipelineEditor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true, "Close", "Execute");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        pnlActions.setLayoutData(gdTmp);
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.minSize = this.shell.getSize();
        this.shell.setMinimumSize(this.minSize);
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 750) {
            startSize.x = 750;
        }
        if (startSize.y < 350) {
            startSize.y = 350;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
    }

    private void updateStepDisplay() {
        int n = this.lbSteps.getSelectionIndex();
        Control ctrl = ((StackLayout)this.optionsHolder.getLayout()).topControl;
        this.edDescription.setText("");
        if (n < 0) {
            if (this.predefined == null) {
                this.btAddStep.setEnabled(true);
                this.btRemoveStep.setEnabled(false);
                this.btMoveStepUp.setEnabled(false);
                this.btMoveStepDown.setEnabled(false);
                this.btStepHelp.setEnabled(false);
            }
            if (ctrl == null || !ctrl.equals(this.noStepsPanel)) {
                ((StackLayout)this.optionsHolder.getLayout()).topControl = this.noStepsPanel;
                this.optionsHolder.layout();
            }
            this.optionsHolder.layout();
            this.optionsHolder.getParent().layout();
            return;
        }
        StepInfo step = this.workSteps.get(n);
        if (this.predefined == null) {
            this.btAddStep.setEnabled(true);
            this.btRemoveStep.setEnabled(true);
            this.btMoveStepUp.setEnabled(n > 0);
            this.btMoveStepDown.setEnabled(n < this.workSteps.size() - 1);
        }
        this.btStepHelp.setEnabled(this.help != null);
        ISWTEmbeddableParametersEditor panel = this.panels.get(n);
        if (panel.getComposite() == null) {
            if (ctrl == null || !ctrl.equals(this.noParametersPanel)) {
                ((StackLayout)this.optionsHolder.getLayout()).topControl = this.noParametersPanel;
                this.optionsHolder.layout();
            }
        } else if (ctrl == null || !ctrl.equals(panel.getComposite())) {
            ((StackLayout)this.optionsHolder.getLayout()).topControl = panel.getComposite();
            this.optionsHolder.layout();
            Point needed = this.shell.computeSize(-1, -1, true);
            needed.x -= 32;
            Point size = this.shell.getSize();
            if (size.x < needed.x) {
                size.x = needed.x;
            }
            if (size.y < needed.y) {
                size.y = needed.y;
            }
            this.shell.setSize(size);
            if (this.minSize.x < needed.x) {
                this.minSize.x = needed.x;
            }
            if (this.minSize.y < needed.y) {
                this.minSize.y = needed.y;
            }
        }
        this.edDescription.setText(step.description);
    }

    private void populate(int index) {
        if (this.predefined != null) {
            this.edPath.setText(this.predefined);
        } else {
            this.edPath.setText(this.wrapper.getPath() == null ? "" : this.wrapper.getPath());
        }
        this.lbSteps.removeAll();
        for (StepInfo step : this.workSteps) {
            this.lbSteps.add(step.name);
        }
        if (index != -1 && (index < 0 || index > this.lbSteps.getItemCount())) {
            index = -1;
        }
        if (index == -1) {
            index = 0;
        }
        this.lbSteps.select(index);
        this.updateStepDisplay();
    }

    private void moveStepUp() {
        try {
            int n = this.lbSteps.getSelectionIndex();
            if (n <= 0) {
                return;
            }
            StepInfo tmp = this.workSteps.get(n - 1);
            ISWTEmbeddableParametersEditor tmpPanel = this.panels.get(n - 1);
            this.workSteps.set(n - 1, this.workSteps.get(n));
            this.panels.set(n - 1, this.panels.get(n));
            this.workSteps.set(n, tmp);
            this.panels.set(n, tmpPanel);
            this.populate(n - 1);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void showStepHelp() {
        try {
            if (this.help == null) {
                return;
            }
            int n = this.lbSteps.getSelectionIndex();
            if (n == -1) {
                return;
            }
            StepInfo si = this.workSteps.get(n);
            IPipelineStep step = si.loader == null ? (IPipelineStep)Class.forName(si.stepClass).newInstance() : (IPipelineStep)Class.forName(si.stepClass, true, si.loader).newInstance();
            String stepHelp = step.getHelpLocation();
            if (Util.isEmpty(stepHelp)) {
                return;
            }
            if (stepHelp.startsWith(".")) {
                String path = Util.getClassLocation(step.getClass());
                if (Util.isEmpty(path)) {
                    return;
                }
                path = path + File.separator + stepHelp + File.separator;
                n = si.stepClass.lastIndexOf(46);
                Util.openURL(path + si.stepClass.substring(n + 1).toLowerCase() + ".html");
            } else if (stepHelp.endsWith(".html")) {
                Util.openURL(stepHelp);
            } else {
                this.help.showWiki(stepHelp);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void moveStepDown() {
        try {
            int n = this.lbSteps.getSelectionIndex();
            if (n > this.lbSteps.getItemCount() - 1) {
                return;
            }
            StepInfo tmp = this.workSteps.get(n + 1);
            ISWTEmbeddableParametersEditor tmpPanel = this.panels.get(n + 1);
            this.workSteps.set(n + 1, this.workSteps.get(n));
            this.panels.set(n + 1, this.panels.get(n));
            this.workSteps.set(n, tmp);
            this.panels.set(n, tmpPanel);
            this.populate(n + 1);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void addStep() {
        try {
            StepPicker dlg = new StepPicker(this.shell, this.availableSteps, this.help);
            String id = dlg.showDialog();
            if (id == null) {
                return;
            }
            StepInfo info = this.availableSteps.get(id).clone();
            this.workSteps.add(info);
            this.panels.add(this.createPanel(info));
            this.lbSteps.add(info.name);
            this.lbSteps.select(this.lbSteps.getItemCount() - 1);
            this.updateStepDisplay();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void removeStep() {
        try {
            int n = this.lbSteps.getSelectionIndex();
            if (n < 0) {
                return;
            }
            this.workSteps.remove(n);
            this.panels.remove(n);
            if (n >= this.workSteps.size()) {
                n = this.workSteps.size() - 1;
            }
            this.populate(n);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private ISWTEmbeddableParametersEditor createPanel(StepInfo stepInfo) {
        try {
            if (stepInfo.paramsData == null) {
                return new DefaultEmbeddableEditor();
            }
            if (stepInfo.paramsClass == null) {
                return new DefaultEmbeddableEditor();
            }
            IParameters params = stepInfo.loader == null ? (IParameters)Class.forName(stepInfo.paramsClass).newInstance() : (IParameters)Class.forName(stepInfo.paramsClass, true, stepInfo.loader).newInstance();
            params.fromString(stepInfo.paramsData);
            IParametersEditor editor = null;
            try {
                editor = this.wrapper.getEditorMapper().createParametersEditor(stepInfo.paramsClass);
            }
            catch (OkapiEditorCreationException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
            }
            if (editor != null) {
                if (ISWTEmbeddableParametersEditor.class.isAssignableFrom(editor.getClass())) {
                    ((ISWTEmbeddableParametersEditor)((Object)editor)).initializeEmbeddableEditor(this.optionsHolder, params, this.context);
                    return (ISWTEmbeddableParametersEditor)((Object)editor);
                }
                EmbeddableEditorButton tmp = new EmbeddableEditorButton(editor);
                tmp.initializeEmbeddableEditor(this.optionsHolder, params, this.context);
                return tmp;
            }
            IEditorDescriptionProvider descProv = this.wrapper.getEditorMapper().getDescriptionProvider(stepInfo.paramsClass);
            if (descProv != null) {
                GenericEmbeddableEditor geedit = new GenericEmbeddableEditor(descProv);
                geedit.initializeEmbeddableEditor(this.optionsHolder, params, this.context);
                return geedit;
            }
            DefaultEmbeddableEditor defEditor = new DefaultEmbeddableEditor();
            defEditor.initializeEmbeddableEditor(this.optionsHolder, params, this.context);
            return defEditor;
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return new DefaultEmbeddableEditor();
        }
    }

    private boolean saveData() {
        try {
            for (int i = 0; i < this.workSteps.size(); ++i) {
                StepInfo step = this.workSteps.get(i);
                ISWTEmbeddableParametersEditor panel = this.panels.get(i);
                if (panel.getComposite() == null) continue;
                String data = panel.validateAndSaveParameters();
                if (data == null) {
                    this.lbSteps.select(i);
                    this.updateStepDisplay();
                    return false;
                }
                step.paramsData = data;
            }
            this.wrapper.clear();
            for (StepInfo step2 : this.workSteps) {
                this.wrapper.addStep(step2);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        return true;
    }

    private void save(String path) {
        try {
            if (Util.isEmpty(path) && (path = Dialogs.browseFilenamesForSave(this.shell, "Save Pipeline As", null, null, "Pipeline Files (*.pln)\tAll Files (*.*)", "*.pln\t*.*")) == null) {
                return;
            }
            if (!this.saveData()) {
                return;
            }
            this.wrapper.save(path);
            if (this.predefined != null) {
                this.predefined = null;
                this.updateStepDisplay();
            }
            this.edPath.setText(this.wrapper.getPath());
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void load(String path) {
        try {
            if (path == null || path.length() == 0) {
                String[] paths = Dialogs.browseFilenames(this.shell, "Load Pipeline", false, null, "Pipeline Files (*.pln)\tAll Files (*.*)", "*.pln\t*.*");
                if (paths == null) {
                    return;
                }
                path = paths[0];
            }
            this.wrapper.load(path);
            this.setDataFromWrapper();
            this.populate(-1);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void newPipeline() {
        if (this.lbSteps.getItemCount() > 0) {
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setText("Rainbow");
            dlg.setMessage("This command will delete all the steps in the current pipeline.\nDo you want to proceed?");
            if (dlg.open() != 64) {
                return;
            }
        }
        this.wrapper.setPath(null);
        this.wrapper.clear();
        this.setDataFromWrapper();
        this.populate(-1);
    }
}

