/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.core.CloneFactory;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtChildType;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.IExtChild;

public class ExtElement
implements IExtChild {
    private final QName qName;
    private ExtAttributes attrs;
    private ArrayList<IExtChild> children;

    public ExtElement(ExtElement original) {
        this(original.qName);
        if (original.attrs != null) {
            this.setExtAttributes(new ExtAttributes(original.attrs));
        }
        if (original.children != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            for (IExtChild child : original.children) {
                this.children.add(CloneFactory.create(child));
            }
        }
    }

    public ExtElement(QName qName) {
        this.qName = qName;
    }

    public QName getQName() {
        return this.qName;
    }

    public ExtAttributes getAttributes() {
        if (this.attrs == null) {
            this.attrs = new ExtAttributes();
        }
        return this.attrs;
    }

    public void setExtAttributes(ExtAttributes attributes) {
        this.attrs = attributes;
    }

    @Override
    public ExtChildType getType() {
        return ExtChildType.ELEMENT;
    }

    public boolean hasChild() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() > 0;
    }

    public List<IExtChild> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public ExtElement getFirstElement(String namespaceURI, String localName) {
        if (this.children == null) {
            return null;
        }
        QName qn = new QName(namespaceURI, localName);
        for (IExtChild child : this.children) {
            if (child.getType() != ExtChildType.ELEMENT || !((ExtElement)child).getQName().equals(qn)) continue;
            return (ExtElement)child;
        }
        return null;
    }

    public ExtElement getFirstElement() {
        if (this.children == null) {
            return null;
        }
        for (IExtChild child : this.children) {
            if (child.getType() != ExtChildType.ELEMENT) continue;
            return (ExtElement)child;
        }
        return null;
    }

    public ExtContent getFirstContent() {
        if (this.children == null) {
            return null;
        }
        for (IExtChild child : this.children) {
            if (child.getType() == ExtChildType.ELEMENT) continue;
            return (ExtContent)child;
        }
        return null;
    }

    public IExtChild addChild(IExtChild child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return child;
    }

    public ExtElement addElement(String namespaceURI, String localPart, String prefix) {
        return (ExtElement)this.addChild(new ExtElement(new QName(namespaceURI, localPart, prefix)));
    }

    public ExtElement addElement(String localPart) {
        return this.addElement(this.qName.getNamespaceURI(), localPart, this.qName.getPrefix());
    }

    public ExtContent addContent(String text) {
        return (ExtContent)this.addChild(new ExtContent(text));
    }

    public boolean isModule() {
        return this.qName.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:");
    }
}

