/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.AnnotatedSpan;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CloneFactory;
import net.sf.okapi.lib.xliff2.core.CompleteData;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IWithStore;
import net.sf.okapi.lib.xliff2.core.InvalidMarkerOrderException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.PCont;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.glossary.Glossary;
import net.sf.okapi.lib.xliff2.its.DataCategoryGroup;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;
import net.sf.okapi.lib.xliff2.its.IWithITSGroups;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.matches.Matches;

public class Unit
extends CompleteData
implements Iterable<Part>,
IWithStore,
IWithITSAttributes,
IWithITSGroups {
    private final Store store = new Store(this);
    private ArrayList<Part> parts;
    private List<DataCategoryGroup<?>> itsList;
    private ITSItems itsItems;
    private Matches matches;
    private Glossary glossary;

    public Unit(Unit original) {
        super(original);
        this.parts = new ArrayList(original.getPartCount());
        for (Part part : original) {
            this.parts.add(CloneFactory.create(part));
        }
        if (original.hasITSGroup()) {
            for (DataCategoryGroup dataCategoryGroup : original.getITSGroups()) {
                this.addITSGroup((DataCategoryGroup)dataCategoryGroup.createCopy());
            }
        }
        if (original.hasITSItem()) {
            this.itsItems = new ITSItems(original.itsItems);
        }
        if (original.hasMatch()) {
            this.matches = new Matches(original.matches);
        }
        if (original.hasGlossEntry()) {
            this.glossary = new Glossary(original.glossary);
        }
    }

    public Unit(String id) {
        if (Util.isNoE(id)) {
            throw new InvalidParameterException("Id cannot be null or empty.");
        }
        this.setId(id);
        this.parts = new ArrayList(1);
    }

    public Unit(String id, StartFileData startFileData) {
        this(id);
        if (startFileData != null) {
            this.setSourceDir(startFileData.getSourceDir());
            this.setTargetDir(startFileData.getTargetDir());
        }
    }

    @Override
    public Iterator<Part> iterator() {
        return this.parts.iterator();
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public int getSegmentCount() {
        int count = 0;
        for (Part part : this.parts) {
            if (!part.isSegment()) continue;
            ++count;
        }
        return count;
    }

    public Segment appendSegment() {
        Segment seg = new Segment(this.store);
        this.parts.add(seg);
        return seg;
    }

    public Part appendIgnorable() {
        Part part = new Part(this.store);
        this.parts.add(part);
        return part;
    }

    public Part getPart(int partIndex) {
        return this.parts.get(partIndex);
    }

    public Segment getSegment(int segIndex) {
        int si = 0;
        int i = 0;
        while (i < this.parts.size()) {
            if (this.parts.get(i).isSegment()) {
                if (si == segIndex) {
                    return (Segment)this.parts.get(i);
                }
                ++si;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(String.format("The index %d is out-of-bound for segments.", segIndex));
    }

    public Store getStore() {
        return this.store;
    }

    @Override
    public boolean isIdUsed(String id) {
        return this.getObjectFromId(id) != null;
    }

    public Object getObjectFromId(String id) {
        for (Part part : this.parts) {
            if (!id.equals(part.getId())) continue;
            return part;
        }
        return this.store.getTag(id);
    }

    public void split(int partIndex, int srcStart, int srcEnd, int trgStart, int trgEnd, boolean changeState) {
        Segment seg;
        Part part = this.getPart(partIndex);
        if (!part.isSegment()) {
            throw new InvalidParameterException("Cannot split a non-segment part.");
        }
        Segment oriSeg = (Segment)part;
        Fragment src = part.getSource();
        String srcCt = src.getCodedText();
        if (srcEnd == -1) {
            srcEnd = srcCt.length() - 1;
        }
        if (srcStart > srcEnd) {
            throw new InvalidParameterException("Invalid source range.");
        }
        if (srcStart < 0 || srcCt.length() < srcEnd) {
            throw new InvalidParameterException("Source range out of bounds.");
        }
        String trgCt = null;
        boolean hasTarget = oriSeg.hasTarget();
        if (hasTarget) {
            trgCt = oriSeg.getTarget().getCodedText();
            if (trgStart > trgEnd) {
                throw new InvalidParameterException("Invalid target range.");
            }
            if (trgStart < 0 || trgCt.length() < trgEnd) {
                throw new InvalidParameterException("Target range out of bounds.");
            }
        }
        String srcMid = srcCt.substring(srcStart, srcEnd);
        boolean srcToDo = true;
        if (srcMid.isEmpty() && (srcStart == 0 || srcStart >= srcCt.length())) {
            srcToDo = false;
        }
        String trgMid = "";
        if (hasTarget && (trgMid = trgCt.substring(trgStart, trgEnd)).isEmpty() & (trgStart == 0 || trgStart >= trgCt.length()) && !srcToDo) {
            return;
        }
        String srcLeft = srcCt.substring(0, srcStart);
        String srcRight = srcCt.substring(srcEnd);
        String trgLeft = "";
        String trgRight = "";
        if (hasTarget) {
            trgLeft = trgCt.substring(0, trgStart);
            trgRight = trgCt.substring(trgEnd);
        }
        if (srcMid.isEmpty()) {
            srcMid = srcRight;
            srcRight = "";
        }
        if (srcLeft.isEmpty()) {
            srcLeft = srcMid;
            srcMid = "";
        }
        if (trgMid.isEmpty()) {
            trgMid = trgRight;
            trgRight = "";
        }
        if (trgLeft.isEmpty()) {
            trgLeft = trgMid;
            trgMid = "";
        }
        if (!srcLeft.isEmpty() || !trgLeft.isEmpty()) {
            part.getSource().setCodedText(srcLeft);
            if (hasTarget) {
                part.getTarget().setCodedText(trgLeft);
            }
        }
        int added = 0;
        if (!srcMid.isEmpty() || !trgMid.isEmpty()) {
            seg = oriSeg.createAndCopyMetadata();
            seg.getSource().setCodedText(srcMid);
            if (hasTarget) {
                seg.getTarget().setCodedText(trgMid);
            }
            this.parts.add(partIndex + ++added, seg);
        }
        if (!srcRight.isEmpty() || !trgRight.isEmpty()) {
            seg = oriSeg.createAndCopyMetadata();
            seg.getSource().setCodedText(srcRight);
            if (hasTarget) {
                seg.getTarget().setCodedText(trgRight);
            }
            this.parts.add(partIndex + ++added, seg);
        }
        if (added > 0) {
            if (this.hasTargetOrder()) {
                int oriOrder = this.parts.get(partIndex).getTargetOrder();
                int resolvedOriOrder = oriOrder > 0 ? oriOrder : partIndex + 1;
                int i = 0;
                while (i < this.parts.size()) {
                    if (i == partIndex + 1) {
                        this.parts.get(i).setTargetOrder(resolvedOriOrder + 1);
                    } else if (added == 2 && i == partIndex + 2) {
                        this.parts.get(i).setTargetOrder(resolvedOriOrder + 2);
                    } else {
                        int order = this.parts.get(i).getTargetOrder();
                        int oldResolvedOrder = order > 0 ? order : (i <= partIndex ? i + 1 : i - added + 1);
                        int newOrder = oldResolvedOrder;
                        if (oldResolvedOrder > resolvedOriOrder) {
                            newOrder = oldResolvedOrder + added;
                        }
                        if (i + 1 == newOrder) {
                            this.parts.get(i).setTargetOrder(0);
                        } else {
                            this.parts.get(i).setTargetOrder(newOrder);
                        }
                    }
                    ++i;
                }
            }
            if (changeState && hasTarget) {
                int i = 0;
                while (i <= added) {
                    part = this.parts.get(partIndex + i);
                    if (part.isSegment()) {
                        Segment seg2 = (Segment)part;
                        switch (seg2.getState()) {
                            case INITIAL: 
                            case TRANSLATED: {
                                break;
                            }
                            default: {
                                seg2.setState(TargetState.TRANSLATED);
                                seg2.setSubState(null);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public boolean hasTargetOrder() {
        int i = 0;
        while (i < this.parts.size()) {
            if (this.parts.get(i).getTargetOrder() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void join(int startPartIndex, int endPartIndex, boolean restrictedJoin, boolean adjustTargetIgnorable) {
        Part part;
        int i;
        if (startPartIndex < 0 || startPartIndex >= this.getPartCount()) {
            throw new InvalidParameterException("Invalid startPartIndex value.");
        }
        if (endPartIndex == -1) {
            endPartIndex = this.getPartCount() - 1;
        }
        if (endPartIndex == startPartIndex) {
            return;
        }
        if (endPartIndex <= startPartIndex || endPartIndex >= this.getPartCount()) {
            throw new InvalidParameterException("Invalid endPartIndex value.");
        }
        List<Part> list = this.getTargetOrderedParts();
        Part startPart = list.get(startPartIndex);
        if (restrictedJoin) {
            if (startPart.isSegment() && !((Segment)startPart).getCanResegment()) {
                throw new InvalidParameterException("The first segment cannot be re-segmented.");
            }
            i = startPartIndex + 1;
            do {
                Part part2;
                if (!(part2 = list.get(i)).isSegment() || ((Segment)part2).getCanResegment()) continue;
                throw new InvalidParameterException("One of more of the segments cannot be re-segmented.");
            } while (++i <= endPartIndex);
        }
        Fragment startSource = startPart.getSource();
        Fragment startTarget = startPart.getTarget();
        i = startPartIndex + 1;
        do {
            part = list.get(i);
            Fragment frag = part.getSource();
            startSource.append(frag);
            if (part.hasTarget()) {
                frag = part.getTarget();
                if (startTarget != null) {
                    startTarget.append(frag);
                } else {
                    startPart.setTarget(frag);
                }
            } else if (!part.isSegment()) {
                // empty if block
            }
            if (startPart.getPreserveWS() != part.getPreserveWS()) {
                startPart.setPreserveWS(true);
            }
            if (!startPart.isSegment() || !part.isSegment()) continue;
            Segment startSeg = (Segment)startPart;
            Segment seg = (Segment)part;
            if (startSeg.getState().compareTo(seg.getState()) <= 0) continue;
            startSeg.setState(seg.getState());
            startSeg.setSubState(seg.getSubState());
        } while (++i <= endPartIndex);
        i = startPartIndex + 1;
        do {
            part = list.get(startPartIndex + 1);
            list.remove(startPartIndex + 1);
            this.parts.remove(part);
        } while (++i <= endPartIndex);
        if (this.hasTargetOrder()) {
            int removedCount = endPartIndex - startPartIndex;
            int srcOrder = 1;
            for (Part part3 : this.parts) {
                int order = part3.getTargetOrder();
                if (order == 0) {
                    order = srcOrder;
                }
                if (order > startPartIndex + 1) {
                    part3.setTargetOrder(order - removedCount == srcOrder ? 0 : order - removedCount);
                }
                ++srcOrder;
            }
        }
    }

    public void joinAll(boolean adjustTargetIgnorable) {
        int start = 0;
        List<Part> list = this.getTargetOrderedParts();
        while (true) {
            if (start < list.size()) {
                Part part = list.get(start);
                if (!part.isSegment() || !((Segment)part).getCanResegment()) {
                    ++start;
                    continue;
                }
            }
            if (start >= list.size()) {
                return;
            }
            int end = start + 1;
            while (end < list.size()) {
                Part part = list.get(end);
                if (part.isSegment() && !((Segment)part).getCanResegment()) break;
                ++end;
            }
            this.join(start, end - 1, true, adjustTargetIgnorable);
            list = this.getTargetOrderedParts();
            ++start;
        }
    }

    public Iterable<Segment> getSegments() {
        return new Iterable<Segment>(){

            @Override
            public Iterator<Segment> iterator() {
                return new Iterator<Segment>(){
                    int current = 0;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("The method remove() not supported.");
                    }

                    @Override
                    public Segment next() {
                        while (this.current < Unit.this.parts.size()) {
                            Part part = (Part)Unit.this.parts.get(++this.current - 1);
                            if (!part.isSegment()) continue;
                            return (Segment)part;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        int tmp = this.current;
                        while (tmp < Unit.this.parts.size()) {
                            if (((Part)Unit.this.parts.get(tmp)).isSegment()) {
                                return true;
                            }
                            ++tmp;
                        }
                        return false;
                    }
                };
            }
        };
    }

    public List<Part> getTargetOrderedParts() {
        ArrayList<Part> list = new ArrayList<Part>(this.parts);
        int index = 1;
        for (Part part : this.parts) {
            int order = part.getTargetOrder();
            if (order == 0) {
                order = index;
            }
            list.set(order - 1, part);
            ++index;
        }
        return list;
    }

    public String getPlainText(boolean target, boolean useSourceForMissingTargetIgnorables) {
        List<Part> tmpParts = target ? this.getTargetOrderedParts() : this.parts;
        StringBuilder tmp = new StringBuilder();
        for (Part part : tmpParts) {
            if (target) {
                if (part.hasTarget()) {
                    tmp.append(part.getTarget().getPlainText());
                    continue;
                }
                if (!useSourceForMissingTargetIgnorables) continue;
                tmp.append(part.getSource().getPlainText());
                continue;
            }
            tmp.append(part.getSource().getPlainText());
        }
        return tmp.toString();
    }

    public void hideProtectedContent() {
        this.hideProtectedContent(true);
        this.hideProtectedContent(false);
    }

    private void hideProtectedContent(boolean doSource) {
        List<Part> list = doSource ? this.parts : this.getTargetOrderedParts();
        Stack<TransInfo> stack = new Stack<TransInfo>();
        stack.push(new TransInfo("", this.getTranslate()));
        for (Part part : list) {
            if (doSource) {
                this.hideProtectedContent(part.getSource(), stack);
                continue;
            }
            if (!part.hasTarget()) continue;
            this.hideProtectedContent(part.getTarget(), stack);
        }
    }

    private void hideProtectedContent(Fragment fragment, Stack<TransInfo> stack) {
        int start = 0;
        int pos = 0;
        int offset = 0;
        String ct = fragment.getCodedText();
        Tags tags = fragment.getTags();
        StringBuilder tmp = new StringBuilder(ct);
        while (pos < ct.length()) {
            if (Fragment.isChar1(ct.charAt(pos)) && ct.charAt(pos) != '\ue106') {
                Tag tag = tags.get((CharSequence)ct, pos);
                if (tag.isMarker()) {
                    boolean isOpening;
                    boolean prevTrans = stack.peek().trans;
                    boolean bl = isOpening = tag.getTagType() == TagType.OPENING;
                    if (isOpening) {
                        Boolean trans = ((MTag)tag).getTranslate();
                        if (trans == null) {
                            stack.push(new TransInfo(tag.getId(), prevTrans));
                        } else {
                            stack.push(new TransInfo(tag.getId(), trans));
                        }
                    } else {
                        int j = 0;
                        while (j < stack.size()) {
                            if (((TransInfo)stack.get((int)j)).id.equals(tag.getId())) {
                                stack.remove(j);
                                break;
                            }
                            ++j;
                        }
                    }
                    if (prevTrans != stack.peek().trans) {
                        if (stack.peek().trans) {
                            if (!isOpening || start < pos) {
                                int last = pos + (isOpening ? 0 : 2);
                                PCont pm = new PCont(ct.substring(start, last));
                                int key = tags.add(pm);
                                tmp.delete(start + offset, last + offset);
                                tmp.insert(start + offset, Fragment.toRef(key));
                                offset -= last - start - 2;
                            }
                            start = pos;
                        } else {
                            start = isOpening ? pos : pos + 2;
                        }
                    }
                }
                ++pos;
            }
            ++pos;
        }
        if (!stack.peek().trans && start < pos) {
            PCont pm = new PCont(ct.substring(start, pos));
            int key = tags.add(pm);
            tmp.delete(start + offset, pos + offset);
            tmp.insert(start + offset, Fragment.toRef(key));
        }
        fragment.setCodedText(tmp.toString());
    }

    public List<Boolean> getTranslateStateEndings(boolean doSource) {
        ArrayList<Boolean> endings = new ArrayList<Boolean>();
        List<Part> list = doSource ? this.parts : this.getTargetOrderedParts();
        Stack<TransInfo> stack = new Stack<TransInfo>();
        stack.push(new TransInfo("", this.getTranslate()));
        for (Part part : list) {
            if (doSource) {
                this.computeTranslateStateEnding(part.getSource(), stack);
            } else {
                this.computeTranslateStateEnding(part.getTarget(Part.GetTarget.CLONE_SOURCE), stack);
            }
            endings.add(stack.peek().trans);
        }
        return endings;
    }

    private void computeTranslateStateEnding(Fragment fragment, Stack<TransInfo> stack) {
        int pos = 0;
        String ct = fragment.getCodedText();
        Tags tags = fragment.getTags();
        while (pos < ct.length()) {
            if (Fragment.isChar1(ct.charAt(pos)) && ct.charAt(pos) != '\ue106') {
                Tag tag = tags.get((CharSequence)ct, pos);
                if (tag.isMarker()) {
                    boolean isOpening;
                    boolean prevTrans = stack.peek().trans;
                    boolean bl = isOpening = tag.getTagType() == TagType.OPENING;
                    if (isOpening) {
                        Boolean trans = ((MTag)tag).getTranslate();
                        if (trans == null) {
                            stack.push(new TransInfo(tag.getId(), prevTrans));
                        } else {
                            stack.push(new TransInfo(tag.getId(), trans));
                        }
                    } else {
                        int j = 0;
                        while (j < stack.size()) {
                            if (((TransInfo)stack.get((int)j)).id.equals(tag.getId())) {
                                stack.remove(j);
                                break;
                            }
                            ++j;
                        }
                    }
                }
                ++pos;
            }
            ++pos;
        }
    }

    public void showProtectedContent() {
        for (Part part : this.parts) {
            part.showProtectedContent();
        }
        this.getStore().getSourceTags().resetPContLastValue();
        this.getStore().getSourceTags().resetPContLastValue();
    }

    public void verifyOpeningsBeforeClosings(boolean target) {
        List<Part> list = this.parts;
        HashMap<String, Boolean> openings = new HashMap<String, Boolean>();
        ArrayList<String> isolated = new ArrayList<String>();
        if (target) {
            list = this.getTargetOrderedParts();
        }
        int i = 0;
        while (i < list.size()) {
            block13: {
                Tags tags;
                String ct;
                block14: {
                    block12: {
                        if (!target) break block12;
                        if (!list.get(i).hasTarget()) break block13;
                        ct = list.get(i).getTarget().getCodedText();
                        tags = this.store.getTargetTags();
                        break block14;
                    }
                    ct = list.get(i).getSource().getCodedText();
                    tags = this.store.getSourceTags();
                }
                int j = 0;
                while (j < ct.length()) {
                    if (Fragment.isChar1(ct.charAt(j))) {
                        Tag m = tags.get((CharSequence)ct, j);
                        ++j;
                        if (m.getTagType() == TagType.OPENING) {
                            openings.put(m.getId(), true);
                        } else if (m.getTagType() == TagType.CLOSING) {
                            if (openings.containsKey(m.getId())) {
                                openings.remove(m.getId());
                            } else if (m.isCode()) {
                                isolated.add(m.getId());
                            } else {
                                throw new InvalidMarkerOrderException(String.format("Closing marker tag id='%s' is placed before its corresponding opening tag.", m.getId()));
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (String isoId : isolated) {
            if (!openings.containsKey(isoId)) continue;
            throw new InvalidMarkerOrderException(String.format("Closing code tag id='%s' is placed before its corresponding opening tag.", isoId));
        }
    }

    public void verifyReadOnlyTags() {
        Tags srcTags = this.getStore().getSourceTags();
        Tags trgTags = this.getStore().getTargetTags();
        for (Part part : this.parts) {
            if (!part.hasTarget()) continue;
            String ct = part.getSource().getCodedText();
            this.verifyContentForReadOnlyTags(ct, srcTags, trgTags);
        }
    }

    private void verifyContentForReadOnlyTags(String codedText, Tags srcTags, Tags trgTags) {
        int i = 0;
        while (i < codedText.length()) {
            char ch = codedText.charAt(i);
            switch (ch) {
                case '\ue106': {
                    PCont pcont = srcTags.getPCont(codedText, i);
                    ++i;
                    this.verifyContentForReadOnlyTags(pcont.getCodedText(), srcTags, trgTags);
                    break;
                }
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    CTag ctag = srcTags.getCTag(codedText, i);
                    ++i;
                    if (ctag.getCanDelete() || trgTags.get(ctag.getId(), ctag.getTagType()) != null) break;
                    throw new XLIFFException(String.format("Code id='%s' (%s) is non-removable but missing from the target content.", new Object[]{ctag.getId(), ctag.getTagType()}));
                }
                default: {
                    if (!Fragment.isChar1(ch)) break;
                    ++i;
                }
            }
            ++i;
        }
    }

    public Object getSourceOrTargetReference(String ref) {
        block6: {
            String refId;
            block5: {
                int pos = ref.lastIndexOf(35);
                if (pos == -1) {
                    throw new InvalidParameterException(String.format("The reference '%s' has no fragment id.", ref));
                }
                refId = ref.substring(pos + 1);
                if (!refId.startsWith("t=")) break block5;
                refId = refId.substring(2);
                if (!this.store.hasTargetTag()) break block6;
                for (Tag tag : this.store.getTargetTags()) {
                    if (!refId.equals(tag.getId())) continue;
                    return tag;
                }
                break block6;
            }
            for (Part part : this.parts) {
                if (!refId.equals(part.getId())) continue;
                return part;
            }
            if (this.store.hasSourceTag()) {
                for (Tag tag : this.store.getSourceTags()) {
                    if (!refId.equals(tag.getId())) continue;
                    return tag;
                }
            }
        }
        return null;
    }

    public List<CTag> getOrderedCTags(boolean target) {
        Tags tags;
        ArrayList<CTag> res = new ArrayList<CTag>();
        List<Part> list = this.parts;
        if (target) {
            list = this.getTargetOrderedParts();
            tags = this.getStore().getTargetTags();
        } else {
            tags = this.getStore().getSourceTags();
        }
        for (Part part : list) {
            String ct;
            if (target) {
                if (!part.hasTarget()) continue;
                ct = part.getTarget().getCodedText();
            } else {
                ct = part.getSource().getCodedText();
            }
            int i = 0;
            while (i < ct.length()) {
                if (Fragment.isChar1(ct.charAt(i))) {
                    if (Fragment.isCTag(ct.charAt(i))) {
                        res.add((CTag)tags.get((CharSequence)ct, i));
                    }
                    ++i;
                }
                ++i;
            }
        }
        return res;
    }

    public boolean doNonEmptySourcesHaveNonEmptyTargets() {
        for (Part part : this.parts) {
            if (part.getSource().isEmpty()) continue;
            if (!part.hasTarget()) {
                return false;
            }
            if (!part.getTarget().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void removeMarkers() {
        for (Part part : this.parts) {
            part.removeMarkers(false, null);
            part.removeMarkers(true, null);
        }
    }

    @Override
    public DataCategoryGroup<?> addITSGroup(DataCategoryGroup<?> group) {
        if (this.itsList == null) {
            this.itsList = new ArrayList();
        }
        this.itsList.add(group);
        return group;
    }

    @Override
    public boolean hasITSGroup() {
        if (this.itsList == null) {
            return false;
        }
        return !this.itsList.isEmpty();
    }

    @Override
    public List<DataCategoryGroup<?>> getITSGroups() {
        if (this.itsList == null) {
            this.itsList = new ArrayList();
        }
        return this.itsList;
    }

    @Override
    public boolean hasITSItem() {
        if (this.itsItems == null) {
            return false;
        }
        return !this.itsItems.isEmpty();
    }

    @Override
    public ITSItems getITSItems() {
        if (this.itsItems == null) {
            this.itsItems = new ITSItems();
        }
        return this.itsItems;
    }

    @Override
    public void setITSItems(ITSItems itsItems) {
        this.itsItems = itsItems;
    }

    public boolean hasMatch() {
        if (this.matches == null) {
            return false;
        }
        return !this.matches.isEmpty();
    }

    public Matches getMatches() {
        if (this.matches == null) {
            this.matches = new Matches();
        }
        return this.matches;
    }

    public void setMatches(Matches matches) {
        this.matches = matches;
    }

    public boolean hasGlossEntry() {
        if (this.glossary == null) {
            return false;
        }
        return !this.glossary.isEmpty();
    }

    public Glossary getGlossary() {
        if (this.glossary == null) {
            this.glossary = new Glossary();
        }
        return this.glossary;
    }

    public void setGlossary(Glossary glossary) {
        this.glossary = glossary;
    }

    public List<AnnotatedSpan> getAnnotatedSpans(boolean target) {
        ArrayList<AnnotatedSpan> list = new ArrayList<AnnotatedSpan>();
        ArrayList<AnnotatedSpan> trace = new ArrayList<AnnotatedSpan>();
        for (Part part : this.parts) {
            String ct;
            Tags tags;
            boolean contentBefore = false;
            if (target) {
                if (!part.hasTarget()) continue;
                tags = this.getStore().getTargetTags();
                ct = part.getTarget().getCodedText();
            } else {
                ct = part.getSource().getCodedText();
                tags = this.getStore().getSourceTags();
            }
            int i = 0;
            while (i < ct.length()) {
                char ch = ct.charAt(i);
                if (Fragment.isChar1(ch)) {
                    block0 : switch (ch) {
                        case '\ue104': {
                            MTag opening = (MTag)tags.get((CharSequence)ct, i);
                            AnnotatedSpan aspan = new AnnotatedSpan(opening, part, i + 2);
                            aspan.setFullContent(!contentBefore);
                            list.add(aspan);
                            trace.add(aspan);
                            break;
                        }
                        case '\ue105': {
                            MTag closing = (MTag)tags.get((CharSequence)ct, i);
                            for (AnnotatedSpan item : trace) {
                                if (!closing.getId().equals(item.getMarker().getId())) continue;
                                item.setEndPart(part);
                                item.append(ct.substring(item.getEnd(), i));
                                item.setEnd(i);
                                if (item.isFullContent() && Fragment.hasContentAfter(ct, i)) {
                                    item.setFullContent(false);
                                }
                                trace.remove(item);
                                break block0;
                            }
                            break;
                        }
                        case '\ue106': {
                            throw new XLIFFException("For now getAnnotatedSpans() expects a unit without hidden protected content.");
                        }
                        default: {
                            contentBefore = true;
                        }
                    }
                    ++i;
                } else {
                    contentBefore = true;
                }
                ++i;
            }
            for (AnnotatedSpan item : trace) {
                item.append(ct.substring(item.getEnd(), ct.length()));
                item.setEnd(0);
                item.setPartCount(item.getPartCount() + 1);
            }
        }
        return list;
    }

    public List<Match> getAllExactMatches() {
        double minSim = 100.0;
        return this.getFilteredListForMinimumSimilarity(minSim);
    }

    public List<Match> getMatchesByMinimumSimilarity(double minSim) {
        return this.getFilteredListForMinimumSimilarity(minSim);
    }

    public List<Match> getMatchesBySimilarityRange(double minSim, double maxSim) {
        return this.getFilteredListForSimilarityRange(minSim, maxSim);
    }

    public List<Match> getMatchesForSegment(int segIdx) {
        if (this.matches == null) {
            return Collections.emptyList();
        }
        ArrayList<Match> matchesForSegment = new ArrayList<Match>();
        HashSet<String> matchIds = new HashSet<String>();
        for (Tag tag : this.getSegment(segIdx).getSource().getOwnTags()) {
            if (!"mtc:match".equals(tag.getType())) continue;
            matchIds.add("#" + tag.getId());
        }
        for (Match match : this.matches) {
            if (!matchIds.contains(match.getRef())) continue;
            matchesForSegment.add(match);
        }
        return matchesForSegment;
    }

    public List<Match> getMatchesByRef(String ref) {
        if (this.matches == null) {
            return Collections.emptyList();
        }
        if (!ref.startsWith("#")) {
            ref = "#" + ref;
        }
        ArrayList<Match> filteredMatches = new ArrayList<Match>();
        for (Match match : this.matches) {
            if (!match.getRef().equals(ref)) continue;
            filteredMatches.add(match);
        }
        return filteredMatches;
    }

    private List<Match> getFilteredListForMinimumSimilarity(double minSim) {
        if (this.matches == null) {
            return Collections.emptyList();
        }
        ArrayList<Match> filteredMatches = new ArrayList<Match>();
        for (Match match : this.matches) {
            if (!(match.getSimilarity() >= minSim)) continue;
            filteredMatches.add(match);
        }
        return filteredMatches;
    }

    private List<Match> getFilteredListForSimilarityRange(double minSim, double maxSim) {
        if (this.matches == null) {
            return Collections.emptyList();
        }
        ArrayList<Match> filteredMatches = new ArrayList<Match>();
        for (Match match : this.matches) {
            if (!(match.getSimilarity() >= minSim) || !(match.getSimilarity() <= maxSim)) continue;
            filteredMatches.add(match);
        }
        return filteredMatches;
    }

    private class TransInfo {
        public String id;
        public boolean trans;

        public TransInfo(String id, boolean trans) {
            this.id = id;
            this.trans = trans;
        }
    }
}

