/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.FileFormat;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    Vector<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream inputStream) {
        if (inputStream == null) {
            SWT.error(4);
        }
        this.reset();
        this.data = FileFormat.load(inputStream, this);
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ImageData[] load(String string) {
        if (string == null) {
            SWT.error(4);
        }
        InputStream inputStream = null;
        inputStream = Compatibility.newFileInputStream(string);
        ImageData[] imageDataArray = this.load(inputStream);
        Object var5_5 = null;
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imageDataArray;
        catch (IOException iOException) {
            try {
                SWT.error(39, iOException);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException3) {}
        }
        return null;
    }

    public void save(OutputStream outputStream, int n) {
        if (outputStream == null) {
            SWT.error(4);
        }
        FileFormat.save(outputStream, n, this);
    }

    public void save(String string, int n) {
        if (string == null) {
            SWT.error(4);
        }
        OutputStream outputStream = null;
        try {
            outputStream = Compatibility.newFileOutputStream(string);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.save(outputStream, n);
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addImageLoaderListener(ImageLoaderListener imageLoaderListener) {
        if (imageLoaderListener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new Vector();
        }
        this.imageLoaderListeners.add(imageLoaderListener);
    }

    public void removeImageLoaderListener(ImageLoaderListener imageLoaderListener) {
        if (imageLoaderListener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.remove(imageLoaderListener);
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent imageLoaderEvent) {
        if (!this.hasListeners()) {
            return;
        }
        int n = this.imageLoaderListeners.size();
        for (int i = 0; i < n; ++i) {
            ImageLoaderListener imageLoaderListener = this.imageLoaderListeners.get(i);
            imageLoaderListener.imageDataLoaded(imageLoaderEvent);
        }
    }
}

