/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Group
extends Composite {
    String text = "";
    static final int CLIENT_INSET = 3;
    static final long GroupProc;
    static final TCHAR GroupClass;

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        switch (n) {
            case 513: 
            case 515: {
                return OS.DefWindowProc(l, n, l2, l3);
            }
        }
        return OS.CallWindowProc(GroupProc, l, n, l2, l3);
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        int n3 = this.text.length();
        if (n3 != 0) {
            String string = this.fixText(false);
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string == null ? this.text : string, true);
            long l = 0L;
            long l2 = OS.GetDC(this.handle);
            long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l = OS.SelectObject(l2, l3);
            }
            RECT rECT = new RECT();
            int n4 = 1056;
            OS.DrawText(l2, tCHAR, -1, rECT, n4);
            if (l3 != 0L) {
                OS.SelectObject(l2, l);
            }
            OS.ReleaseDC(this.handle, l2);
            int n5 = OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() ? 0 : 1;
            point.x = Math.max(point.x, rECT.right - rECT.left + 18 + n5);
        }
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(l2, tEXTMETRIC);
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        int n5 = OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() ? 0 : 1;
        rectangle.x -= 3;
        rectangle.y -= tEXTMETRIC.tmHeight + n5;
        rectangle.width += 6;
        rectangle.height += tEXTMETRIC.tmHeight + 3 + n5;
        return rectangle;
    }

    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        this.state |= 0x200;
        this.state &= 0xFFFFFFFD;
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        String string = this.fixText(bl);
        if (string != null) {
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
        }
    }

    String fixText(boolean bl) {
        if (this.text.length() == 0) {
            return null;
        }
        if ((this.style & 0x4000000) != 0) {
            String string = null;
            if (!(bl || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
                string = " " + this.text + " ";
            }
            return !OS.IsUnicode || (this.style & Integer.MIN_VALUE) == 0 ? string : (string != null ? '\u202a' + string : '\u202a' + this.text);
        }
        if (OS.IsUnicode && (this.style & Integer.MIN_VALUE) != 0) {
            return '\u202b' + this.text;
        }
        return null;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(l2, tEXTMETRIC);
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        int n = OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() ? 0 : 1;
        int n2 = 3;
        int n3 = tEXTMETRIC.tmHeight + n;
        int n4 = Math.max(0, rECT.right - 6);
        int n5 = Math.max(0, rECT.bottom - n3 - 3);
        return new Rectangle(n2, n3, n4, n5);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char c) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void printWidget(long l, long l2, GC gC) {
        int n;
        boolean bl = false;
        if (OS.GetDeviceCaps(gC.handle, 2) != 2) {
            n = OS.GetWindowLong(l, -16);
            if ((n & 0x10000000) == 0) {
                OS.ShowWindow(l, 5);
            }
            bl = OS.PrintWindow(l, l2, 0);
            if ((n & 0x10000000) == 0) {
                OS.ShowWindow(l, 0);
            }
        }
        if (!bl) {
            n = 14;
            OS.SendMessage(l, 791, l2, (long)n);
            int n2 = OS.SaveDC(l2);
            Control[] controlArray = this._getChildren();
            Rectangle rectangle = this.getBounds();
            OS.IntersectClipRect(l2, 0, 0, rectangle.width, rectangle.height);
            for (int i = controlArray.length - 1; i >= 0; --i) {
                Point point = controlArray[i].getLocation();
                int n3 = OS.GetGraphicsMode(l2);
                if (n3 == 2) {
                    float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f, point.x, point.y};
                    OS.ModifyWorldTransform(l2, fArray, 2);
                } else {
                    OS.SetWindowOrgEx(l2, -point.x, -point.y, null);
                }
                long l3 = controlArray[i].topHandle();
                int n4 = OS.GetWindowLong(l3, -16);
                if ((n4 & 0x10000000) != 0) {
                    controlArray[i].printWidget(l3, l2, gC);
                }
                if (n3 != 2) continue;
                float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f, -point.x, -point.y};
                OS.ModifyWorldTransform(l2, fArray, 2);
            }
            OS.RestoreDC(l2, n2);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
    }

    int resolveTextDirection() {
        return Group.resolveTextDirection(this.text);
    }

    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.state & 0x400000) == 0 || !this.updateTextDirection(0x6000000)) {
            string = this.fixText(OS.IsWindowEnabled(this.handle));
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string == null ? this.text : string, true);
            OS.SetWindowText(this.handle, tCHAR);
        }
    }

    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n)) {
            String string = this.fixText(OS.IsWindowEnabled(this.handle));
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string == null ? this.text : string, true);
            OS.SetWindowText(this.handle, tCHAR);
            return true;
        }
        return false;
    }

    int widgetStyle() {
        return super.widgetStyle() | 7 | 0x2000000 | 0x4000000;
    }

    TCHAR windowClass() {
        return GroupClass;
    }

    long windowProc() {
        return GroupProc;
    }

    LRESULT WM_ERASEBKGND(long l, long l2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.drawBackground(l);
        return LRESULT.ONE;
    }

    LRESULT WM_NCHITTEST(long l, long l2) {
        LRESULT lRESULT = super.WM_NCHITTEST(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = this.callWindowProc(this.handle, 132, l, l2);
        if (l3 == -1L) {
            l3 = 1L;
        }
        return new LRESULT(l3);
    }

    LRESULT WM_MOUSEMOVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(long l, long l2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n = OS.SaveDC(l);
            long l3 = this.callWindowProc(this.handle, 792, l, l2);
            OS.RestoreDC(l, n);
            return new LRESULT(l3);
        }
        return lRESULT;
    }

    LRESULT WM_UPDATEUISTATE(long l, long l2) {
        boolean bl;
        LRESULT lRESULT = super.WM_UPDATEUISTATE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = this.findImageControl() != null;
        if (!bl) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                boolean bl3 = bl = this.findThemeControl() != null;
            }
            if (!bl) {
                boolean bl4 = bl = this.findBackgroundControl() != null;
            }
        }
        if (bl) {
            OS.InvalidateRect(this.handle, null, false);
            long l3 = OS.DefWindowProc(this.handle, 296, l, l2);
            return new LRESULT(l3);
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, l2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0L, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        if (n2 == n4 && n3 == n5) {
            return lRESULT;
        }
        if (n2 != n4) {
            n = n4;
            if (n2 < n4) {
                n = n2;
            }
            OS.SetRect(rECT, n - 3, 0, n2, n3);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n3 != n5) {
            n = n5;
            if (n3 < n5) {
                n = n3;
            }
            if (n2 < n4) {
                n4 -= 3;
            }
            OS.SetRect(rECT, 0, n - 3, n4, n3);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }

    static {
        GroupClass = new TCHAR(0, OS.IsWinCE ? "BUTTON" : "SWT_GROUP", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        if (OS.IsWinCE) {
            OS.GetClassInfo(0L, GroupClass, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
        } else {
            TCHAR tCHAR = new TCHAR(0, "BUTTON", true);
            OS.GetClassInfo(0L, tCHAR, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
            long l = OS.GetModuleHandle(null);
            if (!OS.GetClassInfo(l, GroupClass, wNDCLASS)) {
                long l2 = OS.GetProcessHeap();
                wNDCLASS.hInstance = l;
                wNDCLASS.style &= 0xFFFFFFFC;
                int n = GroupClass.length() * TCHAR.sizeof;
                long l3 = OS.HeapAlloc(l2, 8, n);
                OS.MoveMemory(l3, GroupClass, n);
                wNDCLASS.lpszClassName = l3;
                OS.RegisterClass(wNDCLASS);
                OS.HeapFree(l2, 0, l3);
            }
        }
    }
}

