/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.exceptions.OkapiException;

public abstract class BaseParameters
implements IParameters {
    protected String path = null;

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String filePath) {
        this.path = filePath;
    }

    @Override
    public void load(URL inputURL, boolean ignoreErrors) {
        block2: {
            try {
                this.load(inputURL.openStream(), ignoreErrors);
                this.path = inputURL.toURI().getPath();
            }
            catch (IOException | URISyntaxException e) {
                if (ignoreErrors) break block2;
                throw new OkapiException(e);
            }
        }
    }

    @Override
    public void load(InputStream inStream, boolean ignoreErrors) {
        block15: {
            try (InputStreamReader SR = new InputStreamReader((InputStream)new BufferedInputStream(inStream), "UTF-8");){
                int nCount;
                this.reset();
                StringBuilder sbTmp = new StringBuilder(1024);
                char[] aBuf = new char[1024];
                while ((nCount = SR.read(aBuf)) > -1) {
                    sbTmp.append(aBuf, 0, nCount);
                }
                String tmp = sbTmp.toString().replace("\r\n", "\n");
                this.fromString(tmp.replace("\r", "\n"));
                this.path = "";
            }
            catch (IOException e) {
                if (ignoreErrors) break block15;
                throw new OkapiException(e);
            }
        }
    }

    @Override
    public void save(String newPath) {
        try (OutputStreamWriter SW = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(newPath)), "UTF-8");){
            SW.write(this.toString());
            this.path = newPath;
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        return null;
    }
}

