/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.connectors.microsoft.DataMarketTokenParser;
import net.sf.okapi.connectors.microsoft.Parameters;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int TOKENRETRIES = 3;
    private int SLEEPPAUSE_MS = 300;
    private static final String TOKEN_URL = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13";
    private HttpClient httpClient;
    private Parameters params;
    private DataMarketTokenParser.Token token = DataMarketTokenParser.expiredToken();

    public TokenProvider(HttpClient httpClient, Parameters params) {
        this.httpClient = httpClient;
        this.params = params;
    }

    public String get() {
        if (this.token.isExpired() || this.isExpiring()) {
            for (int tries = 0; tries < 3; ++tries) {
                if (this.getAccesstoken()) {
                    return this.token.token;
                }
                if (tries >= 2) continue;
                this.sleep(this.SLEEPPAUSE_MS);
            }
            throw new OkapiException(String.format("Failed to get Microsoft Translator access token after %d tries.", 3));
        }
        return this.token.token;
    }

    private boolean isExpiring() {
        long now = System.currentTimeMillis();
        if (now > this.token.expiresOn - 500L) {
            this.sleep(this.token.expiresOn - now);
            return true;
        }
        return false;
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new OkapiException("Sleep interrupted while attempting to get Azure Marketplace Token" + e.getMessage(), e);
        }
    }

    private boolean getAccesstoken() {
        try {
            String tokenRes = this.getRawToken();
            if (tokenRes != null) {
                this.token = new DataMarketTokenParser().parse(tokenRes);
                return true;
            }
        }
        catch (OkapiException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Error in getAccestoken: {}", (Object)e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRawToken() {
        HttpResponse response = null;
        try {
            HttpPost post = new HttpPost(TOKEN_URL);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(4);
            nameValuePairs.add(new BasicNameValuePair("grant_type", "client_credentials"));
            nameValuePairs.add(new BasicNameValuePair("client_id", this.params.getClientId()));
            nameValuePairs.add(new BasicNameValuePair("client_secret", this.params.getSecret()));
            nameValuePairs.add(new BasicNameValuePair("scope", "http://api.microsofttranslator.com"));
            UrlEncodedFormEntity uefe = new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs);
            post.setEntity(uefe);
            response = this.httpClient.execute(post);
            if (response != null) {
                String string = StreamUtil.streamUtf8AsString(response.getEntity().getContent());
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to fetch token", e);
        }
        finally {
            if (response != null) {
                try {
                    response.getEntity().getContent().close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

