/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup;

import java.util.EmptyStackException;
import java.util.ListIterator;
import java.util.Stack;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;

public class ExtractionRuleState {
    private boolean excludeByDefault;
    private Stack<RuleType> preserveWhiteSpaceRuleStack;
    private Stack<RuleType> excludedIncludedRuleStack;
    private Stack<RuleType> groupRuleStack;
    private Stack<RuleType> textUnitRuleStack;
    private Stack<RuleType> inlineRuleStack;

    public ExtractionRuleState(boolean preserveWhitespace, boolean excludeByDefault) {
        this.reset(preserveWhitespace, excludeByDefault);
    }

    public void reset(boolean preserveWhitespace, boolean excludeByDefault) {
        this.excludeByDefault = excludeByDefault;
        this.preserveWhiteSpaceRuleStack = new Stack();
        this.pushPreserverWhitespaceRule(preserveWhitespace);
        this.excludedIncludedRuleStack = new Stack();
        this.groupRuleStack = new Stack();
        this.textUnitRuleStack = new Stack();
        this.inlineRuleStack = new Stack();
    }

    public boolean isExludedState() {
        if (this.excludedIncludedRuleStack.isEmpty()) {
            return this.excludeByDefault;
        }
        ListIterator ri = this.excludedIncludedRuleStack.listIterator(this.excludedIncludedRuleStack.size());
        while (ri.hasPrevious()) {
            RuleType rt = (RuleType)ri.previous();
            if (rt.ruleType == TaggedFilterConfiguration.RULE_TYPE.EXCLUDED_ELEMENT) {
                return true;
            }
            if (rt.ruleType != TaggedFilterConfiguration.RULE_TYPE.INCLUDED_ELEMENT) continue;
            return false;
        }
        return this.excludeByDefault;
    }

    public boolean isInlineExcludedState() {
        if (this.inlineRuleStack.isEmpty()) {
            return false;
        }
        ListIterator ri = this.inlineRuleStack.listIterator(this.inlineRuleStack.size());
        while (ri.hasPrevious()) {
            RuleType rt = (RuleType)ri.previous();
            if (rt.ruleType != TaggedFilterConfiguration.RULE_TYPE.INLINE_EXCLUDED_ELEMENT) continue;
            return true;
        }
        return false;
    }

    public boolean isPreserveWhitespaceState() {
        if (this.preserveWhiteSpaceRuleStack.isEmpty()) {
            return false;
        }
        return this.preserveWhiteSpaceRuleStack.peek().ruleApplies;
    }

    public void pushPreserverWhitespaceRule(boolean ruleApplies) {
        this.preserveWhiteSpaceRuleStack.push(new RuleType("", TaggedFilterConfiguration.RULE_TYPE.PRESERVE_WHITESPACE, ruleApplies));
    }

    public void pushPreserverWhitespaceRule(String ruleName, boolean ruleApplies) {
        this.preserveWhiteSpaceRuleStack.push(new RuleType(ruleName, TaggedFilterConfiguration.RULE_TYPE.PRESERVE_WHITESPACE, ruleApplies));
    }

    public void pushExcludedRule(String ruleName) {
        this.excludedIncludedRuleStack.push(new RuleType(ruleName, TaggedFilterConfiguration.RULE_TYPE.EXCLUDED_ELEMENT, null));
    }

    public void pushExcludedRule(String ruleName, TaggedFilterConfiguration.RULE_TYPE rule) {
        this.excludedIncludedRuleStack.push(new RuleType(ruleName, rule, null));
    }

    public void pushIncludedRule(String ruleName) {
        this.excludedIncludedRuleStack.push(new RuleType(ruleName, TaggedFilterConfiguration.RULE_TYPE.INCLUDED_ELEMENT, null));
    }

    public void pushIncludedRule(String ruleName, TaggedFilterConfiguration.RULE_TYPE rule) {
        this.excludedIncludedRuleStack.push(new RuleType(ruleName, rule, null));
    }

    public void pushGroupRule(String ruleName) {
        this.groupRuleStack.push(new RuleType(ruleName, TaggedFilterConfiguration.RULE_TYPE.GROUP_ELEMENT, null));
    }

    public void pushGroupRule(String ruleName, TaggedFilterConfiguration.RULE_TYPE rule) {
        this.groupRuleStack.push(new RuleType(ruleName, rule, null));
    }

    public void pushInlineRule(String ruleName) {
        this.inlineRuleStack.push(new RuleType(ruleName, TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT, null));
    }

    public void pushInlineRule(String ruleName, TaggedFilterConfiguration.RULE_TYPE rule) {
        this.inlineRuleStack.push(new RuleType(ruleName, rule, null));
    }

    public void pushTextUnitRule(String ruleName) {
        this.textUnitRuleStack.push(new RuleType(ruleName, TaggedFilterConfiguration.RULE_TYPE.TEXT_UNIT_ELEMENT, null));
    }

    public void pushTextUnitRule(String ruleName, TaggedFilterConfiguration.RULE_TYPE rule, String idValue) {
        this.textUnitRuleStack.push(new RuleType(ruleName, rule, idValue));
    }

    public RuleType popPreserverWhitespaceRule() {
        return this.preserveWhiteSpaceRuleStack.pop();
    }

    public RuleType popExcludedIncludedRule() {
        return this.excludedIncludedRuleStack.pop();
    }

    public RuleType popGroupRule() {
        return this.groupRuleStack.pop();
    }

    public RuleType popTextUnitRule() {
        return this.textUnitRuleStack.pop();
    }

    public RuleType popInlineRule() {
        return this.inlineRuleStack.pop();
    }

    public RuleType peekPreserverWhitespaceRule() {
        return this.preserveWhiteSpaceRuleStack.peek();
    }

    public RuleType peekExcludedIncludedRule() {
        return this.excludedIncludedRuleStack.peek();
    }

    public RuleType peekGroupRule() {
        return this.groupRuleStack.peek();
    }

    public RuleType peekTextUnitRule() {
        return this.textUnitRuleStack.peek();
    }

    public RuleType peekInlineRule() {
        return this.inlineRuleStack.peek();
    }

    public void clearTextUnitRules() {
        this.textUnitRuleStack.clear();
    }

    public void clearInlineRules() {
        this.inlineRuleStack.clear();
    }

    public String getTextUnitElementName() {
        String n = "";
        try {
            n = this.textUnitRuleStack.peek().ruleName;
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return n;
    }

    public final class RuleType {
        public String ruleName;
        public TaggedFilterConfiguration.RULE_TYPE ruleType;
        public String idValue;
        public boolean ruleApplies;

        public RuleType(String ruleName, TaggedFilterConfiguration.RULE_TYPE ruleType, String idValue) {
            this.ruleName = ruleName;
            this.ruleType = ruleType;
            this.idValue = idValue;
            this.ruleApplies = true;
        }

        public RuleType(String ruleName, TaggedFilterConfiguration.RULE_TYPE ruleType, boolean ruleApplies) {
            this.ruleName = ruleName;
            this.ruleType = ruleType;
            this.idValue = null;
            this.ruleApplies = ruleApplies;
        }
    }
}

