/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.filters.openxml.ParseType;

public class ConditionalParameters
extends StringParameters {
    private static final String TRANSLATEDOCPROPERTIES = "bPreferenceTranslateDocProperties";
    private static final String TRANSLATECOMMENTS = "bPreferenceTranslateComments";
    private static final String AGGRESSIVECLEANUP = "bPreferenceAggressiveCleanup";
    private static final String AUTOMATICALLY_ACCEPT_REVISIONS = "bPreferenceAutomaticallyAcceptRevisions";
    private static final String TRANSLATEPOWERPOINTNOTES = "bPreferenceTranslatePowerpointNotes";
    private static final String TRANSLATEPOWERPOINTMASTERS = "bPreferenceTranslatePowerpointMasters";
    private static final String TRANSLATEWORDHEADERSFOOTERS = "bPreferenceTranslateWordHeadersFooters";
    private static final String TRANSLATEWORDHIDDEN = "bPreferenceTranslateWordHidden";
    private static final String TRANSLATEEXCELEXCLUDECOLORS = "bPreferenceTranslateExcelExcludeColors";
    private static final String TRANSLATEEXELEXCLUDECOLUMNS = "bPreferenceTranslateExcelExcludeColumns";
    private static final String TRANSLATEEXELSHEETNAMES = "bPreferenceTranslateExcelSheetNames";
    private static final String TRANSLATEWORDEXCLUDEGRAPHICMETADATA = "bPreferenceTranslateWordExcludeGraphicMetaData";
    private static final String TRANSLATEEXCELHIDDEN = "bPreferenceTranslateExcelHidden";
    private static final String EXTRACT_EXTERNAL_HYPERLINKS = "bExtractExternalHyperlinks";
    private static final String ADDTABASCHARACTER = "bPreferenceAddTabAsCharacter";
    private static final String ADDLINESEPARATORASCHARACTER = "bPreferenceAddLineSeparatorAsCharacter";
    private static final String LINESEPARATORREPLACEMENT = "sPreferenceLineSeparatorReplacement";
    private static final String REPLACE_NO_BREAK_HYPHEN_TAG = "bPreferenceReplaceNoBreakHyphenTag";
    private static final String IGNORE_SOFT_HYPHEN_TAG = "bPreferenceIgnoreSoftHyphenTag";
    public static final int MSWORD = 1;
    public TreeSet<String> tsComplexFieldDefinitionsToExtract;
    public TreeSet<String> tsExcelExcludedColors;
    public TreeSet<String> tsExcelExcludedColumns;
    public TreeSet<String> tsExcludeWordStyles;
    public ParseType nFileType = ParseType.MSWORD;

    public boolean getTranslateDocProperties() {
        return this.getBoolean(TRANSLATEDOCPROPERTIES);
    }

    public void setTranslateDocProperties(boolean translateDocProperties) {
        this.setBoolean(TRANSLATEDOCPROPERTIES, translateDocProperties);
    }

    public boolean getTranslateComments() {
        return this.getBoolean(TRANSLATECOMMENTS);
    }

    public void setTranslateComments(boolean translateComments) {
        this.setBoolean(TRANSLATECOMMENTS, translateComments);
    }

    public boolean getCleanupAggressively() {
        return this.getBoolean(AGGRESSIVECLEANUP);
    }

    public void setCleanupAggressively(boolean aggressiveCleanup) {
        this.setBoolean(AGGRESSIVECLEANUP, aggressiveCleanup);
    }

    public boolean getAutomaticallyAcceptRevisions() {
        return this.getBoolean(AUTOMATICALLY_ACCEPT_REVISIONS);
    }

    public void setAutomaticallyAcceptRevisions(boolean automaticallyAcceptRevisions) {
        this.setBoolean(AUTOMATICALLY_ACCEPT_REVISIONS, automaticallyAcceptRevisions);
    }

    public boolean getTranslatePowerpointNotes() {
        return this.getBoolean(TRANSLATEPOWERPOINTNOTES);
    }

    public void setTranslatePowerpointNotes(boolean translatePowerpointNotes) {
        this.setBoolean(TRANSLATEPOWERPOINTNOTES, translatePowerpointNotes);
    }

    public boolean getTranslatePowerpointMasters() {
        return this.getBoolean(TRANSLATEPOWERPOINTMASTERS);
    }

    public void setTranslatePowerpointMasters(boolean translatePowerpointMasters) {
        this.setBoolean(TRANSLATEPOWERPOINTMASTERS, translatePowerpointMasters);
    }

    public boolean getTranslateWordHeadersFooters() {
        return this.getBoolean(TRANSLATEWORDHEADERSFOOTERS);
    }

    public void setTranslateWordHeadersFooters(boolean translateWordHeadersFooters) {
        this.setBoolean(TRANSLATEWORDHEADERSFOOTERS, translateWordHeadersFooters);
    }

    public boolean getTranslateWordHidden() {
        return this.getBoolean(TRANSLATEWORDHIDDEN);
    }

    public void setTranslateWordHidden(boolean translateWordHidden) {
        this.setBoolean(TRANSLATEWORDHIDDEN, translateWordHidden);
    }

    public boolean getTranslateExcelHidden() {
        return this.getBoolean(TRANSLATEEXCELHIDDEN);
    }

    public void setTranslateExcelHidden(boolean translateExcelHidden) {
        this.setBoolean(TRANSLATEEXCELHIDDEN, translateExcelHidden);
    }

    public boolean getTranslateExcelExcludeColors() {
        return this.getBoolean(TRANSLATEEXCELEXCLUDECOLORS);
    }

    public void setTranslateExcelExcludeColors(boolean translateExcelExcludeColors) {
        this.setBoolean(TRANSLATEEXCELEXCLUDECOLORS, translateExcelExcludeColors);
    }

    public boolean getTranslateExcelExcludeColumns() {
        return this.getBoolean(TRANSLATEEXELEXCLUDECOLUMNS);
    }

    public void setTranslateExcelExcludeColumns(boolean translateExcelExcludeColumns) {
        this.setBoolean(TRANSLATEEXELEXCLUDECOLUMNS, translateExcelExcludeColumns);
    }

    public boolean getTranslateExcelSheetNames() {
        return this.getBoolean(TRANSLATEEXELSHEETNAMES);
    }

    public void setTranslateExcelSheetNames(boolean translateExcelSheetNames) {
        this.setBoolean(TRANSLATEEXELSHEETNAMES, translateExcelSheetNames);
    }

    public boolean getTranslateWordExcludeGraphicMetaData() {
        return this.getBoolean(TRANSLATEWORDEXCLUDEGRAPHICMETADATA);
    }

    public void setTranslateWordExcludeGraphicMetaData(boolean excludeGraphicMetaData) {
        this.setBoolean(TRANSLATEWORDEXCLUDEGRAPHICMETADATA, excludeGraphicMetaData);
    }

    public boolean getAddTabAsCharacter() {
        return this.getBoolean(ADDTABASCHARACTER);
    }

    public void setAddTabAsCharacter(boolean bAddTabAsCharacter) {
        this.setBoolean(ADDTABASCHARACTER, bAddTabAsCharacter);
    }

    public boolean getAddLineSeparatorCharacter() {
        return this.getBoolean(ADDLINESEPARATORASCHARACTER);
    }

    public void setAddLineSeparatorCharacter(boolean bAddLineSeparatorAsCharacter) {
        this.setBoolean(ADDLINESEPARATORASCHARACTER, bAddLineSeparatorAsCharacter);
    }

    public char getLineSeparatorReplacement() {
        return this.getString(LINESEPARATORREPLACEMENT).charAt(0);
    }

    public void setLineSeparatorReplacement(char lineSeparatorReplacement) {
        this.setString(LINESEPARATORREPLACEMENT, String.valueOf(lineSeparatorReplacement));
    }

    public boolean getReplaceNoBreakHyphenTag() {
        return this.getBoolean(REPLACE_NO_BREAK_HYPHEN_TAG);
    }

    public void setReplaceNoBreakHyphenTag(boolean bReplaceNoBreakHyphenTag) {
        this.setBoolean(REPLACE_NO_BREAK_HYPHEN_TAG, bReplaceNoBreakHyphenTag);
    }

    public boolean getIgnoreSoftHyphenTag() {
        return this.getBoolean(IGNORE_SOFT_HYPHEN_TAG);
    }

    public void setIgnoreSoftHyphenTag(boolean bIgnoreSoftHyphenTag) {
        this.setBoolean(IGNORE_SOFT_HYPHEN_TAG, bIgnoreSoftHyphenTag);
    }

    public void setExtractExternalHyperlinks(boolean bExtractExternalHyperlinks) {
        this.setBoolean(EXTRACT_EXTERNAL_HYPERLINKS, bExtractExternalHyperlinks);
    }

    public boolean getExtractExternalHyperlinks() {
        return this.getBoolean(EXTRACT_EXTERNAL_HYPERLINKS);
    }

    @Override
    public void reset() {
        super.reset();
        this.setTranslateDocProperties(true);
        this.setTranslateComments(true);
        this.setTranslatePowerpointNotes(true);
        this.setTranslatePowerpointMasters(true);
        this.setTranslateWordHeadersFooters(true);
        this.setTranslateWordHidden(false);
        this.setTranslateWordExcludeGraphicMetaData(false);
        this.setTranslateExcelExcludeColors(false);
        this.setTranslateExcelExcludeColumns(false);
        this.setTranslateExcelSheetNames(false);
        this.setAddLineSeparatorCharacter(false);
        this.setLineSeparatorReplacement('\n');
        this.setReplaceNoBreakHyphenTag(false);
        this.setIgnoreSoftHyphenTag(false);
        this.setAddTabAsCharacter(false);
        this.setCleanupAggressively(false);
        this.setAutomaticallyAcceptRevisions(true);
        this.tsComplexFieldDefinitionsToExtract = new TreeSet();
        this.tsComplexFieldDefinitionsToExtract.add("HYPERLINK");
        this.tsExcelExcludedColors = new TreeSet();
        this.tsExcelExcludedColumns = new TreeSet();
        this.tsExcludeWordStyles = new TreeSet();
    }

    @Override
    public void fromString(String data) {
        String sNummer;
        int i;
        super.fromString(data);
        int siz = this.buffer.getInteger("tsComplexFieldDefinitionsToExtract");
        if (siz > 0) {
            this.tsComplexFieldDefinitionsToExtract = new TreeSet();
            for (i = 0; i < siz; ++i) {
                sNummer = "cfd" + new Integer(i).toString();
                this.tsComplexFieldDefinitionsToExtract.add(this.buffer.getString(sNummer, ""));
            }
        }
        this.tsExcelExcludedColors = new TreeSet();
        siz = this.buffer.getInteger("tsExcelExcludedColors");
        for (i = 0; i < siz; ++i) {
            sNummer = "ccc" + new Integer(i).toString();
            this.tsExcelExcludedColors.add(this.buffer.getString(sNummer, "F1F2F3F4"));
        }
        this.tsExcelExcludedColumns = new TreeSet();
        siz = this.buffer.getInteger("tsExcelExcludedColumns");
        for (i = 0; i < siz; ++i) {
            this.tsExcelExcludedColumns.add(this.buffer.getString("zzz" + new Integer(i).toString(), "A1000"));
        }
        this.tsExcludeWordStyles = new TreeSet();
        siz = this.buffer.getInteger("tsExcludeWordStyles");
        for (i = 0; i < siz; ++i) {
            this.tsExcludeWordStyles.add(this.buffer.getString("sss" + new Integer(i).toString(), "zzzzz"));
        }
    }

    @Override
    public String toString() {
        int i;
        int siz = this.tsComplexFieldDefinitionsToExtract == null ? 0 : this.tsComplexFieldDefinitionsToExtract.size();
        this.buffer.setInteger("tsComplexFieldDefinitionsToExtract", siz);
        Iterator<String> it = this.tsComplexFieldDefinitionsToExtract.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("cfd" + new Integer(i).toString(), it.next());
        }
        siz = this.tsExcelExcludedColors == null ? 0 : this.tsExcelExcludedColors.size();
        this.buffer.setInteger("tsExcelExcludedColors", siz);
        it = this.tsExcelExcludedColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("ccc" + new Integer(i).toString(), it.next());
        }
        siz = this.tsExcelExcludedColumns == null ? 0 : this.tsExcelExcludedColumns.size();
        this.buffer.setInteger("tsExcelExcludedColumns", siz);
        it = this.tsExcelExcludedColumns.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("zzz" + new Integer(i).toString(), it.next());
        }
        siz = this.tsExcludeWordStyles == null ? 0 : this.tsExcludeWordStyles.size();
        this.buffer.setInteger("tsExcludeWordStyles", siz);
        it = this.tsExcludeWordStyles.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("sss" + new Integer(i).toString(), it.next());
        }
        return this.buffer.toString();
    }

    @Override
    public void save(String newPath) {
        Writer SW = null;
        try {
            SW = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(newPath)), "UTF-8");
            SW.write(this.toString());
            this.path = newPath;
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
        finally {
            if (SW != null) {
                try {
                    SW.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URI inputURI, boolean p_bIgnoreErrors) {
        try {
            int nCount;
            this.reset();
            URL url = inputURI.toURL();
            InputStreamReader SR = new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), "UTF-8");
            StringBuilder sbTmp = new StringBuilder(1024);
            char[] aBuf = new char[1024];
            while ((nCount = SR.read(aBuf)) > -1) {
                sbTmp.append(aBuf, 0, nCount);
            }
            ((Reader)SR).close();
            SR = null;
            String tmp = sbTmp.toString().replace("\r\n", "\n");
            this.fromString(tmp.replace("\r", "\n"));
            this.path = inputURI.getPath();
        }
        catch (IOException e) {
            if (!p_bIgnoreErrors) {
                throw new OkapiException(e);
            }
        }
        finally {
            Object aBuf = null;
        }
    }

    public ConditionalParameters clone() {
        ConditionalParameters cpnew = new ConditionalParameters();
        cpnew.fromString(this.toString());
        cpnew.nFileType = this.nFileType;
        return cpnew;
    }

    public Set<String> findExcludedColumnsForSheetNumber(int sheetNumber) {
        if (!this.getTranslateExcelExcludeColumns()) {
            return Collections.emptySet();
        }
        HashSet<String> excludes = new HashSet<String>();
        if (sheetNumber > 3) {
            sheetNumber = 3;
        }
        String prefix = String.valueOf(sheetNumber);
        for (String origExclude : this.tsExcelExcludedColumns) {
            if (!origExclude.startsWith(prefix)) continue;
            excludes.add(origExclude.substring(prefix.length()));
        }
        return excludes;
    }
}

