/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.openxml.ParseType;

public class OpenXMLContentSkeletonWriter
extends GenericSkeletonWriter {
    private static final char TAB = '\t';
    private static final char LINE_SEPARATOR = '\u2028';
    private ParseType configurationType;
    private EncoderManager internalEncoderManager;
    private boolean bInBlankText = false;

    public OpenXMLContentSkeletonWriter(ParseType configurationType) {
        this.configurationType = configurationType;
        this.internalEncoderManager = new EncoderManager();
        this.internalEncoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.internalEncoderManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.internalEncoderManager.setDefaultOptions(null, "utf-8", "\n");
        this.internalEncoderManager.updateEncoder("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    private String getRunPrefix() {
        return this.configurationType == ParseType.MSWORD ? "w:" : "a:";
    }

    private String serializeText(String text, boolean needsPreserveSpace) {
        StringBuilder sb = new StringBuilder();
        String sPreserve = "";
        if (this.configurationType != ParseType.MSWORD && this.configurationType != ParseType.MSPOWERPOINT) {
            return text;
        }
        String prefix = this.getRunPrefix();
        if (needsPreserveSpace) {
            sPreserve = " xml:space=\"preserve\"";
        }
        sb.append("<").append(prefix).append("r><").append(prefix).append("t").append(sPreserve).append(">");
        for (char c : text.toCharArray()) {
            if (c == '\n') {
                sb.append("</").append(prefix).append("t>");
                sb.append("<").append(prefix).append("br/>");
                sb.append("<").append(prefix).append("t").append(sPreserve).append(">");
                continue;
            }
            sb.append(c);
        }
        sb.append("</").append(prefix).append("t></").append(prefix).append("r>");
        return sb.toString();
    }

    @Override
    public String getContent(TextFragment tf, LocaleId langToUse, EncoderContext context) {
        String text = tf.getCodedText();
        this.bInBlankText = false;
        boolean bHasBlankInText = false;
        int nSurroundingCodes = 0;
        if (!tf.hasCode()) {
            if (text.length() > 0) {
                String sTuff = text;
                if (this.internalEncoderManager == null) {
                    if (this.getLayer() != null) {
                        sTuff = this.getLayer().encode(text, context);
                    }
                } else {
                    sTuff = this.getLayer() == null ? this.internalEncoderManager.encode(text, context) : this.getLayer().encode(this.internalEncoderManager.encode(sTuff, context), context);
                }
                if (context.ordinal() == EncoderContext.SKELETON.ordinal()) {
                    bHasBlankInText = OpenXMLContentSkeletonWriter.needsXmlSpacePreserve(text);
                    text = this.serializeText(sTuff, bHasBlankInText);
                } else if (context.ordinal() == EncoderContext.TEXT.ordinal() && this.configurationType == ParseType.MSWORD) {
                    bHasBlankInText = OpenXMLContentSkeletonWriter.needsXmlSpacePreserve(text);
                    text = this.serializeText(sTuff, bHasBlankInText);
                } else {
                    text = sTuff;
                }
                return text;
            }
            return "";
        }
        List<Code> codes = tf.getCodes();
        StringBuilder tmp = new StringBuilder();
        text = tf.getCodedText();
        String prefix = this.getRunPrefix();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': {
                    tmp = this.blankEnd(context, nSurroundingCodes, tmp);
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (this.checkForOpenTextTag(code.getData())) {
                        this.bInBlankText = true;
                    }
                    tmp.append(this.expandCodeContent(code, langToUse, context));
                    ++nSurroundingCodes;
                    continue block7;
                }
                case '\ue102': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (!code.getData().startsWith("</w:t>") && !code.getData().startsWith("</a:t>")) {
                        tmp = this.blankEnd(context, nSurroundingCodes, tmp);
                    } else {
                        this.bInBlankText = false;
                    }
                    tmp.append(this.expandCodeContent(code, langToUse, context));
                    --nSurroundingCodes;
                    continue block7;
                }
                case '\ue103': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (!code.getData().startsWith("</w:t>") && !code.getData().startsWith("</a:t>")) {
                        tmp = this.blankEnd(context, nSurroundingCodes, tmp);
                    } else {
                        this.bInBlankText = false;
                    }
                    if (this.checkForOpenTextTag(code.getData())) {
                        this.bInBlankText = true;
                    }
                    if (code.getTagType() == TextFragment.TagType.OPENING) {
                        ++nSurroundingCodes;
                    } else if (code.getTagType() == TextFragment.TagType.CLOSING) {
                        --nSurroundingCodes;
                    }
                    tmp.append(this.expandCodeContent(code, langToUse, context));
                    continue block7;
                }
                case '\t': {
                    this.addSpacePreserveToLastT(tmp);
                    tmp.append(ch);
                    continue block7;
                }
                case '\u2028': {
                    tmp.append("</").append(prefix).append("t><").append(prefix).append("br/><").append(prefix).append("t>");
                    continue block7;
                }
                default: {
                    if (!this.bInBlankText && nSurroundingCodes <= 0) {
                        if (context.ordinal() == EncoderContext.SKELETON.ordinal()) {
                            this.bInBlankText = true;
                            if (this.configurationType == ParseType.MSWORD) {
                                tmp.append(this.encody("<w:r><w:t xml:space=\"preserve\">", context));
                            } else if (this.configurationType == ParseType.MSPOWERPOINT) {
                                tmp.append(this.encody("<a:r><a:t>", context));
                            }
                        } else if (context.ordinal() == EncoderContext.TEXT.ordinal() && this.configurationType == ParseType.MSWORD) {
                            this.bInBlankText = true;
                            tmp.append(this.encody("<w:r><w:t xml:space=\"preserve\">", context));
                        }
                    }
                    if (Character.isHighSurrogate(ch)) {
                        int cp = text.codePointAt(i);
                        ++i;
                        if (this.internalEncoderManager == null) {
                            if (this.getLayer() == null) {
                                tmp.append(new String(Character.toChars(cp)));
                                continue block7;
                            }
                            tmp.append(this.getLayer().encode(cp, context));
                            continue block7;
                        }
                        if (this.getLayer() == null) {
                            tmp.append(this.internalEncoderManager.encode(cp, context));
                            continue block7;
                        }
                        tmp.append(this.getLayer().encode(this.internalEncoderManager.encode(cp, context), context));
                        continue block7;
                    }
                    if (this.internalEncoderManager == null) {
                        if (this.getLayer() == null) {
                            tmp.append(ch);
                            continue block7;
                        }
                        tmp.append(this.getLayer().encode(ch, context));
                        continue block7;
                    }
                    if (this.getLayer() == null) {
                        tmp.append(this.internalEncoderManager.encode(ch, context));
                        continue block7;
                    }
                    tmp.append(this.getLayer().encode(this.internalEncoderManager.encode(ch, context), context));
                }
            }
        }
        tmp = this.blankEnd(context, nSurroundingCodes, tmp);
        return tmp.toString();
    }

    private boolean checkForOpenTextTag(String text) {
        return text.endsWith("<w:t>") || text.endsWith("<w:t xml:space=\"preserve\">") || text.endsWith("<a:t>") || text.endsWith("<a:t xml:space=\"preserve\">");
    }

    void addSpacePreserveToLastT(StringBuilder tmp) {
        String t;
        int endOfT;
        int startOfT = tmp.lastIndexOf("<w:t");
        if (startOfT != -1 && (endOfT = tmp.indexOf(">", startOfT)) != -1 && !(t = tmp.substring(startOfT, endOfT)).contains("xml:space")) {
            t = t + " xml:space=\"preserve\">";
            tmp.replace(startOfT, endOfT + 1, t);
        }
    }

    static boolean needsXmlSpacePreserve(String text) {
        for (char c : text.toCharArray()) {
            if (!Character.isWhitespace(c) && c != '\u00a0') continue;
            return true;
        }
        return false;
    }

    private String encody(String s, EncoderContext context) {
        return s;
    }

    private StringBuilder blankEnd(EncoderContext context, int nSurroundingCodes, StringBuilder tmp) {
        String tail;
        String string = tail = tmp.length() >= 6 ? tmp.substring(tmp.length() - 6) : "";
        if (this.bInBlankText && nSurroundingCodes <= 0 && !tail.equals("</w:r>") && !tail.equals("</a:r>")) {
            if (context.ordinal() == EncoderContext.SKELETON.ordinal()) {
                this.bInBlankText = false;
                if (this.configurationType == ParseType.MSWORD) {
                    tmp.append(this.encody("</w:t></w:r>", context));
                } else if (this.configurationType == ParseType.MSPOWERPOINT) {
                    tmp.append(this.encody("</a:t></a:r>", context));
                }
            } else if (context.ordinal() == EncoderContext.TEXT.ordinal() && this.configurationType == ParseType.MSWORD) {
                this.bInBlankText = false;
                tmp.append(this.encody("</w:t></w:r>", context));
            }
        } else {
            this.bInBlankText = false;
        }
        return tmp;
    }
}

