/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StyledText;
import net.sf.okapi.filters.openxml.TextUnitWriter;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

public class StringItemTextUnitWriter
implements TextUnitWriter {
    private final XMLEventFactory eventFactory;
    private final StringItem stringItem;
    private final XMLEventSerializer xmlWriter;
    private StringBuilder textContent = new StringBuilder();

    public StringItemTextUnitWriter(XMLEventFactory eventFactory, StringItem stringItem, XMLEventSerializer xmlWriter) {
        this.eventFactory = eventFactory;
        this.stringItem = stringItem;
        this.xmlWriter = xmlWriter;
    }

    @Override
    public void write(TextContainer tc) {
        StyledText styledText = (StyledText)this.stringItem.getChunks().get(1);
        this.xmlWriter.add(styledText.startElement);
        for (Segment segment : tc.getSegments()) {
            this.writeSegment(segment);
        }
        this.xmlWriter.add(this.eventFactory.createCharacters(this.textContent.toString()));
        this.xmlWriter.add(styledText.endElement);
    }

    private void writeSegment(Segment segment) {
        TextFragment content = segment.getContent();
        String codedText = content.getCodedText();
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            this.writeChar(c);
        }
    }

    private void writeChar(char c) {
        this.textContent.append(c);
    }
}

