/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.nio.charset.CharsetEncoder;
import java.util.Map;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.its.ITSStandoffManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdlXliffSkeletonWriter
extends XLIFFSkeletonWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SDL_SEG_LOCKED_MARKER = "[@#$SDLSEGLOCKED$#@]";
    public static final String SDL_SEG_CONF_MARKER = "[@#$SDLSEGCONF$#@]";
    public static final String SDL_SEG_ORIGIN_MARKER = "[@#$SDLSEGORIGIN$#@]";
    public static final String PROP_SDL_LOCKED = "sdl_lock";
    public static final String PROP_SDL_CONF = "sdl_conf";
    public static final String PROP_SDL_ORIGIN = "sdl_origin";

    public SdlXliffSkeletonWriter(Parameters params) {
        super(params);
    }

    public SdlXliffSkeletonWriter(Parameters params, XLIFFContent fmt, ITSContent itsCont, ITSStandoffManager itsStandoffManager, Map<String, GenericAnnotations> lqiStandoff, Map<String, GenericAnnotations> provStandoff, CharsetEncoder chsEnc) {
        super(params, fmt, itsCont, itsStandoffManager, lqiStandoff, provStandoff, chsEnc);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        LocaleId tl;
        if (!resource.getTargetLocales().isEmpty() && resource.hasTarget(tl = resource.getTargetLocales().iterator().next())) {
            resource.setSkeleton(this.updateSdlSeg(resource.getTarget(tl), (GenericSkeleton)resource.getSkeleton()));
        }
        return super.processTextUnit(resource);
    }

    private ISkeleton updateSdlSeg(TextContainer target, GenericSkeleton skeleton) {
        for (GenericSkeletonPart p : skeleton.getParts()) {
            Property l = target.getProperty(PROP_SDL_LOCKED);
            Property c = target.getProperty(PROP_SDL_CONF);
            Property o = target.getProperty(PROP_SDL_ORIGIN);
            if (l == null && c == null && o == null) {
                return skeleton;
            }
            String d = p.getData().toString();
            if (l != null) {
                d = d.replace(SDL_SEG_LOCKED_MARKER, Util.isEmpty(this.getParams().getSdlSegLockedValue()) ? l.getValue() : this.getParams().getSdlSegLockedValue());
            }
            if (c != null) {
                d = d.replace(SDL_SEG_CONF_MARKER, Util.isEmpty(this.getParams().getSdlSegConfValue()) ? c.getValue() : this.getParams().getSdlSegConfValue());
            }
            if (o != null) {
                d = d.replace(SDL_SEG_ORIGIN_MARKER, Util.isEmpty(this.getParams().getSdlSegOriginValue()) ? o.getValue() : this.getParams().getSdlSegOriginValue());
            }
            p.setData(d);
        }
        return skeleton;
    }
}

