/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanList {
    private static final Logger logger = LoggerFactory.getLogger(BeanList.class);

    public static <E, S extends E, T extends IPersistenceBean<E>> void set(List<T> beanList, Class<T> beanClass, List<S> objList, IPersistenceSession session) {
        if (objList == null) {
            return;
        }
        for (S obj : objList) {
            IPersistenceBean bean = null;
            try {
                bean = (IPersistenceBean)beanClass.newInstance();
                bean.set(obj, session);
                beanList.add(bean);
            }
            catch (Exception e) {
                logger.error("Failed to create bean '{}' for '{}'.", (Object)ClassUtil.getQualifiedClassName(bean), (Object)ClassUtil.getQualifiedClassName(obj));
                throw new OkapiException(e);
            }
        }
    }

    public static <E, S extends E, T extends IPersistenceBean<E>> List<S> get(List<T> beanList, Class<S> objClass, IPersistenceSession session) {
        ArrayList<S> objList = new ArrayList<S>();
        for (IPersistenceBean bean : beanList) {
            S obj = bean.get(objClass, session);
            objList.add(obj);
        }
        return objList;
    }
}

