/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;

@UsingParameters
public class RawDocumentWriterStep
extends BasePipelineStep {
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    public String getDescription() {
        return "Write a RawDocument to an output file.";
    }

    @Override
    public String getName() {
        return "RawDocument Writer";
    }

    @Override
    public Event handleRawDocument(Event event) {
        try (RawDocument rawDoc = null;){
            rawDoc = (RawDocument)event.getResource();
            File outFile = new File(this.outputURI);
            Util.createDirectories(outFile.getAbsolutePath());
            StreamUtil.copy(rawDoc.getStream(), outFile);
        }
        return Event.NOOP_EVENT;
    }
}

