/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.msbatchtranslation;

import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.microsoft.MicrosoftMTConnector;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.steps.msbatchtranslation.SubmissionParameters;

@UsingParameters(value=SubmissionParameters.class)
public class MSBatchSubmissionStep
extends BasePipelineStep {
    private static final int MAXCOUNT = 80;
    private SubmissionParameters params = new SubmissionParameters();
    private ArrayList<TextFragment> sources;
    private ArrayList<TextFragment> targets;
    private ArrayList<Integer> ratings;
    private int maxCount = 80;
    private MicrosoftMTConnector conn;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;

    private void clean() {
        if (this.sources != null) {
            this.sources.clear();
            this.sources = null;
        }
        if (this.targets != null) {
            this.targets.clear();
            this.targets = null;
        }
        if (this.ratings != null) {
            this.ratings.clear();
            this.ratings = null;
        }
    }

    @Override
    public String getDescription() {
        return "Submits translations to Microosft Translator. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Microsoft Batch Submission";
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (SubmissionParameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.sources = new ArrayList();
        this.targets = new ArrayList();
        this.ratings = new ArrayList();
        if (this.maxCount < 1 || this.maxCount > 100) {
            this.maxCount = 80;
        }
        this.conn = new MicrosoftMTConnector();
        Parameters prm = this.conn.getParameters();
        prm.setClientId(this.params.getClientId());
        prm.setSecret(this.params.getSecret());
        this.conn.setLanguages(this.sourceLocale, this.targetLocale);
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (!tu.hasTarget(this.targetLocale)) {
            return event;
        }
        ISegments trgSegs = tu.getTargetSegments(this.targetLocale);
        for (Segment srcSeg : tu.getSourceSegments()) {
            Segment trgSeg;
            if (!srcSeg.text.hasText() || (trgSeg = trgSegs.get(srcSeg.getId())) == null || !trgSeg.text.hasText()) continue;
            this.sources.add(srcSeg.text);
            this.targets.add(trgSeg.text);
            this.ratings.add(this.params.getRating());
            if (this.sources.size() < this.maxCount) continue;
            this.submitTranslations();
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (!Util.isEmpty(this.sources)) {
            this.submitTranslations();
        }
        this.clean();
        return event;
    }

    private void submitTranslations() {
        this.conn.addTranslationList(this.sources, this.targets, this.ratings);
        this.sources.clear();
        this.targets.clear();
        this.ratings.clear();
    }
}

