/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlvalidation;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final int VALIDATIONTYPE_DTD = 0;
    public static final int VALIDATIONTYPE_SCHEMA = 1;
    public static final int VALIDATIONTYPE_RELAXNG = 2;
    private static String VALIDATE = "validate";
    private static String SCHEMAPATH = "schemaPath";
    private static final String VALIDATIONTYPE = "validationType";

    public boolean isValidate() {
        return this.getBoolean(VALIDATE);
    }

    public void setValidate(boolean validate) {
        this.setBoolean(VALIDATE, validate);
    }

    @ReferenceParameter
    public String getSchemaPath() {
        return this.getString(SCHEMAPATH);
    }

    public void setSchemaPath(String schemaPath) {
        this.setString(SCHEMAPATH, schemaPath);
    }

    public int getValidationType() {
        return this.getInteger(VALIDATIONTYPE);
    }

    public void setValidationType(int validationType) {
        this.setInteger(VALIDATIONTYPE, validationType);
    }

    @Override
    public void reset() {
        super.reset();
        this.setSchemaPath("");
        this.setValidate(false);
        this.setValidationType(0);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(VALIDATE, "Validate the documents structure [Well-formedness always checked]", null);
        desc.add(VALIDATIONTYPE, "Type of validation", "Indicates which validation to use");
        desc.add(SCHEMAPATH, "Path of the XML Schema", "Full path of the XML Schema.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("XML Validation", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(VALIDATE));
        String[] labels = new String[]{"DTD", "XML Schema", "RelaxNG Schema"};
        String[] values = new String[]{"0", "1", "2"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(VALIDATIONTYPE), values);
        lsp.setChoicesLabels(labels);
        lsp.setMasterPart(cbp, true);
        PathInputPart part = desc.addPathInputPart(paramDesc.get(SCHEMAPATH), "Schema", false);
        part.setBrowseFilters("Schema Files (*.xsd)\tAll Files (*.*)", "*.xsd\t*.*");
        part.setAllowEmpty(true);
        part.setMasterPart(cbp, true);
        return desc;
    }
}

