/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ReversedIterator;
import net.sf.okapi.common.exceptions.OkapiMisAlignmentException;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class AlignedSegments
implements IAlignedSegments {
    private ITextUnit parent;

    public AlignedSegments(ITextUnit parent) {
        this.parent = parent;
    }

    @Override
    public void append(Segment srcSeg, Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (srcSeg == null && trgSeg == null) {
            throw new IllegalArgumentException("srcSeg and trgSeg cannot both be null");
        }
        this.insertOrAppend(true, -1, srcSeg, trgSeg, trgLoc, variantOptions, copyOptions);
    }

    @Override
    public void insert(int index, Segment srcSeg, Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (srcSeg == null) {
            throw new IllegalArgumentException("srcSeg cannot be null");
        }
        this.insertOrAppend(false, index, srcSeg, trgSeg, trgLoc, variantOptions, copyOptions);
    }

    private void insertOrAppend(boolean append, int index, Segment srcSeg, Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        Segment sourceSeg = srcSeg != null ? srcSeg : trgSeg.clone();
        Segment targetSeg = trgSeg != null ? trgSeg : srcSeg.clone();
        Segment copySeg = sourceSeg.clone();
        String originalId = null;
        String insertedId = null;
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, copyOptions);
        if (append) {
            targetSeg.id = sourceSeg.id;
            if (ci.hasSource()) {
                ci.getSource().getSegments().append(ci.sourceSeg(sourceSeg));
            }
            if (ci.hasTarget()) {
                ci.getTarget().getSegments().append(ci.targetSeg(targetSeg));
            }
            while (ci.hasNextOtherLocale()) {
                ci.getNextOtherLocale().getSegments().append(ci.otherLocaleSeg(copySeg.clone()));
            }
        } else {
            originalId = this.getSource((LocaleId)trgLoc).getSegments().get((int)index).id;
            if (ci.hasSource()) {
                insertedId = this.doInsert(ci.getSource(), index, null, null, ci.sourceSeg(sourceSeg));
            }
            if (ci.hasTarget()) {
                insertedId = this.doInsert(ci.getTarget(), index, originalId, insertedId, ci.targetSeg(targetSeg));
            }
            while (ci.hasNextOtherLocale()) {
                insertedId = this.doInsert(ci.getNextOtherLocale(), index, originalId, insertedId, ci.otherLocaleSeg(copySeg.clone()));
            }
        }
    }

    private boolean continueWithOperation(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (this.hasMultipleTargets(trgLoc)) {
            if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.CANCEL_IF_MULTIPLE_TARGETS)) {
                return false;
            }
            if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.CREATE_VARIANT_IF_MULTIPLE_TARGETS)) {
                this.parent.getVariantSources().create(trgLoc, false, 7);
            }
        }
        return true;
    }

    private String doInsert(TextContainer container, int index, String originalId, String insertedId, Segment seg) {
        ISegments segs = container.getSegments();
        if (originalId == null) {
            segs.insert(index, seg);
            return seg.id;
        }
        Segment currentSeg = segs.get(originalId);
        if (currentSeg != null) {
            segs.insert(segs.getIndex(originalId), seg);
            if (insertedId != null) {
                seg.id = insertedId;
            }
            return seg.id;
        }
        segs.append(seg);
        return insertedId;
    }

    @Override
    public void setSegment(int index, Segment seg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.VariantOptions> idUpdateOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        ISegments segs = this.getSource(trgLoc).getSegments();
        String newId = seg.id;
        String oldId = segs.get((int)index).id;
        boolean idChanged = !newId.equals(oldId);
        int theIndex = index;
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, null);
        if (ci.hasSource()) {
            ci.getSource().getSegments().set(theIndex, seg.clone());
        }
        if (ci.hasTarget()) {
            segs = ci.getTarget().getSegments();
            segs.set(segs.getIndex(oldId), seg.clone());
        }
        while (ci.hasNextOtherLocale()) {
            segs = ci.getNextOtherLocale().getSegments();
            segs.set(segs.getIndex(oldId), seg.clone());
        }
        if (idChanged) {
            Segment tempSeg;
            ci = new ContainerIterator(trgLoc, idUpdateOptions, null);
            if (ci.hasSource() && (tempSeg = ci.getSource().getSegments().get(oldId)) != null) {
                tempSeg.id = newId;
            }
            if (ci.hasTarget() && (tempSeg = ci.getTarget().getSegments().get(oldId)) != null) {
                tempSeg.id = newId;
            }
            while (ci.hasNextOtherLocale()) {
                tempSeg = ci.getNextOtherLocale().getSegments().get(oldId);
                if (tempSeg == null) continue;
                tempSeg.id = newId;
            }
        }
    }

    @Override
    public boolean remove(Segment seg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        int count = 0;
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, null);
        if (ci.hasSource()) {
            count += this.removeSegment(ci.getSource(), seg.id);
        }
        if (ci.hasTarget()) {
            count += this.removeSegment(ci.getTarget(), seg.id);
        }
        while (ci.hasNextOtherLocale()) {
            count += this.removeSegment(ci.getNextOtherLocale(), seg.id);
        }
        return count > 0;
    }

    private int removeSegment(TextContainer container, String segId) {
        ISegments segs = container.getSegments();
        int segIndex = segs.getIndex(segId);
        if (segIndex > -1) {
            container.remove(segs.getPartIndex(segIndex));
            return 1;
        }
        return 0;
    }

    @Override
    public Segment getSource(int index, LocaleId trgLoc) {
        return this.getSource(trgLoc).getSegments().get(index);
    }

    @Override
    public Segment getCorrespondingTarget(Segment srcSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        variantOptions = ((EnumSet)variantOptions).clone();
        ISegments trgSegs = this.parent.getTargetSegments(trgLoc);
        Segment trgSeg = trgSegs.get(srcSeg.id);
        if (trgSeg == null) {
            ((AbstractCollection)variantOptions).remove((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE);
            ((AbstractCollection)variantOptions).add(IAlignedSegments.VariantOptions.MODIFY_TARGET);
            this.append(srcSeg, null, trgLoc, (EnumSet<IAlignedSegments.VariantOptions>)variantOptions, copyOptions);
        }
        return trgSegs.get(srcSeg.id);
    }

    @Override
    public Segment getCorrespondingSource(Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        variantOptions = ((EnumSet)variantOptions).clone();
        ISegments srcSegs = this.getSource(trgLoc).getSegments();
        Segment srcSeg = srcSegs.get(trgSeg.id);
        if (srcSeg == null) {
            ((AbstractCollection)variantOptions).add(IAlignedSegments.VariantOptions.MODIFY_SOURCE);
            ((AbstractCollection)variantOptions).remove((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET);
            this.append(null, trgSeg, trgLoc, (EnumSet<IAlignedSegments.VariantOptions>)variantOptions, copyOptions);
        }
        return srcSegs.get(trgSeg.id);
    }

    @Override
    public Segment getCorrespondingTarget(Segment seg, LocaleId trgLoc) {
        return this.getCorrespondingTarget(seg, trgLoc, IAlignedSegments.MODIFY_SOURCE_AND_ASSOCIATED_TARGET, IAlignedSegments.COPY_TO_NONE);
    }

    @Override
    public Segment getCorrespondingSource(Segment trgSeg, LocaleId trgLoc) {
        return this.getCorrespondingSource(trgSeg, trgLoc, IAlignedSegments.MODIFY_SOURCE_AND_ASSOCIATED_TARGET, IAlignedSegments.COPY_TO_NONE);
    }

    @Override
    public void align(List<AlignedPair> alignedSegmentPairs, LocaleId trgLoc) {
        if (!this.hasVariant(trgLoc)) {
            this.parent.getVariantSources().create(trgLoc, true, 7);
        }
        this.parent.createTarget(trgLoc, false, 7);
        TextContainer src = this.getSource(trgLoc);
        TextContainer trg = this.parent.getTarget(trgLoc);
        src.clear();
        trg.clear();
        for (AlignedPair alignedPair : alignedSegmentPairs) {
            String srcSegId = this.appendPartsToContainer(alignedPair.getSourceParts(), src, null);
            this.appendPartsToContainer(alignedPair.getTargetParts(), trg, srcSegId);
        }
        src.setHasBeenSegmentedFlag(true);
        trg.setHasBeenSegmentedFlag(true);
        trg.getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    private String appendPartsToContainer(List<TextPart> parts, TextContainer container, String segId) {
        TextPart part;
        LinkedList<TextPart> partsCopy = new LinkedList<TextPart>(parts);
        int beforeIndex = 0;
        int afterIndex = partsCopy.size();
        Iterator i$ = partsCopy.iterator();
        while (i$.hasNext() && !(part = (TextPart)i$.next()).isSegment()) {
            ++beforeIndex;
        }
        ReversedIterator<TextPart> ri = new ReversedIterator<TextPart>(partsCopy);
        for (TextPart part2 : ri) {
            if (part2.isSegment()) break;
            --afterIndex;
        }
        for (TextPart part2 : partsCopy.subList(0, beforeIndex)) {
            container.append(part2);
        }
        TextFragment frag = new TextFragment();
        for (TextPart part3 : partsCopy.subList(beforeIndex, afterIndex)) {
            frag.append(part3.getContent());
        }
        Segment seg = new Segment(segId, frag);
        container.getSegments().append(seg);
        for (TextPart part4 : partsCopy.subList(afterIndex, partsCopy.size())) {
            container.append(part4);
        }
        return seg.getId();
    }

    @Override
    public void align(LocaleId trgLoc) {
        Iterator<Segment> srcSegsIt = this.getSource(trgLoc).getSegments().iterator();
        Iterator<Segment> trgSegsIt = this.parent.createTarget(trgLoc, false, 4).getSegments().iterator();
        while (srcSegsIt.hasNext()) {
            try {
                Segment srcSeg = srcSegsIt.next();
                Segment trgSeg = trgSegsIt.next();
                trgSeg.id = srcSeg.id;
            }
            catch (NoSuchElementException e) {
                throw new OkapiMisAlignmentException("Different number of source and target segments", e);
            }
        }
        this.parent.getTargetSegments(trgLoc).setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    @Override
    public void alignCollapseAll(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (this.continueWithOperation(trgLoc, variantOptions)) {
            // empty if block
        }
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, COPY_TO_NONE);
        LinkedList<TextContainer> collapsed = new LinkedList<TextContainer>();
        if (ci.hasSource()) {
            ci.getSource().joinAll();
            ci.getSource().setHasBeenSegmentedFlag(false);
            collapsed.add(ci.getSource());
        }
        if (ci.hasTarget()) {
            ci.getTarget().joinAll();
            ci.getTarget().setHasBeenSegmentedFlag(false);
            collapsed.add(ci.getTarget());
        }
        while (ci.hasNextOtherLocale()) {
            TextContainer container = ci.getNextOtherLocale();
            container.joinAll();
            container.setHasBeenSegmentedFlag(false);
            collapsed.add(container);
        }
        for (LocaleId loc : this.parent.getTargetLocales()) {
            TextContainer trg;
            TextContainer src = this.getSource(loc);
            if (!collapsed.contains(src) || !collapsed.contains(trg = this.parent.getTarget(loc))) continue;
            trg.getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
            trg.getFirstSegment().id = src.getFirstSegment().getId();
        }
    }

    @Override
    public Segment splitSource(LocaleId trgLoc, Segment srcSeg, int splitPos, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        ISegments currentSegs;
        Segment currentSeg;
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return null;
        }
        TextContainer theSource = this.getSource(trgLoc);
        ISegments srcSegs = theSource.getSegments();
        int segIndex = srcSegs.getIndex(srcSeg.id);
        if (segIndex == -1) {
            return null;
        }
        int partIndex = srcSegs.getPartIndex(segIndex);
        theSource.split(partIndex, splitPos, splitPos, false);
        Segment newSeg = srcSegs.get(segIndex + 1);
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, copyOptions);
        if (ci.hasTarget() && (currentSeg = (currentSegs = ci.getTarget().getSegments()).get(srcSeg.id)) != null) {
            currentSegs.insert(currentSegs.getIndex(srcSeg.id) + 1, ci.targetSeg(newSeg.clone()));
        }
        this.propagateChangesForSplit(newSeg, srcSeg.id, ci);
        return newSeg;
    }

    @Override
    public Segment splitTarget(LocaleId trgLoc, Segment trgSeg, int splitPos, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        ISegments currentSegs;
        Segment currentSeg;
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return null;
        }
        TextContainer theTarget = this.parent.createTarget(trgLoc, false, 4);
        ISegments trgSegs = theTarget.getSegments();
        int segIndex = trgSegs.getIndex(trgSeg.id);
        if (segIndex == -1) {
            return null;
        }
        int partIndex = trgSegs.getPartIndex(segIndex);
        theTarget.split(partIndex, splitPos, splitPos, false);
        Segment newSeg = trgSegs.get(segIndex + 1);
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, copyOptions);
        if (ci.hasSource() && (currentSeg = (currentSegs = ci.getSource().getSegments()).get(trgSeg.id)) != null) {
            currentSegs.insert(currentSegs.getIndex(trgSeg.id) + 1, ci.sourceSeg(newSeg.clone()));
        }
        this.propagateChangesForSplit(newSeg, trgSeg.id, ci);
        return newSeg;
    }

    private void propagateChangesForSplit(Segment newSeg, String segId, ContainerIterator ci) {
        while (ci.hasNextOtherLocale()) {
            ISegments currentSegs = ci.getNextOtherLocale().getSegments();
            Segment currentSeg = currentSegs.get(segId);
            if (currentSeg == null) continue;
            currentSegs.insert(currentSegs.getIndex(segId) + 1, ci.otherLocaleSeg(newSeg.clone()));
        }
    }

    @Override
    public void joinWithNext(Segment seg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, null);
        if (ci.hasSource()) {
            this.doJoinWithNext(ci.getSource(), seg.id);
        }
        if (ci.hasTarget()) {
            this.doJoinWithNext(ci.getTarget(), seg.id);
        }
        while (ci.hasNextOtherLocale()) {
            this.doJoinWithNext(ci.getNextOtherLocale(), seg.id);
        }
    }

    private void doJoinWithNext(TextContainer cont, String segId) {
        ISegments segs = cont.getSegments();
        int segIndex = segs.getIndex(segId);
        if (segIndex != -1) {
            segs.joinWithNext(segIndex);
        }
    }

    @Override
    public void joinAll(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        ContainerIterator ci = new ContainerIterator(trgLoc, variantOptions, null);
        if (ci.hasSource()) {
            ci.getSource().joinAll();
        }
        if (ci.hasTarget()) {
            ci.getTarget().joinAll();
        }
        while (ci.hasNextOtherLocale()) {
            ci.getNextOtherLocale().joinAll();
        }
    }

    @Override
    public AlignmentStatus getAlignmentStatus() {
        for (LocaleId loc : this.parent.getTargetLocales()) {
            ISegments trgSegs = this.parent.getTargetSegments(loc);
            if (trgSegs.getAlignmentStatus() != AlignmentStatus.NOT_ALIGNED) continue;
            return AlignmentStatus.NOT_ALIGNED;
        }
        return AlignmentStatus.ALIGNED;
    }

    @Override
    public AlignmentStatus getAlignmentStatus(LocaleId trgLoc) {
        return this.parent.getTargetSegments(trgLoc).getAlignmentStatus();
    }

    @Override
    public void segmentSource(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer theSource = this.getSource(targetLocale);
        segmenter.computeSegments(theSource);
        theSource.getSegments().create(segmenter.getRanges());
    }

    @Override
    public void segmentTarget(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer theTarget = this.parent.createTarget(targetLocale, false, 4);
        segmenter.computeSegments(theTarget);
        theTarget.getSegments().create(segmenter.getRanges());
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.parent.getSource().getSegments().iterator();
    }

    @Override
    public Iterator<Segment> iterator(LocaleId trgLoc) {
        return this.getSource(trgLoc).getSegments().iterator();
    }

    private boolean hasMultipleTargets(LocaleId targetLocale) {
        if (this.hasVariant(targetLocale)) {
            return false;
        }
        int targetsOfDefault = 0;
        for (LocaleId loc : this.parent.getTargetLocales()) {
            if (!this.parent.getVariantSources().getLocales().contains(loc)) {
                ++targetsOfDefault;
            }
            if (targetsOfDefault <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasVariant(LocaleId loc) {
        if (this.parent.hasVariantSources()) {
            return this.parent.getVariantSources().hasVariant(loc);
        }
        return false;
    }

    private TextContainer getSource(LocaleId loc) {
        if (this.hasVariant(loc)) {
            return this.parent.getVariantSources().get(loc);
        }
        return this.parent.getSource();
    }

    public final ITextUnit getParent() {
        return this.parent;
    }

    private class ContainerIterator {
        private TextContainer theSource = null;
        private TextContainer theTarget = null;
        private Stack<TextContainer> sameSourceTargets;
        private Stack<TextContainer> otherSources;
        private Stack<TextContainer> otherTargets;
        private int otherContainerType = -1;
        private final int sameSourceTarget = 0;
        private final int otherSource = 1;
        private final int otherTarget = 2;
        private EnumSet<IAlignedSegments.CopyOptions> myCopyOptions;

        public ContainerIterator(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
            this.myCopyOptions = copyOptions;
            if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE)) {
                this.theSource = AlignedSegments.this.getSource(trgLoc);
            }
            if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
                this.theTarget = AlignedSegments.this.parent.getTarget(trgLoc);
            }
            this.sameSourceTargets = variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE) ? this.getSameSourceTargets(trgLoc) : new Stack();
            this.otherSources = variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES) ? this.getOtherSources(trgLoc) : new Stack();
            this.otherTargets = variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES) ? this.getOtherSourceTargets(trgLoc) : new Stack();
        }

        public boolean hasSource() {
            return this.theSource != null;
        }

        public TextContainer getSource() {
            if (this.theSource == null) {
                throw new IllegalStateException("this method can only be called after hasSource() returns true");
            }
            return this.theSource;
        }

        public boolean hasTarget() {
            return this.theTarget != null;
        }

        public TextContainer getTarget() {
            if (this.theTarget == null) {
                throw new IllegalStateException("this method can only be called after hasTarget() returns true");
            }
            return this.theTarget;
        }

        public boolean hasSameSourceTarget() {
            return !this.sameSourceTargets.empty();
        }

        public TextContainer getSameSourceTarget() {
            return this.sameSourceTargets.pop();
        }

        public boolean hasOtherSource() {
            return !this.otherSources.empty();
        }

        public TextContainer getOtherSource() {
            return this.otherSources.pop();
        }

        public boolean hasOtherTarget() {
            return !this.otherTargets.empty();
        }

        public TextContainer getOtherTarget() {
            return this.otherTargets.pop();
        }

        public boolean hasNextOtherLocale() {
            if (this.hasSameSourceTarget()) {
                this.otherContainerType = 0;
                return true;
            }
            if (this.hasOtherSource()) {
                this.otherContainerType = 1;
                return true;
            }
            if (this.hasOtherTarget()) {
                this.otherContainerType = 2;
                return true;
            }
            return false;
        }

        public TextContainer getNextOtherLocale() {
            if (this.hasSameSourceTarget()) {
                return this.getSameSourceTarget();
            }
            if (this.hasOtherSource()) {
                return this.getOtherSource();
            }
            return this.getOtherTarget();
        }

        private Stack<TextContainer> getOtherSourceTargets(LocaleId loc) {
            Set<Object> locales = new HashSet();
            if (AlignedSegments.this.hasVariant(loc)) {
                locales = AlignedSegments.this.parent.getTargetLocales();
            } else if (AlignedSegments.this.parent.hasVariantSources()) {
                locales = AlignedSegments.this.parent.getVariantSources().getLocales();
            }
            locales.remove(loc);
            Stack<TextContainer> targets = new Stack<TextContainer>();
            for (LocaleId localeId : locales) {
                targets.push(AlignedSegments.this.parent.getTarget(localeId));
            }
            return targets;
        }

        private Stack<TextContainer> getSameSourceTargets(LocaleId targetLocale) {
            HashSet<LocaleId> locales = new HashSet<LocaleId>();
            if (AlignedSegments.this.hasMultipleTargets(targetLocale)) {
                locales.addAll(AlignedSegments.this.parent.getTargetLocales());
                locales.remove(targetLocale);
                if (AlignedSegments.this.parent.hasVariantSources()) {
                    locales.removeAll(AlignedSegments.this.parent.getVariantSources().getLocales());
                }
            }
            Stack<TextContainer> targets = new Stack<TextContainer>();
            for (LocaleId loc : locales) {
                targets.push(AlignedSegments.this.parent.getTarget(loc));
            }
            return targets;
        }

        private Stack<TextContainer> getOtherSources(LocaleId loc) {
            Stack<TextContainer> sources = new Stack<TextContainer>();
            if (!AlignedSegments.this.parent.hasVariantSources()) {
                return sources;
            }
            for (LocaleId varLoc : AlignedSegments.this.parent.getVariantSources().getLocales()) {
                sources.add(AlignedSegments.this.parent.getVariantSources().get(varLoc));
            }
            sources.add(AlignedSegments.this.parent.getSource());
            sources.remove(AlignedSegments.this.getSource(loc));
            return sources;
        }

        public Segment sourceSeg(Segment seg) {
            if (!this.myCopyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_SOURCE)) {
                seg.getContent().clear();
            }
            return seg;
        }

        public Segment targetSeg(Segment seg) {
            if (!this.myCopyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGET)) {
                seg.getContent().clear();
            }
            return seg;
        }

        public Segment sameSourceTargetSeg(Segment seg) {
            if (!this.myCopyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGETS_WITH_SAME_SOURCE)) {
                seg.getContent().clear();
            }
            return seg;
        }

        public Segment otherSourceSeg(Segment seg) {
            if (!this.myCopyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_VARIANT_SOURCES)) {
                seg.getContent().clear();
            }
            return seg;
        }

        public Segment otherTargetSeg(Segment seg) {
            if (!this.myCopyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGETS_OF_VARIANT_SOURCES)) {
                seg.getContent().clear();
            }
            return seg;
        }

        public Segment otherLocaleSeg(Segment seg) {
            if (this.otherContainerType == 0) {
                return this.sameSourceTargetSeg(seg);
            }
            if (this.otherContainerType == 1) {
                return this.otherSourceSeg(seg);
            }
            if (this.otherContainerType == 2) {
                return this.otherTargetSeg(seg);
            }
            throw new IllegalStateException("this method can only be called after hasNextOtherLocale()");
        }
    }
}

