/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextFragment;

public class Code {
    public static final String TYPE_NULL = "null";
    public static final String TYPE_BOLD = "bold";
    public static final String TYPE_ITALIC = "italic";
    public static final String TYPE_UNDERLINED = "underlined";
    public static final String TYPE_LB = "lb";
    public static final String TYPE_LINK = "link";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_COMMENT = "comment";
    public static final String TYPE_CDATA = "cdata";
    public static final String TYPE_XML_PROCESSING_INSTRUCTION = "processing-instruction";
    public static final String TYPE_REFERENCE = "ref";
    public static final String TYPE_ANNOTATION_ONLY = "_annotation_";
    public static final String EXTENDED_CODE_TYPE_PREFIX = "x-";
    public static final String EXTENDED_CODE_TYPE_DELIMITER = ";";
    public static final String EXTENDED_CODE_TYPE_VALUE_DELIMITER = ":";
    private static final int DATA_DEFAULT_SIZE = 10;
    private static final int ANNOTATIONS_INITCAP = 1;
    protected static final int HASREF = 1;
    public static final int CLONEABLE = 2;
    public static final int DELETEABLE = 4;
    public static final int ADDED = 8;
    public static final int MERGED = 16;
    protected TextFragment.TagType tagType;
    protected String originalId;
    protected int id;
    protected String type;
    protected StringBuilder data;
    protected String mergedData;
    protected StringBuilder outerData;
    protected int flag;
    protected LinkedHashMap<String, InlineAnnotation> annotations;

    public static String codesToString(List<Code> list) {
        return Code.codesToString(list, false);
    }

    public static String codesToString(List<Code> list, boolean stripOuterData) {
        StringBuilder tmp = new StringBuilder();
        for (Code code : list) {
            if (code.originalId != null) {
                tmp.append(String.format("%s\u009c%d\u009c%s\u009c%s\u009c%d\u009c%s\u009c%s\u009c%s\u009d", new Object[]{code.tagType, code.id, code.type, code.data, code.flag, code.originalId, stripOuterData ? null : code.outerData, Code.annotationsToString(code.annotations)}));
                continue;
            }
            tmp.append(String.format("%s\u009c%d\u009c%s\u009c%s\u009c%d\u009c%s\u009c%s\u009d", new Object[]{code.tagType, code.id, code.type, code.data, code.flag, stripOuterData ? null : code.outerData, Code.annotationsToString(code.annotations)}));
        }
        return tmp.toString();
    }

    public static boolean sameCodes(List<Code> codes1, List<Code> codes2) {
        if (codes1.size() != codes2.size()) {
            return false;
        }
        for (int i = 0; i < codes1.size(); ++i) {
            Code code1 = codes1.get(i);
            Code code2 = codes2.get(i);
            if (code1.id != code2.id) {
                return false;
            }
            if (!(code1.data != null ? !code1.data.equals(code2.data) : code1.data != null)) continue;
            return false;
        }
        return true;
    }

    public static int getIndex(List<Code> codes, boolean forClosing, int id) {
        if (codes == null) {
            return -1;
        }
        int i = 0;
        for (Code code : codes) {
            if (code.id == id) {
                if (forClosing) {
                    if (code.tagType == TextFragment.TagType.CLOSING) {
                        return i;
                    }
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static String annotationsToString(LinkedHashMap<String, InlineAnnotation> map) {
        if (map == null || map.isEmpty()) {
            return TYPE_NULL;
        }
        StringBuilder tmp = new StringBuilder();
        for (String key : map.keySet()) {
            tmp.append(key + "\u009e");
            InlineAnnotation annotation = map.get(key);
            tmp.append(annotation == null ? "" : annotation.toString());
            tmp.append('\u009f');
        }
        return tmp.toString();
    }

    public static List<Code> stringToCodes(String data) {
        ArrayList<Code> list = new ArrayList<Code>();
        if (data != null) {
            String[] tmpCodes;
            for (String tmp : tmpCodes = data.split("\u009d")) {
                if (tmp.length() == 0) continue;
                String[] tmpFields = tmp.split("\u009c");
                Code code = new Code(TextFragment.TagType.valueOf(tmpFields[0]), tmpFields[2], tmpFields[3]);
                code.id = Integer.valueOf(tmpFields[1]);
                code.flag = Integer.valueOf(tmpFields[4]);
                int outerDataIndex = 5;
                int annotationIndex = 6;
                if (tmpFields.length >= 8) {
                    ++outerDataIndex;
                    ++annotationIndex;
                    if (!tmpFields[5].equals(TYPE_NULL)) {
                        code.originalId = tmpFields[5];
                    }
                }
                if (!tmpFields[outerDataIndex].equals(TYPE_NULL)) {
                    if (code.outerData == null) {
                        code.outerData = new StringBuilder(10);
                    }
                    code.outerData.setLength(0);
                    code.outerData.append(tmpFields[outerDataIndex]);
                }
                code.annotations = tmpFields.length > annotationIndex ? Code.stringToAnnotations(tmpFields[annotationIndex]) : null;
                list.add(code);
            }
        }
        return list;
    }

    private static LinkedHashMap<String, InlineAnnotation> stringToAnnotations(String data) {
        String[] tmpEntries;
        if (data == null || data.length() == 0 || TYPE_NULL.equals(data)) {
            return null;
        }
        LinkedHashMap<String, InlineAnnotation> map = new LinkedHashMap<String, InlineAnnotation>(1);
        for (String tmp : tmpEntries = data.split("\u009f")) {
            InlineAnnotation annotation;
            if (tmp.length() == 0) continue;
            String[] tmpPair = tmp.split("\u009e");
            if (tmpPair.length > 1) {
                boolean isGA = "generic".equals(tmpPair[0]);
                annotation = isGA ? new GenericAnnotations() : new InlineAnnotation();
                annotation.fromString(tmpPair[1]);
            } else {
                annotation = null;
            }
            map.put(tmpPair[0], annotation);
        }
        return map;
    }

    public Code() {
        this.data = new StringBuilder();
        this.outerData = new StringBuilder();
    }

    public Code(TextFragment.TagType tagType, String type, String data) {
        this.id = -1;
        this.tagType = tagType;
        this.flag = 0;
        this.type = type == null ? TYPE_NULL : type;
        this.data = new StringBuilder(10);
        if (data == null) {
            data = "";
        }
        this.data.append(data);
    }

    private Code(TextFragment.TagType tagType, String type, StringBuilder data) {
        this(tagType, type, data == null ? "" : data.toString());
    }

    public Code(TextFragment.TagType tagType, String type) {
        this(tagType, type, "");
    }

    public Code(String type) {
        this(null, type, "");
    }

    public void append(String data) {
        if (data != null) {
            this.data.append(data);
        }
    }

    public void appendOuterData(String outerData) {
        if (outerData == null) {
            return;
        }
        if (this.outerData == null) {
            this.outerData = new StringBuilder(10);
        }
        this.outerData.append(outerData);
    }

    public void appendReference(String id) {
        this.data.append(TextFragment.makeRefMarker(id));
        this.setReferenceFlag(true);
    }

    public void appendReference(String id, String propertyName) {
        this.data.append(TextFragment.makeRefMarker(id, propertyName));
        this.setReferenceFlag(true);
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean hasAnnotation() {
        return this.annotations != null && this.annotations.size() > 0;
    }

    public boolean hasAnnotation(String type) {
        if (this.annotations == null) {
            return false;
        }
        return this.annotations.containsKey(type);
    }

    public boolean hasOnlyAnnotation() {
        if (this.annotations == null) {
            return false;
        }
        return this.type.equals(TYPE_ANNOTATION_ONLY);
    }

    public boolean hasData() {
        return this.data.length() > 0;
    }

    public boolean hasOriginalId() {
        return !Util.isEmpty(this.originalId);
    }

    public boolean hasOuterData() {
        return !Util.isEmpty(this.outerData);
    }

    public Code clone() {
        Code newCode = new Code(this.tagType, this.type, this.data);
        newCode.id = this.id;
        newCode.outerData = this.outerData == null ? null : new StringBuilder(this.outerData);
        newCode.flag = this.flag;
        newCode.mergedData = this.mergedData;
        if (this.annotations != null) {
            newCode.annotations = new LinkedHashMap();
            for (String type : this.annotations.keySet()) {
                InlineAnnotation annot = this.annotations.get(type);
                if (annot == null) {
                    newCode.annotations.put(type, null);
                    continue;
                }
                newCode.annotations.put(type, annot.clone());
            }
        }
        return newCode;
    }

    public TextFragment.TagType getTagType() {
        return this.tagType;
    }

    public void setTagType(TextFragment.TagType value) {
        this.tagType = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value == null ? TYPE_NULL : value;
    }

    public String getData() {
        return this.data.toString();
    }

    public void setData(String value) {
        this.data.setLength(0);
        if (value != null) {
            this.data.append(value);
            if (value.contains("[#$")) {
                this.setReferenceFlag(true);
            }
        }
    }

    public String getMergedData() {
        return this.mergedData;
    }

    public void setMergedData(String mergedData) {
        if (mergedData != null) {
            this.setMerged(true);
        }
        this.mergedData = mergedData;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public boolean hasReference() {
        return (this.flag & 1) == 1;
    }

    public void setReferenceFlag(boolean value) {
        this.flag = value ? (this.flag |= 1) : (this.flag &= 0xFFFFFFFE);
    }

    public void setOuterData(String value) {
        if (value == null) {
            this.outerData = null;
            return;
        }
        if (this.outerData == null) {
            this.outerData = new StringBuilder(10);
        }
        this.outerData.setLength(0);
        this.outerData.append(value);
    }

    public String getOuterData() {
        if (this.outerData != null) {
            return this.outerData.toString();
        }
        return this.data.toString();
    }

    public boolean isCloneable() {
        return (this.flag & 2) == 2;
    }

    public void setCloneable(boolean value) {
        this.flag = value ? (this.flag |= 2) : (this.flag &= 0xFFFFFFFD);
    }

    public boolean isDeleteable() {
        return (this.flag & 4) == 4;
    }

    public void setDeleteable(boolean value) {
        this.flag = value ? (this.flag |= 4) : (this.flag &= 0xFFFFFFFB);
    }

    public boolean isAdded() {
        return (this.flag & 8) == 8;
    }

    public void setAdded(boolean value) {
        this.flag = value ? (this.flag |= 8) : (this.flag &= 0xFFFFFFF7);
    }

    public boolean isMerged() {
        return (this.flag & 0x10) == 16;
    }

    public void setMerged(boolean value) {
        this.flag = value ? (this.flag |= 0x10) : (this.flag &= 0xFFFFFFEF);
    }

    public void setAnnotation(String type, InlineAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new LinkedHashMap(1);
        }
        this.annotations.put(type, annotation);
    }

    public InlineAnnotation getAnnotation(String type) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(type);
    }

    public void removeAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.annotations = null;
        }
    }

    public void removeAnnotation(String type) {
        if (this.annotations != null) {
            this.annotations.remove(type);
        }
    }

    public GenericAnnotations getGenericAnnotations() {
        return (GenericAnnotations)this.getAnnotation("generic");
    }

    public String getGenericAnnotationString(String type, String fieldName) {
        GenericAnnotations anns = this.getGenericAnnotations();
        if (anns == null) {
            return null;
        }
        GenericAnnotation ann = anns.getFirstAnnotation(type);
        if (ann == null) {
            return null;
        }
        return ann.getString(fieldName);
    }

    public void setDisplayText(String text) {
        if (Util.isEmpty(text)) {
            return;
        }
        GenericAnnotation ann = new GenericAnnotation("displayText");
        ann.setString("displayTextValue", text);
        GenericAnnotation.addAnnotation(this, ann);
    }

    public String getDisplayText() {
        return this.getGenericAnnotationString("displayText", "displayTextValue");
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    protected LinkedHashMap<String, InlineAnnotation> getAnnotations() {
        return this.annotations;
    }

    protected void setAnnotations(LinkedHashMap<String, InlineAnnotation> annotations) {
        this.annotations = annotations;
    }
}

