/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.archive;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ResourceUtil;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ZipFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.archive.Parameters;

@UsingParameters(value=Parameters.class)
public class ArchiveFilter
extends AbstractFilter {
    public static final String MIME_TYPE = "application/x-archive";
    private final String SID = "sd";
    private final String EID = "ed";
    private ZipFile zipFile;
    private ZipEntry entry;
    private ZipFilterWriter filterWriter;
    private NextAction nextAction;
    private URI docURI;
    private Enumeration<? extends ZipEntry> entries;
    private int subDocId;
    private LinkedList<Event> queue;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private IFilter subFilter;
    private IFilterWriter subDocWriter;
    private Parameters params = new Parameters();
    private String[] fileNames;
    private String[] configIds;
    private IFilterConfigurationMapper fcMapper;
    private StartDocument saveStartDoc;
    private RawDocument input;
    private File fromStreamTmpFile;

    public ArchiveFilter() {
        this.params.setMimeType(MIME_TYPE);
        this.setMimeType(MIME_TYPE);
        this.setFilterWriter(this.createFilterWriter());
        this.setParameters(new Parameters());
        this.setName(this.getName());
        this.setDisplayName(this.getDisplayName());
        this.addConfiguration(new FilterConfiguration(this.getName(), MIME_TYPE, this.getClass().getName(), "Archive Files", "Configuration for archive files", null, ".archive;"));
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        try {
            this.nextAction = NextAction.DONE;
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        if (this.fromStreamTmpFile != null) {
            this.fromStreamTmpFile.delete();
        }
    }

    @Override
    public IFilterWriter createFilterWriter() {
        if (this.filterWriter == null) {
            this.filterWriter = new ZipFilterWriter(this.getEncoderManager());
        }
        return this.filterWriter;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Archive Filter (BETA)";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public String getMimeType() {
        return this.params == null ? MIME_TYPE : this.params.getMimeType();
    }

    @Override
    public String getName() {
        return "okf_archive";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null && !this.queue.isEmpty() || this.nextAction != NextAction.DONE;
    }

    @Override
    public Event next() {
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        switch (this.nextAction) {
            case OPENZIP: {
                return this.openZipFile();
            }
            case NEXTINZIP: {
                return this.nextInZipFile();
            }
            case NEXTINSUBDOC: {
                return this.nextInSubDocument();
            }
        }
        throw new OkapiIllegalFilterOperationException("Invalid next() call.");
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        if (input.getInputURI() == null) {
            this.fromStreamTmpFile = FileUtil.createTempFile("archive_filter_stream");
            StreamUtil.copy(input.getStream(), this.fromStreamTmpFile);
            this.input = new RawDocument(this.fromStreamTmpFile.toURI(), input.getEncoding(), input.getSourceLocale(), input.getTargetLocale(), input.getFilterConfigId());
        }
        this.docURI = this.input.getInputURI();
        this.nextAction = NextAction.OPENZIP;
        this.queue = new LinkedList();
        this.srcLoc = input.getSourceLocale();
        this.trgLoc = input.getTargetLocale();
        this.updateFilterConfigurationMapper();
        this.fileNames = ListUtil.stringAsArray(((Parameters)this.getParameters()).getFileNames());
        this.configIds = ListUtil.stringAsArray(((Parameters)this.getParameters()).getConfigIds());
        if (this.configIds.length > 0 && this.fileNames.length != this.configIds.length) {
            throw new OkapiException("Different number of filter configuration ids and filenames in parameters");
        }
        if (!Util.isEmpty(((Parameters)this.getParameters()).getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(((Parameters)this.getParameters()).getSimplifierRules());
            this.queue.add(cs);
        }
    }

    private void updateFilterConfigurationMapper() {
        if (this.fcMapper == null) {
            this.fcMapper = new FilterConfigurationMapper();
            DefaultFilters.setMappings(this.fcMapper, true, true);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public IFilterConfigurationMapper getFilterConfigurationMapper() {
        this.updateFilterConfigurationMapper();
        return this.fcMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private Event openZipFile() {
        try {
            this.zipFile = new ZipFile(new File(this.docURI));
            this.entries = this.zipFile.entries();
            this.subDocId = 0;
            this.nextAction = NextAction.NEXTINZIP;
            StartDocument startDoc = new StartDocument("sd");
            startDoc.setName(this.docURI.getPath());
            startDoc.setLocale(this.srcLoc);
            startDoc.setMimeType(this.getMimeType());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setLineBreak("\n");
            startDoc.setEncoding("UTF-8", false);
            return new Event(EventType.START_DOCUMENT, startDoc);
        }
        catch (ZipException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private Event nextInZipFile() {
        if (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            this.subFilter = this.getSubFilter(this.entry.getName());
            if (this.subFilter != null) {
                this.subDocWriter = this.subFilter.createFilterWriter();
                ((ZipFilterWriter)this.createFilterWriter()).setSubDocWriter(this.subDocWriter);
                return this.openSubDocument();
            }
            DocumentPart dp = new DocumentPart(this.entry.getName(), false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, this.entry);
            return new Event(EventType.DOCUMENT_PART, dp, skel);
        }
        this.close();
        Ending ending = new Ending("ed");
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private IFilter getSubFilter(String name) {
        String configId = "";
        for (int i = 0; i < this.fileNames.length; ++i) {
            String fname = this.fileNames[i];
            if (!StringUtil.matchesWildcard(name, fname, true)) continue;
            configId = this.configIds[i];
            break;
        }
        return this.getFilterConfigurationMapper().createFilter(configId);
    }

    private Event openSubDocument() {
        Event event;
        if (this.subFilter != null) {
            this.subFilter.close();
        }
        try {
            this.subFilter.open(new RawDocument(this.zipFile.getInputStream(this.entry), "UTF-8", this.srcLoc, this.trgLoc));
            event = this.subFilter.next();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening internal file.", e);
        }
        StartDocument sd = null;
        StartSubDocument ssd = null;
        if (event.getEventType() == EventType.START_DOCUMENT) {
            sd = (StartDocument)event.getResource();
            ssd = new StartSubDocument("sd", sd.getId());
            this.saveStartDoc = sd;
        } else {
            ssd = new StartSubDocument("sd", String.valueOf(++this.subDocId));
        }
        ResourceUtil.copyProperties(sd, ssd);
        ssd.setName(this.docURI.getPath() + "/" + this.entry.getName());
        this.nextAction = NextAction.NEXTINSUBDOC;
        ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile, this.entry);
        return new Event(EventType.START_SUBDOCUMENT, ssd, skel);
    }

    private Event nextInSubDocument() {
        if (this.saveStartDoc != null && this.subDocWriter != null) {
            this.subDocWriter.getSkeletonWriter().processStartDocument(this.trgLoc, "UTF-8", null, this.subDocWriter.getEncoderManager(), this.saveStartDoc);
            this.saveStartDoc = null;
        }
        if (this.subFilter.hasNext()) {
            Event event = this.subFilter.next();
            switch (event.getEventType()) {
                case END_DOCUMENT: {
                    Ending ending = (Ending)event.getResource();
                    this.nextAction = NextAction.NEXTINZIP;
                    ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile, this.entry);
                    return new Event(EventType.END_SUBDOCUMENT, ending, skel);
                }
            }
            return event;
        }
        return null;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return false;
    }

    @Override
    protected boolean isUtf8Bom() {
        return false;
    }

    private static enum NextAction {
        OPENZIP,
        NEXTINZIP,
        NEXTINSUBDOC,
        DONE;

    }
}

