/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexTokenizer {
    protected String s;
    protected int i = 0;
    protected boolean firstRun = true;
    protected IdentityHashMap<Matcher, Matcher> matchers = new IdentityHashMap();
    protected Matcher currentPrefixMatcher = null;
    private HashMap<Matcher, HashSet<Tuple>> history = new HashMap();

    protected Matcher getPrefixMatcher() {
        Matcher newMatcher;
        if (this.currentPrefixMatcher != null) {
            return this.currentPrefixMatcher;
        }
        while (true) {
            newMatcher = null;
            int location = this.s.length();
            for (Map.Entry<Matcher, Matcher> e : this.matchers.entrySet()) {
                Matcher m = e.getKey();
                if (!m.find(this.i) || m.start() >= location) continue;
                newMatcher = m;
                location = m.start();
            }
            if (!this.isDuplicate(newMatcher) || this.i >= this.s.length()) break;
            ++this.i;
        }
        this.currentPrefixMatcher = newMatcher;
        this.cache(newMatcher);
        return newMatcher;
    }

    protected void cache(Matcher m) {
        if (m == null) {
            return;
        }
        if (m.start() != m.end()) {
            return;
        }
        HashSet<Tuple> h = this.history.get(m);
        if (h == null) {
            h = new HashSet();
            this.history.put(m, h);
        }
        h.add(new Tuple(m.start(), m.end()));
    }

    protected boolean isDuplicate(Matcher m) {
        if (m == null || m.end() > this.i) {
            return false;
        }
        HashSet<Tuple> h = this.history.get(m);
        return h != null && h.contains(new Tuple(m.start(), m.end()));
    }

    public final class MatchRecord {
        public final MatchResult result;
        public final Pattern pattern;

        public MatchRecord(Matcher m) {
            this.result = m.toMatchResult();
            this.pattern = m.pattern();
        }
    }

    public class Token {
        private final MatchRecord f;
        private final MatchRecord b;

        public Token(MatchRecord front, MatchRecord back) {
            this.f = front;
            this.b = back;
        }

        public Token(Matcher front, Matcher back) {
            this.f = front != null ? new MatchRecord(front) : null;
            this.b = back != null ? new MatchRecord(back) : null;
        }

        public String toString() {
            int start;
            int n = start = this.f != null ? this.f.result.end() : 0;
            if (start >= RegexTokenizer.this.s.length()) {
                return "";
            }
            int end = this.b != null ? this.b.result.start() : RegexTokenizer.this.s.length();
            return RegexTokenizer.this.s.substring(start, end);
        }

        public String prefix() {
            return this.f != null ? this.f.result.group() : null;
        }

        public Pattern prefixPattern() {
            return this.f != null ? this.f.pattern : null;
        }

        public String suffix() {
            return this.b != null ? this.b.result.group() : null;
        }

        public Pattern suffixPattern() {
            return this.b != null ? this.b.pattern : null;
        }
    }

    public final class Tuple {
        private final int x;
        private final int y;

        public Tuple(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tuple other = (Tuple)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        private RegexTokenizer getOuterType() {
            return RegexTokenizer.this;
        }
    }
}

