/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiUnexpectedRevisionException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

abstract class ElementSkipperStrategy {
    protected Set<String> skippableElementValues;

    protected ElementSkipperStrategy(Set<String> skippableElementValues) {
        this.skippableElementValues = skippableElementValues;
    }

    abstract boolean canSkip(StartElement var1, StartElement var2);

    void skip(StartElementContext startElementContext) throws XMLStreamException {
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent e = startElementContext.getEventReader().nextEvent();
            if (!XMLEventHelpers.isEndElement(e, startElementContext.getStartElement())) continue;
            return;
        }
        throw new IllegalStateException("Unexpected structure");
    }

    static class BookmarkElementSkipperStrategy
    extends ElementSkipperStrategy {
        private String bookmarkName;
        private String bookmarkId;

        BookmarkElementSkipperStrategy(Set<String> skippableElementValues, String bookmarkName) {
            super(skippableElementValues);
            this.bookmarkName = bookmarkName;
        }

        @Override
        boolean canSkip(StartElement startElement, StartElement parentStartElement) {
            return BookmarkElementSkipperStrategy.isBookmarkStartElement(startElement) && this.bookmarkName.equals(XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_NAME)) || BookmarkElementSkipperStrategy.isBookmarkEndElement(startElement) && Objects.equals(this.bookmarkId, XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_ID));
        }

        @Override
        void skip(StartElementContext startElementContext) throws XMLStreamException {
            super.skip(startElementContext);
            if (BookmarkElementSkipperStrategy.isBookmarkStartElement(startElementContext.getStartElement())) {
                this.bookmarkId = XMLEventHelpers.getAttributeValue(startElementContext.getStartElement(), XMLEventHelpers.WPML_ID);
                return;
            }
            this.bookmarkId = null;
        }

        private static boolean isBookmarkStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_START.getValue());
        }

        private static boolean isBookmarkEndElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_END.getValue());
        }
    }

    static class GeneralElementSkipperStrategy
    extends ElementSkipperStrategy {
        public static final String LOCAL_NUMBERING_PROPERTIES = "numPr";
        private static final Map<String, String> ADAPTABLE_SKIPPABLE_ELEMENTS = new HashMap<String, String>();
        private static final Set<String> REVISION_SKIPPABLE_ELEMENTS = new HashSet<String>();
        private ConditionalParameters conditionalParameters;

        GeneralElementSkipperStrategy(Set<String> skippableElementValues, ConditionalParameters conditionalParameters) {
            super(skippableElementValues);
            this.conditionalParameters = conditionalParameters;
        }

        @Override
        boolean canSkip(StartElement startElement, StartElement parentStartElement) {
            return this.skippableElementValues.contains(startElement.getName().getLocalPart()) && (this.conditionalParameters.getAutomaticallyAcceptRevisions() || !GeneralElementSkipperStrategy.isPresentInAdaptableSkippableElements(startElement, parentStartElement));
        }

        private static boolean isPresentInAdaptableSkippableElements(StartElement startElement, StartElement parentStartElement) {
            if (null == parentStartElement) {
                return false;
            }
            for (Map.Entry<String, String> entry : ADAPTABLE_SKIPPABLE_ELEMENTS.entrySet()) {
                if (!parentStartElement.getName().getLocalPart().equals(entry.getKey()) || !startElement.getName().getLocalPart().equals(entry.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        void skip(StartElementContext startElementContext) throws XMLStreamException {
            if (!startElementContext.getConditionalParameters().getAutomaticallyAcceptRevisions() && REVISION_SKIPPABLE_ELEMENTS.contains(startElementContext.getStartElement().getName().getLocalPart())) {
                throw new OkapiUnexpectedRevisionException();
            }
            if (ElementSkipper.InlineSkippableElement.class == startElementContext.getSkippableElementType() && ElementSkipper.RevisionInlineSkippableElement.RUN_INSERTED_CONTENT.getValue().equals(startElementContext.getStartElement().getName().getLocalPart())) {
                return;
            }
            super.skip(startElementContext);
        }

        static {
            ADAPTABLE_SKIPPABLE_ELEMENTS.put(LOCAL_NUMBERING_PROPERTIES, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK.getValue());
            ADAPTABLE_SKIPPABLE_ELEMENTS.put("tblPr", ElementSkipper.RevisionPropertySkippableElement.TABLE_PROPERTIES_CHANGE.getValue());
            ADAPTABLE_SKIPPABLE_ELEMENTS.put("tblGrid", ElementSkipper.RevisionPropertySkippableElement.TABLE_GRID_CHANGE.getValue());
            REVISION_SKIPPABLE_ELEMENTS.addAll(ElementSkipper.RevisionInlineSkippableElement.getValues());
            REVISION_SKIPPABLE_ELEMENTS.addAll(ElementSkipper.RevisionPropertySkippableElement.getValues());
        }
    }
}

