/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentTypes;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelDocument;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.PowerpointDocument;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.VisioDocument;
import net.sf.okapi.filters.openxml.WordDocument;

public class OpenXMLZipFile {
    private ZipFile zipFile;
    private String encoding;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private XMLEventFactory eventFactory;
    protected ContentTypes contentTypes;
    protected String mainDocumentTarget;
    public static final String CONTENT_TYPES_PART = "[Content_Types].xml";
    public static final String ROOT_RELS_PART = "_rels/.rels";
    private static final String OFFICE_DOCUMENT_SOURCE_TYPE = Namespaces.DocumentRelationships.getDerivedURI("/officeDocument");
    private static final String VISIO_DOCUMENT_SOURCE_TYPE = Namespaces.VisioDocumentRelationships.getDerivedURI("/document");
    private static final int MAX_ATTRIBUTE_SIZE = 0x200000;

    public OpenXMLZipFile(ZipFile zipFile, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String encoding) {
        this.zipFile = zipFile;
        this.inputFactory = inputFactory;
        if (inputFactory.isPropertySupported("com.ctc.wstx.maxAttributeSize")) {
            inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", 0x200000);
        }
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.encoding = encoding;
    }

    protected void initializeContentTypes() throws XMLStreamException, IOException {
        if (this.contentTypes == null) {
            this.contentTypes = new ContentTypes(this.inputFactory);
            this.contentTypes.parseFromXML(this.getPartReader(CONTENT_TYPES_PART));
        }
    }

    public DocumentType createDocument(ConditionalParameters params) throws XMLStreamException, IOException {
        DocumentType doc;
        this.initializeContentTypes();
        this.mainDocumentTarget = this.getRelationshipTarget();
        switch (this.contentTypes.getContentType(this.mainDocumentTarget)) {
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": {
                doc = new WordDocument(this, params);
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
                doc = new ExcelDocument(this, params, null);
                break;
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": {
                doc = new PowerpointDocument(this, params);
                break;
            }
            case "application/vnd.ms-visio.drawing.main+xml": 
            case "application/vnd.ms-visio.drawing.macroEnabled.main+xml": {
                doc = new VisioDocument(this, params);
                break;
            }
            default: {
                throw new OkapiBadFilterInputException("Unrecognized main document target: " + this.mainDocumentTarget);
            }
        }
        doc.initialize();
        return doc;
    }

    public ContentTypes getContentTypes() throws XMLStreamException, IOException {
        return this.contentTypes;
    }

    public XMLInputFactory getInputFactory() {
        return this.inputFactory;
    }

    public XMLOutputFactory getOutputFactory() {
        return this.outputFactory;
    }

    public XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    public String getMainDocumentTarget() {
        return this.mainDocumentTarget;
    }

    protected String getRelationshipTarget() throws IOException, XMLStreamException {
        List<Relationships.Rel> docRels = this.getRelationships(ROOT_RELS_PART).getRelByType(OFFICE_DOCUMENT_SOURCE_TYPE);
        if (null != docRels) {
            return docRels.get((int)0).target;
        }
        docRels = this.getRelationships(ROOT_RELS_PART).getRelByType(VISIO_DOCUMENT_SOURCE_TYPE);
        if (null != docRels) {
            return docRels.get((int)0).target;
        }
        return null;
    }

    public Reader getPartReader(String partName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(partName);
        if (entry == null) {
            throw new OkapiBadFilterInputException("File is missing " + partName);
        }
        return Util.skipBOM(new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding));
    }

    private boolean isDocumentPartAvailable(String partName) {
        return this.zipFile.getEntry(partName) != null;
    }

    public Relationships getRelationships(String relsPartName) throws IOException, XMLStreamException {
        Relationships rels = new Relationships(this.inputFactory);
        if (this.isDocumentPartAvailable(relsPartName)) {
            rels.parseFromXML(relsPartName, this.getPartReader(relsPartName));
        }
        return rels;
    }

    public Relationships getRelationshipsForTarget(String target) throws IOException, XMLStreamException {
        int lastSlash = target.lastIndexOf("/");
        if (lastSlash == -1) {
            return this.getRelationships("_rels/" + target + ".rels");
        }
        String relPart = target.substring(0, lastSlash) + "/_rels" + target.substring(lastSlash) + ".rels";
        return this.getRelationships(relPart);
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.zipFile.getInputStream(entry);
    }

    public ZipFile getZip() {
        return this.zipFile;
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public Enumeration<? extends ZipEntry> entries() {
        return this.zipFile.entries();
    }
}

