/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.util.HashMap;
import java.util.Map;

class CodeTypeForPairedTagsHelper {
    public static final String DEFAULT_CODE_TYPE = "Xpt";
    private Map<String, String> codeTypesById = new HashMap<String, String>();
    private Map<String, String> codeTypesByRid = new HashMap<String, String>();

    CodeTypeForPairedTagsHelper() {
    }

    public String store(String rid, String id, String ctype) {
        String codeType = this.getNonEmptyCodeType(ctype);
        if (rid != null) {
            this.codeTypesByRid.put(rid, codeType);
        }
        if (id != null) {
            this.codeTypesById.put(id, codeType);
        }
        return codeType;
    }

    public String find(String rid, String id) {
        String ctype = null;
        if (rid != null && this.codeTypesByRid.containsKey(rid)) {
            ctype = this.codeTypesByRid.get(rid);
        } else if (id != null && this.codeTypesById.containsKey(id)) {
            ctype = this.codeTypesById.get(id);
        }
        return this.getNonEmptyCodeType(ctype);
    }

    private String getNonEmptyCodeType(String ctype) {
        return ctype != null && ctype.trim().length() > 0 ? ctype : DEFAULT_CODE_TYPE;
    }
}

