/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.beans.v1.CodeBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;

public class TextFragmentBean
extends PersistenceBean<TextFragment> {
    private String text;
    private List<CodeBean> codes = new ArrayList<CodeBean>();

    @Override
    protected TextFragment createObject(IPersistenceSession session) {
        return new TextFragment();
    }

    @Override
    protected void fromObject(TextFragment obj, IPersistenceSession session) {
        this.text = obj.getCodedText();
        for (Code code : obj.getCodes()) {
            CodeBean codeBean = new CodeBean();
            codeBean.set(code, session);
            this.codes.add(codeBean);
        }
    }

    @Override
    protected void setObject(TextFragment obj, IPersistenceSession session) {
        ArrayList<Code> newCodes = new ArrayList<Code>();
        for (CodeBean code : this.codes) {
            newCodes.add(code.get(Code.class, session));
        }
        obj.setCodedText(this.text, newCodes);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<CodeBean> getCodes() {
        return this.codes;
    }

    public void setCodes(List<CodeBean> codes) {
        this.codes = codes;
    }
}

