/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.ClosePanel;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.ui.segmentation.LanguageMapDialog;
import net.sf.okapi.lib.ui.segmentation.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GroupsAndOptionsDialog {
    private Shell shell;
    private List lbLangRules;
    private List lbLangMaps;
    private SRXDocument srxDoc;
    private Button btAddRules;
    private Button btRenameRules;
    private Button btRemoveRules;
    private Button btAddMap;
    private Button btEditMap;
    private Button btRemoveMap;
    private Button btMoveUpMap;
    private Button btMoveDownMap;
    private Button chkSegmentSubFlows;
    private Button chkCascade;
    private Button chkUseIcu4jBreak;
    private Button chkIncludeOpeningCodes;
    private Button chkIncludeClosingCodes;
    private Button chkIncludeIsolatedCodes;
    private Button chkOneSegmentIncludesAll;
    private Button chkTrimLeadingWS;
    private Button chkTrimTrailingWS;
    private Button chkTreatIsolatedCodesAsWhitespace;
    private ClosePanel pnlActions;
    private IHelp help;
    private Text edHeaderComments;
    private Text edDocComments;

    public GroupsAndOptionsDialog(Shell parent, SRXDocument srxDoc, IHelp helpParam) {
        this.help = helpParam;
        this.srxDoc = srxDoc;
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("options.caption"));
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout(new GridLayout(2, true));
        Group grpTmp = new Group(this.shell, 0);
        grpTmp.setText(Res.getString("options.grpOptions"));
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        grpTmp.setLayoutData(gdTmp);
        GridLayout layTmp = new GridLayout(2, false);
        grpTmp.setLayout(layTmp);
        this.chkCascade = new Button(grpTmp, 32);
        this.chkCascade.setText(Res.getString("options.cascade"));
        this.chkIncludeOpeningCodes = new Button(grpTmp, 32);
        this.chkIncludeOpeningCodes.setText(Res.getString("options.includeStartCodes"));
        this.chkSegmentSubFlows = new Button(grpTmp, 32);
        this.chkSegmentSubFlows.setText(Res.getString("options.segmentSubFlow"));
        this.chkIncludeClosingCodes = new Button(grpTmp, 32);
        this.chkIncludeClosingCodes.setText(Res.getString("options.includeEndCodes"));
        new Label(grpTmp, 0);
        this.chkIncludeIsolatedCodes = new Button(grpTmp, 32);
        this.chkIncludeIsolatedCodes.setText(Res.getString("options.includeIsolatedCodes"));
        grpTmp = new Group(this.shell, 0);
        grpTmp.setText(Res.getString("options.grpExtensions"));
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        grpTmp.setLayoutData(gdTmp);
        layTmp = new GridLayout(2, false);
        grpTmp.setLayout(layTmp);
        this.chkUseIcu4jBreak = new Button(grpTmp, 32);
        this.chkUseIcu4jBreak.setText(Res.getString("options.useIcu4jBreak"));
        this.chkTrimLeadingWS = new Button(grpTmp, 32);
        this.chkTrimLeadingWS.setText(Res.getString("options.trimLeadingWS"));
        this.chkOneSegmentIncludesAll = new Button(grpTmp, 32);
        this.chkOneSegmentIncludesAll.setText(Res.getString("options.includeAllInOne"));
        this.chkTrimTrailingWS = new Button(grpTmp, 32);
        this.chkTrimTrailingWS.setText(Res.getString("options.trimtrailingWS"));
        this.chkTreatIsolatedCodesAsWhitespace = new Button(grpTmp, 32);
        this.chkTreatIsolatedCodesAsWhitespace.setText(Res.getString("options.treatIsolatedCodesAsWhitespace"));
        Label label = new Label(grpTmp, 0);
        label.setText(Res.getString("GroupsAndOptionsDialog.headerComments"));
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        label.setLayoutData(gdTmp);
        this.edHeaderComments = new Text(grpTmp, 2562);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        gdTmp.heightHint = 40;
        this.edHeaderComments.setLayoutData(gdTmp);
        grpTmp = new Group(this.shell, 0);
        grpTmp.setText(Res.getString("options.grpLangRules"));
        gdTmp = new GridData(1808);
        grpTmp.setLayoutData(gdTmp);
        layTmp = new GridLayout(2, false);
        grpTmp.setLayout(layTmp);
        int listWidthHint = 150;
        this.lbLangRules = new List(grpTmp, 2560);
        gdTmp = new GridData(1808);
        gdTmp.verticalSpan = 1;
        gdTmp.widthHint = listWidthHint;
        this.lbLangRules.setLayoutData(gdTmp);
        this.lbLangRules.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.updateRulesButtons();
            }
        });
        Composite cmpTmp = new Composite(grpTmp, 0);
        layTmp = new GridLayout(1, true);
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp.setLayout(layTmp);
        gdTmp = new GridData(2);
        cmpTmp.setLayoutData(gdTmp);
        int buttonWidth = 80;
        this.btAddRules = new Button(cmpTmp, 8);
        this.btAddRules.setText(Res.getString("options.addRules"));
        gdTmp = new GridData(770);
        this.btAddRules.setLayoutData(gdTmp);
        UIUtil.ensureWidth(this.btAddRules, buttonWidth);
        this.btAddRules.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.editRules(true);
            }
        });
        this.btRenameRules = new Button(cmpTmp, 8);
        this.btRenameRules.setText(Res.getString("options.renameRules"));
        gdTmp = new GridData(770);
        this.btRenameRules.setLayoutData(gdTmp);
        this.btRenameRules.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.editRules(false);
            }
        });
        this.btRemoveRules = new Button(cmpTmp, 8);
        this.btRemoveRules.setText(Res.getString("options.removeRules"));
        gdTmp = new GridData(770);
        this.btRemoveRules.setLayoutData(gdTmp);
        this.btRemoveRules.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.removeRules();
            }
        });
        grpTmp = new Group(this.shell, 0);
        grpTmp.setText(Res.getString("options.grpLangMaps"));
        gdTmp = new GridData(1808);
        grpTmp.setLayoutData(gdTmp);
        layTmp = new GridLayout(2, false);
        grpTmp.setLayout(layTmp);
        this.lbLangMaps = new List(grpTmp, 2560);
        gdTmp = new GridData(1808);
        gdTmp.verticalSpan = 1;
        gdTmp.widthHint = listWidthHint;
        this.lbLangMaps.setLayoutData(gdTmp);
        this.lbLangMaps.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.updateMapsButtons();
            }
        });
        cmpTmp = new Composite(grpTmp, 0);
        layTmp = new GridLayout(1, true);
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp.setLayout(layTmp);
        gdTmp = new GridData(2);
        cmpTmp.setLayoutData(gdTmp);
        this.btAddMap = new Button(cmpTmp, 8);
        this.btAddMap.setText(Res.getString("options.addMap"));
        gdTmp = new GridData(770);
        this.btAddMap.setLayoutData(gdTmp);
        UIUtil.ensureWidth(this.btAddMap, buttonWidth);
        this.btAddMap.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.editMap(true);
            }
        });
        this.btEditMap = new Button(cmpTmp, 8);
        this.btEditMap.setText(Res.getString("options.editMap"));
        gdTmp = new GridData(770);
        this.btEditMap.setLayoutData(gdTmp);
        this.btEditMap.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.editMap(false);
            }
        });
        this.btRemoveMap = new Button(cmpTmp, 8);
        this.btRemoveMap.setText(Res.getString("options.removeMap"));
        gdTmp = new GridData(770);
        this.btRemoveMap.setLayoutData(gdTmp);
        this.btRemoveMap.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.removeMap();
            }
        });
        this.btMoveUpMap = new Button(cmpTmp, 8);
        this.btMoveUpMap.setText(Res.getString("options.moveUpMap"));
        gdTmp = new GridData(770);
        this.btMoveUpMap.setLayoutData(gdTmp);
        this.btMoveUpMap.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.moveUpMap();
            }
        });
        this.btMoveDownMap = new Button(cmpTmp, 8);
        this.btMoveDownMap.setText(Res.getString("options.moveDownMap"));
        gdTmp = new GridData(770);
        this.btMoveDownMap.setLayoutData(gdTmp);
        this.btMoveDownMap.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GroupsAndOptionsDialog.this.moveDownMap();
            }
        });
        grpTmp = new Group(this.shell, 0);
        grpTmp.setText(Res.getString("GroupsAndOptionsDialog.docComments"));
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        grpTmp.setLayoutData(gdTmp);
        grpTmp.setLayout(new GridLayout());
        this.edDocComments = new Text(grpTmp, 2562);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 60;
        this.edDocComments.setLayoutData(gdTmp);
        this.shell.addShellListener(new ShellListener(){

            @Override
            public void shellActivated(ShellEvent event) {
            }

            @Override
            public void shellClosed(ShellEvent event) {
                if (!GroupsAndOptionsDialog.this.validate()) {
                    event.doit = false;
                } else {
                    GroupsAndOptionsDialog.this.getOptions();
                }
            }

            @Override
            public void shellDeactivated(ShellEvent event) {
            }

            @Override
            public void shellDeiconified(ShellEvent event) {
            }

            @Override
            public void shellIconified(ShellEvent event) {
            }
        });
        SelectionAdapter CloseActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (GroupsAndOptionsDialog.this.help != null) {
                        GroupsAndOptionsDialog.this.help.showWiki("Ratel - Groups and Options");
                    }
                    return;
                }
                if (e.widget.getData().equals("c")) {
                    GroupsAndOptionsDialog.this.shell.close();
                }
            }
        };
        this.pnlActions = new ClosePanel(this.shell, 0, CloseActions, true);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.pnlActions.setLayoutData(gdTmp);
        this.shell.setDefaultButton(this.pnlActions.btClose);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.y < 400) {
            startSize.y = 400;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
        this.setOptions();
        this.updateLanguageRules(null);
        this.updateLanguageMaps(0);
    }

    public void showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void setOptions() {
        this.chkSegmentSubFlows.setSelection(this.srxDoc.segmentSubFlows());
        this.chkCascade.setSelection(this.srxDoc.cascade());
        this.chkIncludeOpeningCodes.setSelection(this.srxDoc.includeStartCodes());
        this.chkIncludeClosingCodes.setSelection(this.srxDoc.includeEndCodes());
        this.chkIncludeIsolatedCodes.setSelection(this.srxDoc.includeIsolatedCodes());
        this.chkOneSegmentIncludesAll.setSelection(this.srxDoc.oneSegmentIncludesAll());
        this.chkUseIcu4jBreak.setSelection(this.srxDoc.useIcu4JBreakRules());
        this.chkTrimLeadingWS.setSelection(this.srxDoc.trimLeadingWhitespaces());
        this.chkTrimTrailingWS.setSelection(this.srxDoc.trimTrailingWhitespaces());
        this.chkTreatIsolatedCodesAsWhitespace.setSelection(this.srxDoc.treatIsolatedCodesAsWhitespace());
        String tmp = this.srxDoc.getHeaderComments();
        this.edHeaderComments.setText(tmp == null ? "" : tmp);
        tmp = this.srxDoc.getComments();
        this.edDocComments.setText(tmp == null ? "" : tmp);
    }

    private void getOptions() {
        this.srxDoc.setSegmentSubFlows(this.chkSegmentSubFlows.getSelection());
        this.srxDoc.setCascade(this.chkCascade.getSelection());
        this.srxDoc.setUseICU4JBreakRules(this.chkUseIcu4jBreak.getSelection());
        this.srxDoc.setIncludeStartCodes(this.chkIncludeOpeningCodes.getSelection());
        this.srxDoc.setIncludeEndCodes(this.chkIncludeClosingCodes.getSelection());
        this.srxDoc.setIncludeIsolatedCodes(this.chkIncludeIsolatedCodes.getSelection());
        this.srxDoc.setOneSegmentIncludesAll(this.chkOneSegmentIncludesAll.getSelection());
        this.srxDoc.setTrimLeadingWhitespaces(this.chkTrimLeadingWS.getSelection());
        this.srxDoc.setTrimTrailingWhitespaces(this.chkTrimTrailingWS.getSelection());
        this.srxDoc.setTreatIsolatedCodesAsWhitespace(this.chkTreatIsolatedCodesAsWhitespace.getSelection());
        String tmp = this.edHeaderComments.getText();
        this.srxDoc.setHeaderComments(tmp.replace("\r\n", "\n"));
        tmp = this.edDocComments.getText();
        this.srxDoc.setComments(tmp.replace("\r\n", "\n"));
    }

    private void updateRulesButtons() {
        boolean enabled = this.lbLangRules.getSelectionIndex() != -1;
        this.btRenameRules.setEnabled(enabled);
        this.btRemoveRules.setEnabled(enabled);
    }

    private void updateLanguageRules(String selection) {
        this.lbLangRules.removeAll();
        LinkedHashMap list = this.srxDoc.getAllLanguageRules();
        if (selection != null && !list.containsKey(selection)) {
            selection = null;
        }
        for (String ruleName : list.keySet()) {
            this.lbLangRules.add(ruleName);
            if (selection != null) continue;
            selection = ruleName;
        }
        if (this.lbLangRules.getItemCount() > 0 && selection != null) {
            this.lbLangRules.select(this.lbLangRules.indexOf(selection));
        }
        this.updateRulesButtons();
    }

    private void updateMapsButtons() {
        int n = this.lbLangMaps.getSelectionIndex();
        boolean enabled = n != -1;
        this.btEditMap.setEnabled(enabled);
        this.btRemoveMap.setEnabled(enabled);
        this.btMoveUpMap.setEnabled(n > 0);
        this.btMoveDownMap.setEnabled(n < this.lbLangMaps.getItemCount() - 1);
    }

    private void updateLanguageMaps(int selection) {
        this.lbLangMaps.removeAll();
        ArrayList list = this.srxDoc.getAllLanguagesMaps();
        for (LanguageMap langMap : list) {
            this.lbLangMaps.add(langMap.getPattern() + " --> " + langMap.getRuleName());
        }
        if (selection < 0 || selection >= this.lbLangMaps.getItemCount()) {
            selection = 0;
        }
        if (this.lbLangMaps.getItemCount() > 0) {
            this.lbLangMaps.select(selection);
        }
        this.updateMapsButtons();
    }

    private void editMap(boolean createNewMap) {
        LanguageMap langMap;
        int n = -1;
        if (createNewMap) {
            langMap = new LanguageMap("", "");
        } else {
            n = this.lbLangMaps.getSelectionIndex();
            if (n == -1) {
                return;
            }
            langMap = (LanguageMap)this.srxDoc.getAllLanguagesMaps().get(n);
        }
        LanguageMapDialog dlg = new LanguageMapDialog(this.shell, langMap, this.help);
        langMap = dlg.showDialog();
        if (langMap == null) {
            return;
        }
        if (createNewMap) {
            this.srxDoc.addLanguageMap(langMap);
            n = this.srxDoc.getAllLanguagesMaps().size() + 1;
        } else {
            this.srxDoc.getAllLanguagesMaps().set(n, langMap);
        }
        this.srxDoc.setModified(true);
        this.updateLanguageMaps(n);
    }

    private void removeMap() {
        int n = this.lbLangMaps.getSelectionIndex();
        if (n == -1) {
            return;
        }
        this.srxDoc.getAllLanguagesMaps().remove(n);
        this.srxDoc.setModified(true);
        this.updateLanguageMaps(n);
    }

    private void moveUpMap() {
        int n = this.lbLangMaps.getSelectionIndex();
        if (n < 1) {
            return;
        }
        LanguageMap tmp = (LanguageMap)this.srxDoc.getAllLanguagesMaps().get(n - 1);
        this.srxDoc.getAllLanguagesMaps().set(n - 1, this.srxDoc.getAllLanguagesMaps().get(n));
        this.srxDoc.getAllLanguagesMaps().set(n, tmp);
        this.srxDoc.setModified(true);
        this.updateLanguageMaps(--n);
    }

    private void moveDownMap() {
        int n = this.lbLangMaps.getSelectionIndex();
        if (n > this.lbLangMaps.getItemCount() - 2) {
            return;
        }
        LanguageMap tmp = (LanguageMap)this.srxDoc.getAllLanguagesMaps().get(n + 1);
        this.srxDoc.getAllLanguagesMaps().set(n + 1, this.srxDoc.getAllLanguagesMaps().get(n));
        this.srxDoc.getAllLanguagesMaps().set(n, tmp);
        this.srxDoc.setModified(true);
        this.updateLanguageMaps(++n);
    }

    private void editRules(boolean createNewRules) {
        String name;
        block6: {
            String oldName;
            block5: {
                String caption;
                oldName = null;
                if (createNewRules) {
                    name = String.format(Res.getString("options.defaultGroupName"), this.srxDoc.getAllLanguageRules().size() + 1);
                    caption = Res.getString("options.newGroupCaption");
                } else {
                    int n = this.lbLangRules.getSelectionIndex();
                    if (n == -1) {
                        return;
                    }
                    oldName = name = this.lbLangRules.getItem(n);
                    caption = Res.getString("options.renameGroupCaption");
                }
                while (true) {
                    InputDialog dlg;
                    if ((name = (dlg = new InputDialog(this.shell, caption, Res.getString("options.groupNameLabel"), name, null, 0, -1, -1)).showDialog()) == null) {
                        return;
                    }
                    if (!createNewRules) break block5;
                    if (!this.srxDoc.getAllLanguageRules().containsKey(name)) break;
                    Dialogs.showError(this.shell, String.format(Res.getString("options.sameNameError"), name), null);
                }
                this.srxDoc.addLanguageRule(name, new ArrayList());
                break block6;
            }
            ArrayList list = this.srxDoc.getLanguageRules(oldName);
            this.srxDoc.getAllLanguageRules().remove(oldName);
            this.srxDoc.addLanguageRule(name, list);
        }
        this.updateLanguageRules(name);
    }

    private void removeRules() {
        int n = this.lbLangRules.getSelectionIndex();
        if (n == -1) {
            return;
        }
        String ruleName = this.lbLangRules.getItem(n);
        MessageBox dlg = new MessageBox(this.shell, 452);
        dlg.setText(this.shell.getText());
        dlg.setMessage(String.format(Res.getString("options.confirmRemoveRules"), ruleName));
        switch (dlg.open()) {
            case 128: 
            case 256: {
                return;
            }
        }
        this.srxDoc.getAllLanguageRules().remove(ruleName);
        this.srxDoc.setModified(true);
        this.updateLanguageRules(null);
    }

    private boolean validate() {
        try {
            int nonexistingRules = 0;
            StringBuilder notMapped = new StringBuilder();
            LinkedHashMap list = this.srxDoc.getAllLanguageRules();
            for (LanguageMap langRule : this.srxDoc.getAllLanguagesMaps()) {
                if (list.containsKey(langRule.getRuleName())) continue;
                if (nonexistingRules > 0) {
                    notMapped.append(", ");
                }
                notMapped.append(langRule.getRuleName());
                ++nonexistingRules;
            }
            if (nonexistingRules == 0) {
                return true;
            }
            MessageBox dlg = new MessageBox(this.shell, 456);
            dlg.setText(this.shell.getText());
            dlg.setMessage(String.format(Res.getString("options.badNamesError"), nonexistingRules, notMapped.toString()));
            switch (dlg.open()) {
                case 128: 
                case 256: {
                    return false;
                }
                case 64: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            return false;
        }
        return true;
    }
}

